
#include <lber.h>
#include "ldap.h"
#include <iostream.h>
#include <stdio.h>
#include <String.h>

void PrintEntry(LDAP *ldap_server, LDAPMessage* entry) {

    char *a, *dn;
    BerElement *ber;
    char** values;
    int numValues;
    int i;

    dn = ldap_get_dn(ldap_server,entry);
    cout << dn << ":" << endl;
    delete dn;

    for (a = ldap_first_attribute(ldap_server,entry,&ber); a != NULL;
	 a = ldap_next_attribute(ldap_server,entry,ber) ) {

      values = ldap_get_values(ldap_server,entry,a);
      numValues = ldap_count_values(values);

      cout << "\t" << a << "(" << numValues << "):"; 
      for(i=0;i<numValues;i++) {
	cout << " " << values[i];
      }
      ldap_value_free(values);
      cout << endl;
    }
    
    cout << endl;
}

main(int argc, char** argv) {

  LDAP *ldap_server;
  int ret;
  int rc;
  int matches;
  int first;
  LDAPMessage* reply;
  LDAPMessage* entry;
  String searchString;

  cout << "opening..." << endl;

  if ((ldap_server = ldap_open("globus.org",389)) == NULL) {
    perror("ldap_open");
    exit(1);
  }

  cout << "binding..." << endl;

  //  if ((ret = ldap_simple_bind_s(ldap_server,"webadmin","WWWadmin"))
  if ((ret = ldap_simple_bind_s(ldap_server,"",""))
      != LDAP_SUCCESS) {
    perror("ldap_simple_bind_s");
    exit(1);
  }

  cout << "searching..." << endl;

  char *tempSStr;
  searchString = "hn=spnode009.mcs.anl.gov";
  tempSStr = new char[searchString.length()+1];
  strcpy(tempSStr,searchString.chars());

  if (ldap_search_s(ldap_server,"o=Globus,c=US",LDAP_SCOPE_SUBTREE,
		   tempSStr,NULL,0,&reply) == -1 ) {
    perror("ldap_search");
    exit(1);
  }

  cout << "parsing reply..." << endl;

  for(entry=ldap_first_entry(ldap_server,reply);entry!=NULL;
      entry=ldap_next_entry(ldap_server,entry)) {
    PrintEntry(ldap_server,entry);
  }

  cout << "unbinding..." << endl;

  ldap_unbind(ldap_server);

}

