/* *********************************************************************

  C-API Test for the MDS
  Authors:                    Gregor von Laszewski, Warren Smith
  Organization:               Argonne National Laboratory 
  e-mail:                     gregor@mcs.anl.gov
  Version:                    0.1

  ***********************************************************************

  NAME: ldap_test.c

  DESCRIPTION:
    This program opens a connection to the standard MDS server at
    mds.globus.org over the port 389 and pints all
    machines which have the operating system AIX

  BUGS:

  HISTORY:

  ********************************************************************* */


#include <lber.h>
#include "ldap.h"
#include <stdio.h>


/* script which prints all compute resources with 
   osname = aix of a particular site, .e.g. beginning form a base dn */

void PrintEntry(LDAP *ldap_server, LDAPMessage* entry);
void FindMDSInformation (
  char* server,
  int   port,
  char* base_dn,
  char* search_string);


main(int argc, char** argv) {



  char* server       = "mds.globus.org";
  int   port         = 389;
  char* base_dn      = "o=Argonne National Laboratory, o=globus, c=US";
  char* search_string = "osname=AIX";


 FindMDSInformation (server, port, base_dn, search_string);
 exit(0);

}

void FindMDSInformation (char* server,
			 int   port,
			 char* base_dn,
			 char* search_string) {

  LDAP *ldap_server;
  int rc;
  int matches;
  int first;
  LDAPMessage* reply;
  LDAPMessage* entry;

  printf ("Opening to the MDS server: %s on port %d\n", server, port);

  if ((ldap_server = ldap_open(server,port)) == NULL) {
    ldap_perror(ldap_server,"ldap_open");
    exit(1);
  }

  printf ("Authenticate as general user ...\n");

  if (ldap_simple_bind_s(ldap_server,"","") != LDAP_SUCCESS) {
    ldap_perror(ldap_server,"ldap_simple_bind_s");
    exit(1);
  }

  printf ("Searching for entries with property <%s>\n",search_string);

  if (ldap_search_s(ldap_server,base_dn,LDAP_SCOPE_SUBTREE,
		   search_string,NULL,0,&reply) != LDAP_SUCCESS ) {
    ldap_perror(ldap_server,"ldap_search");
    exit(1);
  }

  printf ("Print the result\n");

  for(entry=ldap_first_entry(ldap_server,reply); entry!=NULL;
      entry=ldap_next_entry(ldap_server,entry)) {
    PrintEntry(ldap_server,entry);
  }

  printf ("Disconnect form the MDS server\n");

  ldap_unbind(ldap_server);

}


void PrintEntry(LDAP *ldap_server, LDAPMessage* entry) {

    char *a, *dn;
    BerElement *ber;
    char** values;
    int numValues;
    int i;

    dn = ldap_get_dn(ldap_server,entry);
    printf ("dn: %s\n", dn);

    for (a = ldap_first_attribute(ldap_server,entry,&ber); a != NULL;
	 a = ldap_next_attribute(ldap_server,entry,ber) ) {

      values = ldap_get_values(ldap_server,entry,a);
      numValues = ldap_count_values(values);

      printf ("\t%s(%d):", a, numValues); 
      for(i=0; i<numValues; i++) {
	printf ("\n\t\t%s", values[i]);
      }
      ldap_value_free(values);
      printf ("\n");
    }
    printf ("\n");
}
