#!/local/bin/perl
%ports=(
	'GUSTO',389);

$ldapsearch="/opt/home/bester/ldapsearch";

select STDOUT;
$|=1;

&html_header;
foreach $port (sort keys %ports)
{
	%machine=();
	%installprefix=();
	%releasetag=();
	open(LDAP,"$ldapsearch -p $ports{$port} '(objectclass=GlobusSoftware)' dn releasetag releasemajor releaseminor releasepatch releasebeta installprefix 2> /dev/null |");

	
	while(&read_object) {}

	print "<h2>Testbed $port</h2>";

	&html_table_header;
	foreach $key (sort keys %releasetag) {
	print <<EOF;
		<tr>
        <td>$machine{$key}&nbsp;</td>
	<td>$installprefix{$key}&nbsp;</td>
    	<td>$releasetag{$key}&nbsp;</td>
	</tr>
EOF
	}
	print "</table>\n";
}
	&html_footer;


sub html_header
{
	print <<'EOF';
Content-type: text/html

<html><head><title>Installed Globus Software Releases</title></head>
<body>
EOF
}

sub html_footer
{
	print "</body></html>\n";
}

sub html_table_header
{
	print <<'EOF';
<table border="1">
<tr>
	<td align="center"><b>Machine</b></td>
	<td align="center"><b>Install Directory</b></td>
	<td align="center"><b>Release Tag</b></td>
</tr>
EOF
}

sub html_table_footer
{
	print "</table>\n";
}


sub read_object {
    $type=<LDAP>;
    if(eof(LDAP)){ return 0;}
	if($type =~ m,^sw=,) { &read_sw($type); return 1; }
    while(<LDAP>) {
	if($_ eq "\n") {
	    return 1;
	}
    }
}


sub read_sw {
	chop($dn=$_[0]);
	$dn=~s,^dn=,,;
	$dn=~s/^sw=[^,]*, //;
	$machine{$dn} = $dn;
	$machine{$dn} =~s,hn=,,;
	$machine{$dn} =~s/,.*//;

	while(<LDAP>) {
		if($_ =~ m,^releasetag,) {
			chop($releasetag{$dn}=$_);
			$releasetag{$dn}=~s,^releasetag=,,;
		}
                if($_ =~ m,^releasemajor,) {
                        chop($releasemajor{$dn}=$_);
                        $releasemajor{$dn}=~s,^releasemajor=,,;
                }
                if($_ =~ m,^releaseminor,) {
                        chop($releaseminor{$dn}=$_);
                        $releaseminor{$dn}=~s,^releaseminor=,,;
                }
                if($_ =~ m,^releasepatch,) {
                        chop($releasepatch{$dn}=$_);
                        $releasepatch{$dn}=~s,^releasepatch=,,;
		}
                if($_ =~ m,^releasebeta,) {
                        chop($releasebeta{$dn}=$_);
                        $releasebeta{$dn}=~s,^releasebeta=,,;
                }
		if($_ =~ m,installprefix,) {
			chop($installprefix{$dn}=$_);
			$installprefix{$dn}=$_;
			$installprefix{$dn}=~s/^installprefix=//;
		}
		if($_ eq "\n") {
                     last;
                }
          }
          if($releasetag{$dn} =~ m/undefined/) {
              $releasetag{$dn} =
                  "$releasemajor{$dn}.$releaseminor{$dn}.$releasepatch{$dn}b$releasebeta{$dn}";
          }
}
