#!/local/bin/perl
#!/usr/local/bin/perl5


$GREEN="#00FF00";
$RED="#FF0000";
$BLUE="#0000FF";
$YELLOW="#FFFF00";
$DARKGREY="2F4F4F";
$BLACK="#000000";
$BRONZEII="#8C7853";
$BRONZEI="#A67D3D";

$arg{full} = 0;
$arg{clients} = 1;

&get_arguments;

$filename = $arg{file};
$full = $arg{full};
$with_clients = $arg{clients};

$images="http://www-isi.globus.org/cgi/images";

#print "HHTP/1.0 200 OK\r";
print "Content-type: text/html\n\n";

#$contents = `cd /opt/www/globus-webs/cgi; hbmget`;
$contents = `/opt/www/globus-webs/cgi/hbmget`;

&create_hbm_html_table($contents);

exit;

sub get_arguments {

    $arguments=$ENV{'QUERY_STRING'};


    (@fields) = split("&",$arguments);
    
#    print "@fields <br>\n";
#    print "$#fields\n";

    for ($i=0; $i <= $#fields; $i++) {
     
	$line = $fields[$i];
#	 print "$line<br>\n";
	($name,$value) = split(':',$line);
	$arg{$name} = $value;

#	print "[$name], [$value], [$line] [$arg{$name}]<br>\n";
     }

}			


sub parse_header {

  ($checkpoint_time) = @_;
  # HBMDC CHECKPOINT;1997/10/17 17:05:24 GMT
  #
  # A: Literal
  # B: Date/Time of Checkpoint

  $checkpoint_time =~ s/HBMDC CHECKPOINT://g;

}


sub parse_client_data {

  local($line) = @_;

  $line =~ s/Client Data://g;

  ($ipNumber,
   $dnsName,
   $port,
   $name,
   $pid,
   $status,
   $registartionTime,
   $blockedTime,
   $cpuTime,
   $shutdownTime,
   $deleteTime,
   $lastReceivedMessage,
   $lastReportTime,
   $interval) = split(";", $line);

  # X: Blocked time (time since which the process appears to have been blocked)
  
  # V: Client process status:
  #      0 - Unknown
  #      1 - Active
  #      2 - Blocked
  #      3 - Overdue
  #          [At least one scheduled report message for this Client
  #          process has not been received from the Local Monitor,
  #          but less than the threshold number at which the Client
  #          status is changed to 7 - Shutdown (no reports).]
  #      4 - Shutdown (normal)
  #          [The Client process unregistered with the
  #          Local Monitor specifying that the termination was Normal.]
  #      5 - Shutdown (abnormal)
  #          [The Client process unregitered with the
  #          Local Monitor specifying that the termination was Abnormal,
  #          e.g., because an error was detected or trapped by the
  #          Client process.]
  #      6 - Shutdown (died)
  #          [This is abend detected by the Local Monitor, the Client
  #          process did not unregister.]
  #      7 - Shutdown (no report)
  #          [The number of scheduled reports on this process that were
  #          not received from the Local Monitor by the Data Collector
  #          exceeded a threshold (currently 10), so the process is
  #          presumed by the Data Collector to be dead due to the
  #          computation/system due to either a host crash or network
  #          disconnection.]
}


sub parse_local_monitor {

    local($line) = @_;

    $line =~ s/LM Data://g;
    $line =~ s/\n//g;
    
    ($ipNumber,
     $dnsName,
     $portNumber,
     $clients,
     $liveClients,
     $activeClients,
     $summaryStatus,
     $mostRecentReport) = split(';', $line);

    $mostRecentReport =~ s/GMT//g;
    
    # K: IP Number of host the LM is running on (for communicating with the LM)
    # L: Fully qualified DNS name of host the LM is running on
    # M: Port number for communicating with the LM
    # N: Number of Clients for this LM in the file (not necessarily all live)
    # O: Number of live clients
    # P: Summary status for LM/host:
    #     1 - live clients, all active
    #     2 - live clients, at least one active and one blocked
    #         (none overdue)
    #     3 - live clients, all blocked (none overdue)
    #     4 - live clients, expected reports from the Local Monitor for
    #         some Client processes are overdue (and others are not)
    #         (i.e., the Data Collector has not received message(s)
    #         it expected from the Local Monitor for at least one
    #         of the Clients registered with the Local Monitor.
    #         Thus it appears to the Data Collector that the host
    #         for this Local Monitor and Clients may be down or the
    #         network has become disconnected)
    #     5 - live clients, expected reports from the Local Monitor for
    #         all Client processes are overdue
    #         (i.e., the Data Collector has not received message(s)
    #         it expected from the Local Monitor for each of the
    #         Clients registered with the LM.
    #         Thus it appears to the Data Collector that the host
    #         for this Local Monitor and Clients is down or the
    #         network is disconnected)
    #     9 - no live clients
}

sub parse_data_collector {

    local($line) = @_;

    $line =~ s/DC Data://g;

    ($ipNumber,
     $dnsName,
     $portNumber,
     $interval, 
     $localMonitors,
     $clients,
     $liveClients)
       = split(';', $line);
    
    # K: IP Number of host the LM is running on (for communicating with the LM)
    # L: Fully qualified DNS name of host the LM is running on
    # M: Port number for communicating with the LM
    # N: Number of Clients for this LM in the file (not necessarily all live)
    # O: Number of live clients
    # P: Summary status for LM/host:
    #     1 - live clients, all active
    #     2 - live clients, at least one active and one blocked
    #         (none overdue)
    #     3 - live clients, all blocked (none overdue)
    #     4 - live clients, expected reports from the Local Monitor for
    #         some Client processes are overdue (and others are not)
    #         (i.e., the Data Collector has not received message(s)
    #         it expected from the Local Monitor for at least one
    #         of the Clients registered with the Local Monitor.
    #         Thus it appears to the Data Collector that the host
    #         for this Local Monitor and Clients may be down or the
    #         network has become disconnected)
    #     5 - live clients, expected reports from the Local Monitor for
    #         all Client processes are overdue
    #         (i.e., the Data Collector has not received message(s)
    #         it expected from the Local Monitor for each of the
    #         Clients registered with the LM.
    #         Thus it appears to the Data Collector that the host
    #         for this Local Monitor and Clients is down or the
    #         network is disconnected)
    #     6 - no live clients
}


sub create_hbm_html_table {

    local($contents) =  @_;

    (@lines) = split ('\n', $contents);


    foreach $iline (@lines) {

	$_ = $iline;

	if (/^HBMDC CHECKPOINT/) {

	    $header = $iline;

	} elsif (/^DC Data/) {

	    $collector = $iline;

	} elsif (/^LM Data/) { 

	    push (@lmdata, $iline);

	}  elsif (/^Client Data/) {

	    push (@cddata, $iline);

	}  elsif (/^ *\n/) {

	    # ignore
	}  elsif (/^#/) {

		  #ignore

	} else {
	    #print "ERROR: linetype not recognized [$line]\n";
	}

    }


    print "    <!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n";
    print "<html>\n";
        print "  <head>\n";
    print "    <title>Heartbeat Monitor</title>\n";
    print "  </head>\n";


#print "  <body>\n";
    print "    <h1>Heartbeat Monitor</h1>\n";

#################################################

    &parse_header ($header);
    &parse_data_collector ($collector);

    print " Status of the Globus testbed ($checkpoint_time). ";
    print " The  data was collected on \"$dnsName\".<br>\n";

#################################################
    print "<hr>\n";

    print "<table border cellspacing=0 cellpadding=5>\n";
    print "<caption align=top> <b> Data Collector Status</b></caption> \n";


    print "    <tr align=left>\n";	
    print "	<th> <b>Name<b> </th>\n";
    print "     <td> <b> Monitors<b> </td>\n";
    print "     <td> <b> Alive/Total <b> </td>\n";
    print "      <td> <b> IP <b></td>\n";
    print "     <td> <b> Port <b> </td>\n";
    print "     </tr>\n";

    print "    <tr align=left>\n";	
    print "	<th> $dnsName </th>\n";
    print "     <td> $localMonitors </td>\n";
    print "     <td> $liveClients/$clients </td>\n";
    print "      <td> $ipNumber </td>\n";
    print "     <td> $portNumber </td>\n";
    print "     </tr>\n";


    print "    </table><br>\n";    

    print "<hr>\n\n";
    
#################################################

    print "<table border cellspacing=0 cellpadding=5>\n";
    print "<caption align=top> <b> Local Monitor Summary Status (Times in GMT)</b></caption \n";

    
    print "    <tr align=left>\n";	
    print "	<th> <b> Name </b></th>\n";
    print "     <td> <b> Summary Status<b> </td>\n";

    if ($with_clients) {
	print "     <td> <b> Client Status<b> </td>\n";
    }


    print "     <td> <b> Active/<BR>Alive/<BR>Total <b> </td>\n";
    print "      <td> <b> Last Report Time <b></td>\n";
    if ($full) {
	print "      <td> <b> IP <b></td>\n";
	print "     <td> <b> Port <b> </td>\n";

    }


	print "     </tr>\n";

    foreach $line (@lmdata) {
	&parse_local_monitor ($line);

	print "    <tr align=left>\n";	
	print "	<th> $dnsName </th>\n";
	print "     <td> ";
	&lm_status($summaryStatus);

	if ($with_clients) {
	    print "     <td>";
	    $old_line = $line;
	    &search_client_states ($ipNumber);
	    $line = $old_line;
	    print " </td>\n";
	    &parse_local_monitor ($line);
	}
	print "</td>\n";
	print "     <td> $activeClients/$liveClients/$clients </td>\n";
	print "      <td> $mostRecentReport </td>\n";
	if ($full) {
	    print "      <td> $ipNumber </td>\n";
	    print "     <td> $portNumber </td>\n";

	}
	print "     </tr>\n";
    }

    print "    </table><br>\n";
    print "<hr>";
    print "<b> Summary Status:</b>\n        ";
    print "["; &lm_status(0); print "] Unknown, ";
    print "["; &lm_status(1); print "] All live clients active, ";
    print "["; &lm_status(2); print "] At least one live client is active, ";
    print "["; &lm_status(3); print "] All live clients are blocked, ";
    print "["; &lm_status(4); print "] At least one live client is overdue, ";
    print "["; &lm_status(5); print "] All live clients have reports overdue (host down/disconnected), ";
    print "["; &lm_status(6); print "] No live clients <br>\n";

    &legend_client_status ;

    print "<hr>\n\n";

#################################################

    print "<table border cellspacing=0 cellpadding=5>\n";
    print "<caption align=top> <b> Client Status (Times in GMT) </b></caption \n";

    print "    <tr align=left>\n";	
    print "	 <th><b> Name</b> </th>\n";
    print "     <td> <b> Process </b> </th>\n";
    if ($full) {
	print "     <td> <b>PID</b> </th>\n";
    }
    print "     <td><b>Status</b> </th>\n";
    print "     <td><b>Last Report</b> </th>\n";

    if ($full) {
	print "     <td><b>Last Recv.Msg </b></th>\n";
	print "     <td><b>Interval </b></th>\n";
	print "     <td><b>Blocked Time </b></th>\n";
	print "     <td><b>CPU Time </b></th>\n";
	print "     <td><b>Registartion </b></th>\n";
	print "     <td><b>Shutdown </b></th>\n";
	print "     <td><b>Delete Time </b></th>\n";
	print "     <td><b>IP </b></th>\n";
    }
    print "     </tr>\n";

    foreach $line (@cddata) {
	$line =~ s/GMT//g;
	&parse_client_data ($line);

	print "    <tr align=left>\n";	
	print "	<th> $dnsName </th>\n";

	if ($full) {
	    printf "     <td> %s </th>\n", $name;
	    print "     <td>$pid </th>\n";
	} else {
	    (@parts) = split ("/",$name);
	    $short_process_name = $parts[$#parts];
	    printf "     <td> %s </th>\n", $short_process_name;
	}


	print "     <td>";
	&client_state($status);
	print "</th>\n";
	print "     <td>$lastReportTime </th>\n";	

	if ($full) {
	    print "     <td>$lastReceivedMessage </th>\n";
	    print "     <td>$interval </th>\n";
	    print "     <td>$blockedTime </th>\n";
	    print "     <td>$cpuTime </th>\n";
	    print "     <td>$registartionTime </th>\n";
	    print "     <td>$shutdownTime </th>\n";
	    print "     <td>$deleteTime </th>\n";
	    print "     <td>$ipNumber </th>\n";
	}
	print "     </tr>\n";

    }

    print "    </table><br>\n";

    &legend_client_status ;
    print "<hr>\n\n";

    &detailed_legend ;
    
#####################################################


    print "    <hr>\n";

#    print "    <address><a href=\"mailto:gregor\@mcs.anl.gov\">Gregor von Laszewski</a></address>\n";

    print "    <address><a href=\"mailto:bugs\@globus.org\"> bugs\@globus.org </a></address>\n";

    print "<!-- Created: Mon Nov  3 20:38:26 CST 1997 -->\n";
    print "<!-- hhmts start -->\n";
    print "<!-- hhmts end -->\n";
    print "  </body>\n";
    print "</html>\n";


}



sub lm_status {
    
    ($type) = @_;
    
    if ($type == 0) {
	$t = &ctext ("U", $BLUE);
    } elsif ($type == 1) {
	$t = &ctext ("A", $GREEN);
    } elsif ($type == 2) {
	$t = &ctext ("A", $YELLOW);
    } elsif ($type == 3) {
	$t = &ctext ("A", $GREEN);
    } elsif ($type == 4) {
	$t = &ctext ("O", $YELLOW);
    } elsif ($type == 5) {
	$t = &ctext ("O", $RED);
    } elsif ($type == 6) {
	$t = &ctext ("D", $BLACK);
    }
    printf "%s\n", $t;
}

sub client_state {
    
    ($type) = @_;

    if ($type == 0) {
	$t = &ctext ("U", $BLUE);
    } elsif ($type == 1) {
	$t = &ctext ("A", $GREEN);
    } elsif ($type == 2) {
	$t = &ctext ("A", $GREEN);
    } elsif ($type == 3) {
	$t = &ctext ("O", $YELLOW);
    } elsif ($type == 4) {
	$t = &ctext ("NS", $BLACK);
    } elsif ($type == 5) {
	$t = &ctext ("AS", $RED);
    } elsif ($type == 6) {
	$t = &ctext ("D", $BLACK);
    } elsif ($type == 7) {
	$t = &ctext ("O", $RED);
    }
    printf "%s\n", $t;

}

sub ctext {

    local($text,$color) = @_;
    $s = "<FONT COLOR=\"$color\"><B> ". $text . "</b></FONT>";
    return $s;
}





sub search_client_states {

    local($ip) = @_;

    local ($line); 

    foreach $line (@cddata) {

	$line =~ s/GMT//g;
	&parse_client_data ($line);

	if ($ip eq $ipNumber) {
	    &client_state($status);
	}				 
	
    }
    print "&nbsp ";
}

sub legend_client_status {
    print "<hr>";
    print "<b>Client Status: </b>";
    printf "["; client_state(0); print "] Unknown, "; 
    printf "["; client_state(1); print "] Active, ";
    printf "["; client_state(2); print "] Blocked, ";
    printf "["; client_state(3); print "] Overdue (Considered alive), ";
    printf "["; client_state(4); print "] Normal Shutdown, ";
    printf "["; client_state(5); print "] Abnormal Shutdown, ";
    printf "["; client_state(6); print "] Died (Abend without unregister),";
    printf "["; client_state(7); print "] Overdue (Considered dead)<p>\n";

}

sub detailed_legend {

    print " More details about the fields can be found in the \n"; 
    print "<a href=\"http://www.globus.org/hbm/heartbeat_spec.html\"> Heartbeat Monitor Specification</a>\n";


} 


sub two_column {

    ($column1, $column2) = @_;

    print "    <tr align=left>\n";	
    printf "	<th> %s </th>\n", $column1;
    print "     <td> %s </td>\n", column2;
    print "     </tr>\n";
}



