#!/usr/bin/perl
%ports=(
		'Alpha',389,
		'Beta',390);

$ldapsearch="/nfs/globus1/bin/solaris/ldapsearch";

($realmonth,$realday)=(localtime(time))[4,3];
%months=('Jan', 0,
	 'Feb', 1,
	 'Mar', 2,
	 'Apr', 3,
	 'May', 4,
	 'Jun', 5,
	 'Jul', 6,
	 'Aug', 7,
	 'Sep', 8,
	 'Oct', 9,
	 'Nov',10,
	 'Dec',11);


select STDOUT;
$|=1;

&html_header;
foreach $port (sort keys %ports)
{
	open(LDAP,"$ldapsearch -p $ports{$port} '(|(objectclass=GlobusComputeResource)(objectclass=GlobusResourceManager))' |");
	%os=();
	%manager=();
	%release=();
	%port=();
	%contact=();
	%freenodes=();
	%totalnodes=();
	%scheduledjob =();
	%release=();
	%mn=();
	%lastupdate=();

	
	while(&read_object) {}

	print "<h2>Testbed $port</h2>";

	&html_table_header;
	foreach $key (sort keys %mn) {
		$the_key=$key;
		$the_key=~s, *,,g;
		$the_os=$os{$the_key};
		if($contact{$key} =~ m,intel,){ 
			$the_os='x86pc-intel-solaris-2.5.1';
		}
		if(! $lastupdate{$key} eq "") {
			$startfont="<font color='$lastupdate{$key}'>\n";
			$stopfont="</font>";
		} else {
			$startfont="";
			$stopfont="";
		}
	print <<EOF;
		<tr>
        <td>$startfont$key$stopfont&nbsp;</td>
    	<td>$the_os&nbsp;</td>
		<td>$manager{$key}&nbsp;</td>
		<td>$release{$key}&nbsp;</td>
    	<td>$contact{$key}&nbsp;</td>
		<td>$totalnodes{$key}&nbsp;</td>
		<td>$freenodes{$key}&nbsp;</td>
		<td>$scheduledjob{$key}&nbsp;</td>
	</tr>
EOF
		if(! $lastupdate{$key} eq "") {
			print "</font>\n";
		}
	}
	print "</table>\n";
	print "Machines in <font color='#ff0000'>red</font> haven't ",
		" reported in the last four days\n";
}
	&html_footer;


sub html_header
{
	print <<'EOF';
Content-type: text/html

<html><head><title>GUSTO in a nutshell</title></head>
<body>
EOF
}

sub html_footer
{
	print "</body></html>\n";
}

sub html_table_header
{
	print <<'EOF';
<table width="100%" border="1">
<tr>
	<td align="center"><b>Machine</b></td>
	<td align="center"><b>OS</b></td>
	<td align="center"><b>Manager</b></td>
	<td align="center"><b>GRAM Version</b></td>
	<td align="center"><b>Contact</b></td>
	<td align="center"><b>TotalNodes</b></td>
	<td align="center"><b>FreeNodes</b></td>
	<td align="center"><b>Scheduled Job</b></td>
</tr>
EOF
}

sub html_table_footer
{
	print "</table>\n";
}


sub read_object {
    $type=<LDAP>;
    if(eof(LDAP)){ return 0;}
    if($type =~ m,^hn=,) { &read_hn($type); return 1; }
    if($type =~ m,^mn=,) { &read_mn($type); return 1; }
	if($type =~ m,^sw=,) { &read_sw($type); return 1; }
    while(<LDAP>) {
	if($_ eq "\n") {
	    return 1;
	}
    }
}

sub read_mn {
    chop($mname=$_[0]);
    $mname=~s,^mn=,,;
    $mname=(split(/, /, $mname))[0];
    local($myname, $contact_string, $manager, $release, 
	  $totalnodes, $color,$freenodes,$scheduledjob)=();

    while(<LDAP>) {
	if($_ =~ m,contact=,) {
	    chop($contact_string=$_);
	    $contact_string=~s,^contact=,,;
	} elsif($_ =~ m,apitype=,) {
		chop($manager=$_);
		$manager=~s,^apitype=,,;
	} elsif($_ =~ m,gramversion=,) {
		chop($release=$_);
		$release=~s,^gramversion=,,;
	} elsif($_ =~ m,^scheduledjob,) {
		chop($scheduledjob=$_);
		$scheduledjob=~s,^scheduledjob=,,;
		$scheduledjob=(join("<br>", (split(/\^/,$scheduledjob))));
	} elsif($_=~ m,^totalnodes,) {
		chop($totalnodes=$_);
		$totalnodes=~s,^totalnodes=,,;
	} elsif($_=~ m,^freenodes,) {
		chop($freenodes=$_);
		$freenodes=~s,^freenodes=,,;
	} elsif($_=~ m,^hn,) {
	    chop($myname=$_);
	    $myname=~s,^hn=,,;
	} elsif($_=~ m,^lastupdate,) {
	    chop($lastupdate=$_);
	    $lastupdate=~s,^lastupdate=,,;
	    ($foo, $month, $day, $foo) = split(/ /,$lastupdate);
	    if($months{$month} != $realmonth ||
		$day - $realday > 4 ||
		$day - $realday < -4) {
		$color="#ff0000";
	    }
	} elsif($_ eq "\n") { 
	    last;
	}
    }
    while(defined($mn{$myname})) {
        $myname .= " ";
    }
    $mn{$myname} = $mname;
    $contact{$myname} = $contact_string;
    $manager{$myname} = $manager;
    $release{$myname} = $release;
    if($scheduledjob eq "") { $scheduledjob="none"; }
    $scheduledjob{$myname} = $scheduledjob;
    $lastupdate{$myname}=$color;
    if(!defined($totalnodes)) {
      $totalnodes{$myname}=0;
    } else {
      $totalnodes{$myname} = $totalnodes;
    }
    if(!defined($freenodes)) {
      $freenodes{$myname}=0;
    } else {
      $freenodes{$myname} = $freenodes;
    }
}

sub read_hn {
    $name=$_[0];
    $name=~s,^hn=,,;
    ($hname,$rest) = split(/, */,$name);
    if($rest =~ m,NCSA, && $hname !~ m,\.ncsa\.uiuc\.edu,) {
	$hname .= ".ncsa.uiuc.edu";
    }
    if($rest =~ m,sdsc,i && $hname !~ m,\.sdsc,) {
	$hname .= ".sdsc.edu";
    }
    if($rest =~ m,ISI,i && $hname !~ m,\.isi,) {
	$hname .= ".isi.edu";
    }
    if($rest =~ m,caltech,i && $hname !~ m,\.caltech,) {
	$hname .= ".cacr.caltech.edu";
    }
    if($hname =~ m,caledonia,) {
	$hname .= ".cs.indiana.edu";
    }
    while(<LDAP>) {
	if($_ =~ m,^canonicalsystemname,) {
	    chop($sysname=$_);
	    $sysname=~s,canonicalsystemname=,,;
            if(!defined($os{$hname})) {
	    $os{$hname} = join('-', split(/ /,$sysname));
		}
	}

	if($_ eq "\n") { return; }
    }
}

