#!/local/bin/perl

$ldapsearch="/nfs/globus1/bin/solaris/ldapsearch -p 389 -h mds.globus.org";

# ############################################################
# HEADER
# ############################################################

printf "Content-type: text/html\n\n";
printf "<html>\n";
printf "<h2> Globus Network Performance </h2>\n";
printf "<body>";

# ############################################################

&get_arguments;

$hosts=$arg{hosts}; 
$withbandwidth=$arg{bandwidth};
$withlatency=$arg{latency};
$cutoff=$arg{cutoff};
$matrix=$arg{matrix};

if (!$withlatency && !$withbandwidth) {
    $withlatency=1;
    $withbandwidth=1;
}

$colspan= 0;
if ($withbandwidth) { $colspan++; }
if ($withlatency) { $colspan++; }

if ($hosts) {
    @sources = split (":", $hosts);
    @destinations = split (":", $hosts);
} else {
    $sourcelist = `$ldapsearch "(objectclass=GlobusHostPair)" sourcehostname | fgrep sourcehostname | sort -u`;

    $sourcelist =~ s/sourcehostname=//g;

    $destlist = `$ldapsearch "(objectclass=GlobusHostPair)" desthostname | fgrep desthostname | sort -u`;

    $destlist =~ s/desthostname=//g;
    @sources = split ("\n", $sourcelist);
    @destinations = split ("\n", $destlist);

    if ($matrix > 0) {
	@all = (@sources);
	foreach $element (@destinations) {
	    $add = 1;
	    foreach $test (@sources) {
		if ($test eq $element) {
		    $add = 0;
		} 
	    }
	    if ($add > 0) {
		push (@all, $element);
	    }
	}
	@sources = ();
	@destinations = (); 
	@sources = (@all);
	@destinations = (@all);
    } 
    
}



$result= `$ldapsearch -L "(objectclass=GlobusHostPair)" sourcehostname desthostname latency bandwidth`;

@lines = split ("\n", $result);

foreach $line (@lines){

    if ($line =~ /^ |^dn:/) {
	;			# skip
    } else {			# 
	$line =~ s/ //g;
	($attribute,$value) = split (':', $line, 2);

	$v{$attribute} = $value;

	if ($attribute =~ /bandwidth/) {
	    $key = $v{sourcehostname}."-".$v{desthostname};
	    $bandwidth{$key} = $v{bandwidth};
	    $latency{$key} = $v{latency};
	} else {
	}
    }
}

$caption="";
if ($withbandwidth) {$caption.="bandwidth ";}
if ($withlatency) {
    if ($withbandwidth) {
	$caption.="and ";
    }
    $caption.="latency ";
}

printf "<TABLE BORDER>";
printf "<CAPTION> The $caption performance table </CAPTION>";
printf "<FONT SIZE=-1>";

printf "<TR><TH ROWSPAN=1>%20s</TH><TH COLSPAN=%d>%20s</TH>\n", 
    "source", $colspan*($#destinations+1), "destination";


printf "<TR>";
printf "<TH>%20s</TH>";

foreach $d (@destinations) {
    if ($cutoff > 0) {
	printf "<TH COLSPAN=%d>%13s</TH> ", $colspan, substr($d,0,$cutoff);
    } else {
	printf "<TH COLSPAN=%d>%13s</TH> ", $colspan, $d;
    }
}
printf "\n";

printf "<TR>";
printf "<TH>%20s</TH>", "";

foreach $d (@destinations) {
    if ($withbandwidth) { printf "<TH>%13s</TH>", "BW";}
    if ($withlatency) { printf "<TH>%13s</TH> ", "LAT"; }
}
printf "\n";

foreach $s (@sources) {

    printf "<TR>";
    printf "<TH>%20s</TH>", $s;

  foreach $d (@destinations) {
      $key = "$s-$d";
      if ($s eq $d) {
	  if ($withbandwidth) {printf "<TD> </TD>";}
	  if ($withlatency) {printf "<TD> </TD>";}
      } else {
	  if ($latency{$key} eq "") {
	      $l = "-";
	  } else {
	      $l = sprintf ("%.2f", $latency{$key});
	  }
	  if ($bandwidth{$key} eq "") {
	      $b = "-";
	  } else {
	      $b = sprintf ("%.2f", $bandwidth{$key});
	  }
	  if ($withbandwidth) {printf "<TD align=\"right\">%6s</TD>", $b ;}
	  if ($withlatency) {printf "<TD align=\"right\">%6s</TD>", $l;}
      }
      printf " ";
  } 
  printf "\n";
}

$legend="";
if ($withbandwidth) {$legend.="Bandwidth(BW) in milliseconds";}
if ($withlatency) {$legend.="Latency(LAT) in megabits per seconds";}
printf "<TR><TH ROWSPAN=1>%20s</TH><TH COLSPAN=%d>%20s</TH>\n", 
    "Units", $colspan*($#destinations+1), 
    $legend;

printf "</FONT>";
printf "</TABLE>";
printf "<p>"; 
printf "More details about the gloperf CGI script  is available in the \n"; 
printf "<a href=\"http://www.globus.org/mds/status/gloperf.html\"> ";
printf "Globus MDS WWW pages </a><p>\n";
printf "</body></html>";
exit;


sub get_arguments {

    $arguments=$ENV{'QUERY_STRING'};


    (@fields) = split("&",$arguments);
    
#    print "@fields <br>\n";
#    print "$#fields\n";

    for ($i=0; $i <= $#fields; $i++) {
     
	$line = $fields[$i];
#	 print "$line<br>\n";
	($name,$value) = split('=',$line,2);
	$arg{$name} = $value;

#	print "[$name], [$value], [$line] [$arg{$name}]<br>\n";
     }

}			








