#! /local/bin/perl5

# $Source: /home/globdev/CVS/globus-current/Globus/InformationServices/cgi/GlobusView.cgi,v $
# $Date: 1998/08/15 02:45:48 $
# $Revision: 1.1 $
# $Author: laszewsk $

$ldapsearch="/nfs/globus1/bin/solaris/ldapsearch";

select STDOUT;
$|=1;

&html_header;
print "<img src=http://globus.isi.edu/GlobusView/trans.gif ",
      "height='1' width='100%'>";
print "<script language='JavaScript'>\n";
print "Contacts = new Array();\n";

$port='Alpha';
{
    open(LDAP,"$ldapsearch -h mds.globus.org -p 389 ".
               "'(|(objectclass=GlobusComputeResource) ".
               "(objectclass=GlobusResourceManager) ".
               "(objectclass=GlobusStub))' ".
               "scheduledjob canonicalsystemname hn freenodes ".
	       "totalnodes contact apitype 2>&1 |");
    %os=();
    %manager=();
    %release=();
    %port=();
    %contact=();
    %freenodes=();
    %totalnodes=();
    %scheduledjob =();
    %release=();
    %mn=();
    %org=();
    %o_totalnodes=();
    %o_freenodes=();
    %users=();
    %pending=();
    %pending_by_host=();
    %active=();
    %active_by_host=();
    %machines=();

    ($machine)=();
    ($all_totalnodes,$all_freenodes)=(0,0);
    
    while(&read_object) {}

    foreach $key (keys %mn) 
    {
	if($manager{$key} eq "condor") 
	{
	    $org{$key}="U.Wisconsin";
	}
        if($org{$key} =~ m,MauiHigh,) 
	{
            $org{$key}="Maui";
        }
        if($org{$key} =~ m,Indiana,) 
	{
            $org{$key}="IU";
        }
        if($org{$key} =~ m,MCS,) 
	{
            $org{$key}= "Argonne";
        }
        if($org{$key} =~ m,^CS$,) 
	{
            $org{$key} = "IU(CS)";
        }
   	# extract OU/Machinetype
        $the_key=$key;
        $the_key=~s, *$,,;
        if($os{$the_key} =~ /686/ ||
           $os{$the_key} =~ /586/ ||
           $os{$the_key} =~ /486/ ||
           $os{$the_key} =~ /intel/)
        {
            $the_os=INTEL;
        }
        else
        {
            $the_os= (split(/-/,$os{$the_key}))[1];
            $the_os=~tr[a-z][A-Z];
        }
        if($the_os eq "")
        {
            $the_os='(unknown)';
        }
 
        $machine="$org{$key}-" . $the_os;

        if(defined($o_totalnodes{$machine})) 
	{
	    if(defined $totalnodes{$key}) 
	    {
		$o_totalnodes{$machine} += $totalnodes{$key};
	    } 
	} 
	else
	{
	    if(defined $totalnodes{$key}) 
	    {
		$o_totalnodes{$machine} = $totalnodes{$key};
	    } 
	    else
	    {
		$o_totalnodes{$machine} = 0;
	    }
	}
	if(!defined($machines{$machine})) 
	{
	    $machines{$machine} = $key;
	} 
	else
	{
	    $machines{$machine} .= ":$key";
	}
	
        if(defined($o_freenodes{$machine})) 
	{
	    if(defined $freenodes{$key}) 
	    {
		$o_freenodes{$machine} += $freenodes{$key};
	    }
	} 
	else
	{
	    if(defined $freenodes{$key}) 
	    {
		$o_freenodes{$machine} = $freenodes{$key};
	    }
	    else
	    {
		$o_freenodes{$machine} = 0;
	    }
	}

        print "Contacts['$key'] = '", $contact{$key}, "';\n";
        $all_totalnodes += $totalnodes{$key};
        $all_freenodes  += $freenodes{$key};

        # extract OU/Machinetype / User -> # of jobs
        foreach $job (split(/<br>/,$scheduledjob{$key})) 
	{
            #$job=~s,;.*,,;
            unless($job eq "none") 
	    {
		($job,$state,$count)=(split(/;/,$job))[0,1,3];
		$job=~s,\@.*,,;
                $job=~s/\/C=.*\/CN=//;
		if($state eq "ACTIVE") 
		{
		    if(! (defined($active{"$job:$machine"}))) 
		    {
			$active{"$job:$machine"}=$count;
		    }
		    else
		    {
			$active{"$job:$machine"}+=$count;
		    }
		    if(! (defined($active_by_host{"$job:$the_key"}))) 
		    {
			$active_by_host{"$job:$key"}=$count;
		    } 
		    else
		    {
			$active_by_host{"$job:$key"}+=$count;
		    }
		}
		if($state eq "PENDING") 
		{
		    if(! (defined($pending{"$job:$machine"}))) 
		    {
			$pending{"$job:$machine"}=$count;
		    } 
		    else
		    {
			$pending{"$job:$machine"}+=$count;
		    }
		    if(! (defined($pending_by_host{"$job:$the_key"}))) 
		    {
			$pending_by_host{"$job:$key"}=$count;
		    }
		    else
		    {
			$pending_by_host{"$job:$key"}+=$count;
		    }
		}
            }
        }
    }

    foreach $key (sort keys %o_totalnodes) 
    {
        foreach $user (keys %pending, keys %active) 
	{
	    if($user =~ m,:$key,) 
	    {
		$name=(split(/:/,$user))[0];
		$name=~s,.*CN=,,;
		$name=~s,\@globus.org,,;
		$users{$name}=1;
	    }
        }
    }
    print "${port}Machines = new Array();\n";
    print "${port}Active = new Array();\n";
    print "${port}ActiveByHost = new Array();\n";
    print "${port}Pending = new Array();\n";
    print "${port}PendingByHost = new Array();\n";
    print "${port}Users = new Array();\n";
    print "${port}TotalNodes = new Array();\n";
    print "${port}FreeNodes = new Array();\n";
    print "${port}TotalNodesByHost = new Array();\n";
    print "${port}FreeNodesByHost = new Array();\n";
    foreach $user (sort mysort keys %active) 
    {
	print "${port}", 'Active["', $user, '"]=', $active{$user}, ";\n";
    }
    foreach $user (sort mysort keys %active_by_host) 
    {
        print "${port}", 'ActiveByHost["' , $user, '"]=', 
		$active_by_host{$user}, ";\n";
    }
    foreach $user (sort mysort keys %pending) 
    {
        print "${port}", 'Pending["' , $user, '"]=', $pending{$user}, ";\n";
    }
    foreach $user (sort mysort keys %pending_by_host) 
    {
        print "${port}", 'PendingByHost["' , $user, '"]=', 
		$pending_by_host{$user}, ";\n";
    }
    foreach $user (sort mysort keys %users) 
    {
        print "${port}", 'Users["', $user, '"]=', $users{$user}, ";\n";
    }
    foreach $machine (sort keys %o_totalnodes) 
    {
	print "${port}",'TotalNodes["',$machine, '"]=',
            $o_totalnodes{$machine} ? $o_totalnodes{$machine} : "0", ";\n";
	print "${port}",'FreeNodes["',$machine,'"]=',
            $o_freenodes{$machine} ? $o_freenodes{$machine} : "0", ";\n";
    }
    foreach $host (sort keys %totalnodes) 
    {
        if($totalnodes{$host} eq '')
	{
	    $totalnodes{$host}='0'; 
	}
        if($freenodes{$host} eq '') 
	{
	    $freenodes{$host}='0'; 
	}
	print "${port}TotalNodesByHost['", $host, "']=$totalnodes{$host};\n";
	print "${port}FreeNodesByHost['", $host, "']=$freenodes{$host};\n";
    }
    foreach $key (sort keys %machines) 
    {
	print "${port}Machines['$key']=new Array('";
	print join("', '", split(/:/,$machines{$key}));
        print "');\n";
    }
    print "${port}AllTotalNodes=$all_totalnodes;\n";
    print "${port}AllFreeNodes=$all_freenodes;\n";

}

$_ = <<"EOF";
parent.globusview_change_testbed_display();
if(parent.globusview_which_chooser == parent.BY_SITE) 
{
    parent.globusview_by_sites();
}
if(parent.globusview_which_chooser == parent.BY_USERS) {
    parent.globusview_by_users();
}
if(parent.globusview_which_chooser == parent.BY_MACHINE_TYPE) 
{
    parent.globusview_by_machine_types();
}
</script>
EOF

print;

&html_footer;


sub html_header
{
    print <<'EOF';
Content-type: text/html

<head><meta http-equiv="Refresh" content="120;URL=./GlobusView.cgi"></head>
EOF
}

sub html_footer
{
    print "</body></html>\n";
}



sub read_object {
    $type=<LDAP>;
    if(eof(LDAP)){ return 0;}
    if($type =~ m,^hn=,) { &read_hn($type); return 1; }
    if($type =~ m,^mn=,) { &read_mn($type); return 1; }
    if($type =~ m,^cn=,) { &read_mn($type); return 1; }
    if($type =~ m,^nn=,) { &read_mn($type); return 1; }
    while(<LDAP>) {
    if($_ eq "\n") {
        return 1;
    }
    }
}

sub read_mn {
    chop($mname=$_[0]);
    $mname=~s,^mn=,,;
    $mname=~s,^cn=,,;
    ($mname,$org)=(split(/, /, $mname))[0,1];
    $org=(split(/=/,$org))[1];
    $org=~s/,//;
    $org=~s/\s*//g;

    local($myname, $contact_string, $manager, $release, $scheduledjob,
      $totalnodes, $freenodes, $thisscheduledjob)=();

    while(<LDAP>) {
    if($_ =~ m,contact=,) {
        chop($contact_string=$_);
        $contact_string=~s,^contact=,,;
	$contact_string=~s,.*CN=,,;
	$contact_string=~s,\@globus.org,,;
    } elsif($_ =~ m,apitype=,) {
        chop($manager=$_);
        $manager=~s,^apitype=,,;
    } elsif($_ =~ m,gramversion=,) {
        chop($release=$_);
        $release=~s,^gramversion=,,;
    } elsif($_ =~ m,^scheduledjob,) {
        chop($thisscheduledjob=$_);
	$thisscheduledjob=~s/^scheduledjob=//;
	if($thisscheduledjob !~ m/^&\(/) {
            $thisscheduledjob =~ s/\^/<br>/g;
            $scheduledjob.= "<br>$thisscheduledjob";
        } else {
            $thisuser=$thisscheduledjob;
            $thisuser=~s/.*"globus_id" =//;
            $thisuser=~s/\).*//g;
            $thisstate=$thisscheduledjob;
            $thisstate=~s/.*"job_status" =//;
            $thisstate=~s/\).*//g;
            $thiscount=$thisscheduledjob;
            if($thiscount =~ /"count"/) {
               $thiscount=~s/.*"count" =//;
               $thiscount=~s/\).*//g;
            } else {
               $thiscount=" 1";
            }
            $thisscheduledjob="$thisuser;$thisstate;;$thiscount";
            $thisscheduledjob=~s/\"//g;
            $thisscheduledjob=~s/ ;/;/g;
            $thisscheduledjob=~s/; /;/g;
            $thisscheduledjob=~s/\/C=.*\/CN=//;
            $scheduledjob.= "<br>$thisscheduledjob";
        }
 
        
    } elsif($_=~ m,^totalnodes,) {
        chop($totalnodes=$_);
        $totalnodes=~s,^totalnodes=,,;
    } elsif($_=~ m,^freenodes,) {
        chop($freenodes=$_);
        $freenodes=~s,^freenodes=,,;
    } elsif($_=~ m,^hn,) {
        chop($myname=$_);
        $myname=~s,^hn=,,;
    } elsif($_ eq "\n") { 
        last;
    }
    }

    # work even if multiple grams are running.
    while(defined($mn{$myname})) {
        $myname .= " ";
    }

    $mn{$myname} = $mname;
    $contact{$myname} = $contact_string;
    $manager{$myname} = $manager;
    $release{$myname} = $release;
    if($scheduledjob eq "") { $scheduledjob="none"; }
    $scheduledjob{$myname} = $scheduledjob;
    $totalnodes{$myname} = $totalnodes;
    $freenodes{$myname} = $freenodes;
    $org{$myname}=$org;
}
sub read_hn {
    $name=$_[0];
    $name=~s,^hn=,,;
    ($hname,$rest) = split(/, */,$name);

    while(<LDAP>) {
	if($_ =~ m,^canonicalsystemname,) {
	    chop($sysname=$_);
	    $sysname=~s,canonicalsystemname=,,;
            if(!defined($os{$hname})) {
                $os{$hname} = join('-', split(/ /,$sysname));
            }
	}

	if($_ eq "\n") { return; }
    }
}


sub mysort {
    ($A,$B)=($a,$b);
    $A=~tr,[A-Z],[a-z],;
    $B=~tr,[A-Z],[a-z],;


    $A cmp $B;
}
