#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <pthread.h>

#include <sys/signal.h>


#include "globus_hbm_datacollector.h"
#include "globus_common.h"

#define GLOBUS_HBM_DATACOLLECTOR_PORT_BASE  15000
#define GLOBUS_HBM_DATACOLLECTOR_TEST_INTERVAL 30
#define GLOBUS_HBM_DATACOLLECTOR_TEST_CHKPT \
          "/tmp/globus_hbm_datacollector_test"
#define GLOBUS_HBM_DATACOLLECTOR_TEST_LOG \
          "/tmp/globus_hbm_datacollector_test"
#define GLOBUS_HBM_DATACOLLECTOR_TEST_LATE_SECS       30
#define GLOBUS_HBM_DATACOLLECTOR_TEST_MISSING_SECS    30	  

globus_bool_t done = GLOBUS_FALSE;

#define MAX_DC_THREADS 10


void event_callback( globus_hbm_datacollector_handle_t handle,
		     globus_hbm_client_callbackdata_t *callbackdata,
		     globus_hbm_datacollector_client_entry_t *client,
		     void *user_data)
{
    globus_libc_fprintf( stderr,
			 "event_callback user_data[%d]\n",
			 *((int*)user_data));

    return;
}

void tcp_callback( int fd, globus_hbm_datacollector_handle_t handle )
{
    globus_libc_fprintf( stderr, " tcp callback \n");
    
    return;
}
		   


void registration_callback( globus_hbm_datacollector_handle_t handle,
			    globus_hbm_client_callbackdata_t *callbackdata,
			    globus_hbm_datacollector_client_entry_t *client,
			    void *user_data)
{
    int rc;
    
    globus_libc_fprintf( stderr,
			 "registration_callback user_data[%d]\n",
			 *((int*)user_data));

    /*
    ** Set the event callback
    */

    /* clear the eventmask */
/*    callbackdata->cl_eventmask = 0; */
    
    rc = globus_hbm_datacollector_set_clientevent_callback(
	       handle,
	       callbackdata,
	       GLOBUS_HBM_DATACOLLECTOR_TEST_LATE_SECS,
	       GLOBUS_HBM_DATACOLLECTOR_TEST_MISSING_SECS,
	       user_data,
	       event_callback);
    
    if( rc != GLOBUS_SUCCESS )
    {
	globus_libc_fprintf( stderr,
			    "globus_hbm_datacollector_set_clientevent_callback "
			    "FAILED\n");
    }
    else
    {
	globus_libc_fprintf( stderr,
			    "globus_hbm_datacollector_set_clientevent_callback "
			    "SUCCEEDED\n");
    }	
    

    return;
}



void *poll_thread(void *dummy)
{
    int rc;
    
    globus_libc_fprintf( stderr, "Entering Poll Thread\n");
    
    /* activate modules we're going to use */
    rc = globus_module_activate( GLOBUS_POLL_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr,
			     "Internal Failure: activate GLOBUS_POLL_MODULE\n");
	return;
    }

    /* Poll loop */
    while( ! done )
    {
	globus_poll_blocking();
    }
    
    globus_libc_fprintf(stderr, "Exiting Poll Thread\n");    
}


void *datacollector_thread( void *index )
{
    int rc;
    globus_hbm_datacollector_handle_t datacollector;
    globus_hbm_client_callbackdata_t *callbackdata;
    void *user_data;
    FILE* log_file;
    char  log_filename[MAXPATHLEN];
    char  chkpt_filename[MAXPATHLEN];
    u_short datacollector_port;
    int tcp_fd;
    int one = 1;    
    struct timeval  time;
    char *time_str;
    int thread_index;
    int seed;
    int sleep_time;

    thread_index = *((int*)(index));

    globus_libc_fprintf( stderr, "Entering datacollector thread(%d)\n",
			 *((int*)(index)) );

    /* build log-file-name */
    globus_libc_sprintf( log_filename, "%s.%d.log",
			 GLOBUS_HBM_DATACOLLECTOR_TEST_LOG,
			 *((int*)(index)) );

    /* build checkpoint-filename */
    globus_libc_sprintf( chkpt_filename, "%s.%d.chkpt",
			 GLOBUS_HBM_DATACOLLECTOR_TEST_CHKPT,
			 *((int*)(index)) );

    /* calculate port number */
    datacollector_port = GLOBUS_HBM_DATACOLLECTOR_PORT_BASE + *((int*)(index));
    
    /* open log-file */
    log_file = fopen( log_filename, "a" );
    if( log_file == GLOBUS_NULL )
    {
	globus_libc_fprintf( stderr, "Unable to open log-file(%s)\n",
			     GLOBUS_HBM_DATACOLLECTOR_TEST_LOG );
    }

    /* write entry in log_file */
    gettimeofday( &time, GLOBUS_NULL );
    time_str = ctime( &time.tv_sec );
    globus_libc_fprintf( log_file, "\nHBM Datacollector Test: %s\n",
			 time_str );
    fflush( log_file );

    /* setup user data */
    user_data = (char*)globus_malloc(sizeof(int));
    *(int*)user_data = *((int*)(index));

    globus_libc_fprintf( stderr, "Creating Datacollector on Port(%d)\n",
			 datacollector_port);    

    /*
    ** Create a datacollector
    */
    /* Note that below parameters that are 0 means use default value. */
    rc = globus_hbm_datacollector_create(
                &datacollector_port,
                GLOBUS_HBM_DATACOLLECTOR_TEST_INTERVAL,/* hb interval default */
                0,             /* network variation allowance */
                0,             /* heartbeats missing for overdue */
                0,             /* heartbeats missing for shutdown */
                chkpt_filename,
                chkpt_filename,
                log_file,
                registration_callback,
                user_data,
                &datacollector );

    if( rc == GLOBUS_SUCCESS )
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_create SUCCEEDED!\n");
    }
    else
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_create FAILED!\n");
    }

    while(1)
    {
	globus_libc_fprintf( stderr, "Checkpointing Datacollector(%d)"
			     " Thread(%d)\n",
			     datacollector, *((int*)(index)) );
	globus_hbm_datacollector_user_checkpoint( datacollector,
						  -1 );
	sleep_time = rand( ) % 60;
	globus_libc_fprintf( stderr, "Thread(%d) Sleeping(%d)\n",
			     *((int*)(index)), sleep_time);
	sleep( sleep_time );
    }
    
    fclose( log_file );

    globus_libc_fprintf( stderr, "Exiting datacollector thread(%d)\n",
			 *((int*)(index)) );
}
    



void quit( )
{
    done = GLOBUS_TRUE;
    globus_libc_fprintf( stderr, "Handling signal\n");
}


int main( int argc, char **argv )
{
    int rc;
    char *dc_opt;
    int num_datacollectors;
    int i;
    struct timeval time;

    pthread_t poll_tid;
    pthread_t dc_tid[MAX_DC_THREADS];

    signal(SIGINT, quit);
    signal(SIGQUIT, quit);
    signal(SIGTERM, quit);

    dc_opt = globus_i_hbm_get_options( "-dc", argc, argv );
    if( dc_opt == GLOBUS_NULL )
    {
	num_datacollectors = 1;
    }
    else
    {
	num_datacollectors = atoi( dc_opt );
	if( num_datacollectors > MAX_DC_THREADS )
	{
	    globus_libc_fprintf( stderr, "Maximum Threads(10) exceeded\n");
	    return GLOBUS_FAILURE;
	}
    }

    gettimeofday( &time, NULL );
    srand( time.tv_sec );

    /*
    ** Activate datacollector module
    */
    rc = globus_module_activate( GLOBUS_HBM_DATACOLLECTOR_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr,
	     "Internal Failure: activate GLOBUS_HBM_DATACOLLECTOR_MODULE\n");
	return GLOBUS_FAILURE;
    }
    


    for( i = 0; i < num_datacollectors; i++ )
    {
	int *thread_arg;
	thread_arg = globus_malloc( sizeof(int) );
	*thread_arg = i + 1;
	rc = pthread_create( &dc_tid[i], NULL,
			     datacollector_thread, thread_arg );
	if( rc )
	{
	    globus_libc_fprintf( stderr, "pthread_create datacollector failed\n");
	    return GLOBUS_FAILURE;
	}
	else
	{
	    globus_libc_fprintf( stderr, "Datacollector Thread Started(%d)\n",
				 dc_tid[i]);
	}
    }	

    
    /*
    ** Start Poll Thread
    */
    rc = pthread_create(&poll_tid, NULL, poll_thread, NULL);
    if( rc )
    {
	globus_libc_fprintf( stderr, "pthread_create failed\n");
	return GLOBUS_FAILURE;
    }
    else
    {
	globus_libc_fprintf( stderr, "Poll Thread Started(%d)\n",
			     poll_tid);
    }
    
    pthread_join( poll_tid, NULL );
    
    rc = GLOBUS_SUCCESS;
    rc = globus_module_deactivate( GLOBUS_POLL_MODULE );
    rc = globus_module_deactivate( GLOBUS_HBM_DATACOLLECTOR_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr, "Module deactivation failed\n");
    }
    
    globus_libc_fprintf( stderr, "hbmdc_test Exiting\n");
    return GLOBUS_SUCCESS;
}  
