#include <sys/signal.h>
#include "globus_hbm_datacollector.h"

#define GLOBUS_HBM_DATACOLLECTOR_TEST_PORT  11111
#define GLOBUS_HBM_DATACOLLECTOR_TEST_INTERVAL 30
#define GLOBUS_HBM_DATACOLLECTOR_TEST_CHKPT \
          "/tmp/globus_hbm_datacollector_test_chkpt"
#define GLOBUS_HBM_DATACOLLECTOR_TEST_LOG \
          "/tmp/globus_hbm_datacollector_test_log"
#define GLOBUS_HBM_DATACOLLECTOR_TEST_LATE_SECS       30
#define GLOBUS_HBM_DATACOLLECTOR_TEST_MISSING_SECS    30	  

globus_bool_t done = GLOBUS_FALSE;
	  

void event_callback( globus_hbm_datacollector_handle_t handle,
		     globus_hbm_client_callbackdata_t *callbackdata,
		     globus_hbm_datacollector_client_entry_t *client,
		     void *user_data)
{
    globus_libc_fprintf( stderr,
			 "event_callback user_data[%d]\n",
			 *((int*)user_data));

    return;
}

void tcp_callback( int fd, globus_hbm_datacollector_handle_t handle )
{
    globus_libc_fprintf( stderr, " tcp callback \n");
    
    return;
}
		   


void registration_callback( globus_hbm_datacollector_handle_t handle,
			    globus_hbm_client_callbackdata_t *callbackdata,
			    globus_hbm_datacollector_client_entry_t *client,
			    void *user_data)
{
    int rc;
    
    globus_libc_fprintf( stderr,
			 "registration_callback user_data[%d]\n",
			 *((int*)user_data));

    /*
    ** Set the event callback
    */

    /* TODO: set some events */
    
    rc = globus_hbm_datacollector_set_clientevent_callback(
	       handle,
	       callbackdata,
	       GLOBUS_HBM_DATACOLLECTOR_TEST_LATE_SECS,
	       GLOBUS_HBM_DATACOLLECTOR_TEST_MISSING_SECS,
	       user_data,
	       event_callback);
    
    if( rc != GLOBUS_SUCCESS )
    {
	globus_libc_fprintf( stderr,
			    "globus_hbm_datacollector_set_clientevent_callback "
			    "FAILED\n");
    }
    else
    {
	globus_libc_fprintf( stderr,
			    "globus_hbm_datacollector_set_clientevent_callback "
			    "SUCCEEDED\n");
    }	
    

    return;
}

void quit( )
{
    done = GLOBUS_TRUE;
    globus_libc_fprintf( stderr, "Handling signal\n");
}


int main()
{
    int rc;
    FILE* log_file;
    int tcp_fd;
    globus_hbm_datacollector_handle_t datacollector;
    globus_hbm_client_callbackdata_t *callbackdata;
    void *user_data;
    int one = 1;    
    struct timeval  time;
    char *time_str;
    u_short test_port;
    int num_clients;

    signal(SIGINT, quit);
    signal(SIGQUIT, quit);
    signal(SIGTERM, quit);

    /*
    ** Activate datacollector module
    */
    rc = globus_module_activate( GLOBUS_HBM_DATACOLLECTOR_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr,
	     "Internal Failure: activate GLOBUS_HBM_DATACOLLECTOR_MODULE\n");
	return GLOBUS_FAILURE;
    }
    

    /* open log-file */
    log_file = fopen( GLOBUS_HBM_DATACOLLECTOR_TEST_LOG, "a" );
    if( log_file == GLOBUS_NULL )
    {
	globus_libc_fprintf( stderr, "Unable to open log-file(%s)\n",
			     GLOBUS_HBM_DATACOLLECTOR_TEST_LOG );
    }

    /* write entry in log_file */
    gettimeofday( &time, GLOBUS_NULL );
    time_str = ctime( &time.tv_sec );
    globus_libc_fprintf( log_file, "\nHBM Datacollector Test: %s\n",
			 time_str );
    fflush( log_file );

    /* setup user data */
    user_data = (char*)globus_malloc(sizeof(int));
    *(int*)user_data = 155;

    /*
    ** Create a datacollector
    */
    test_port = GLOBUS_HBM_DATACOLLECTOR_TEST_PORT;

    /* Note that below parameters that are 0 means use default value. */
    rc = globus_hbm_datacollector_create(
		&test_port,
                GLOBUS_HBM_DATACOLLECTOR_TEST_INTERVAL,/* hb interval default */
                0,             /* network variation allowance */
                0,             /* heartbeats missing for overdue */
                0,             /* heartbeats missing for shutdown */
	        GLOBUS_HBM_DATACOLLECTOR_TEST_CHKPT,
	        GLOBUS_HBM_DATACOLLECTOR_TEST_CHKPT,
	        log_file,
	        registration_callback,
	        user_data,
	        &datacollector );
    if( rc == GLOBUS_SUCCESS )
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_create SUCCEEDED!\n");
    }
    else
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_create FAILED!\n");
    }


    /* setup tcp port */
    tcp_fd = socket( AF_INET, SOCK_STREAM, 0 );
    if( tcp_fd < 0 )
    {
	globus_libc_fprintf( stderr,
			     "Error setting up tcp socket\n");
	return GLOBUS_FAILURE;
    }

    rc = setsockopt( tcp_fd, SOL_SOCKET, SO_REUSEADDR, (char*)&one,
		     sizeof(one));
    if( rc < 0 )
    {
	perror("Unable to set socketop\n");
    }

    rc = globus_hbm_datacollector_reg_tcpfd( tcp_fd, tcp_callback,
					     datacollector );
    if( rc < 0 )
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_reg_tcpfd FAILED\n");
    }
    else
    {
	globus_libc_fprintf( stderr,
			     "globus_hbm_datacollector_reg_tcpfd SUCCEEDED\n");
    }
    

    /* activate modules we're going to use */
    rc = globus_module_activate( GLOBUS_POLL_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr,
			     "Internal Failure: activate GLOBUS_POLL_MODULE\n");
	return GLOBUS_FAILURE;
    }

#ifdef REWRITE_THIS    
    /*
    ** Poll Loop
    */
    
    while( ! done )
    {
	globus_poll_blocking();
    }
#endif /* REWRITE_THIS */

    rc = GLOBUS_SUCCESS;

    rc = globus_hbm_datacollector_destroy( datacollector,
				GLOBUS_HBM_DATACOLLECTOR_FORCE_DESTROY_YES,
					   &num_clients );
    if( rc == GLOBUS_FAILURE )
    {
        globus_libc_fprintf( stderr, "datacollector destroy failed\n");
    }
    
    rc = globus_module_deactivate( GLOBUS_POLL_MODULE );
    rc = globus_module_deactivate( GLOBUS_HBM_DATACOLLECTOR_MODULE );
    if( rc == GLOBUS_FAILURE )
    {
	globus_libc_fprintf( stderr, "Module deactivation failed\n");
    }
    
    fclose( log_file );
    close( tcp_fd );
    globus_libc_fprintf( stderr, "hbmdc_test Exiting\n");
    return rc;
}  
