#include <stdio.h>
#include <stdlib.h>
#include "globus_hbm_client.h"
#include "globus_hbm_codes.h"
#include "globus_hbm_defaults.h"

static char reg_string[GLOBUS_HBM_BUFF_SIZE_MAX];
static char hostname[MAXHOSTNAMELEN];
static char message[] = "\"This is a test message\"";
static char rptname[] = "\"Globus Heartbeat Monitor Test Program\"";
static int port = 1301;
static int interval = 10;

int main()
{
    int rc;
    globus_hbm_client_regerr_t regerr;

    /* build up message */
    if( gethostname( hostname, MAXHOSTNAMELEN ) != 0 )
    {
	printf("gethostname() failed\n");
	return( GLOBUS_SUCCESS );
    }
    sprintf( reg_string, "& (Message = %s)(Rptname = %s)"
	     "(Hostname = %s)(Portnum = %d)(Interval = %d)",
	     message, rptname, hostname, port, interval);
    
    if( globus_module_activate(GLOBUS_HBM_CLIENT_MODULE) != GLOBUS_SUCCESS )
    {
	printf("globus_module_activate(): failed\n");
	return( GLOBUS_SUCCESS ); 
    }
    printf("globus_module_activate(): succeeded\n");
    
    rc = globus_hbm_client_register( (pid_t)-1, (char*)&reg_string,
				     GLOBUS_FALSE ,
				     GLOBUS_NULL, &regerr );
    if( rc == GLOBUS_FAILURE )
    {
	printf("globus_hbm_client_register() failed\n");
	return GLOBUS_SUCCESS;
    }
    printf("globus_hbm_client_register(): succeeded\n");
    

    rc = globus_hbm_client_unregister_all( (pid_t)-1,
					   GLOBUS_HBM_SHUTDOWN_NORMAL,
					   GLOBUS_NULL );

    if( rc == GLOBUS_FAILURE )
    {
	printf("globus_hbm_client_unregister_all() failed\n");
	return GLOBUS_SUCCESS;
    }
    printf("globus_hbm_client_unregister_all(): succeeded\n");

    if( globus_module_deactivate(GLOBUS_HBM_CLIENT_MODULE) != GLOBUS_SUCCESS )
    {
	printf("globus_module_deactivate(): failure\n");
	return( GLOBUS_FAILURE );
    }
    printf("globus_module_deactivate(): succeeded\n");

    printf("Simple Heartbeat Monitor Test Succeeded\n");
    
    return GLOBUS_SUCCESS;
}



