/*
************************************************************************
**                                                                    **
**  hbm_list_macros.h - macros for list manipulation                  **
**                                                                    **
************************************************************************
*/
#ifndef HBM_LIST_MACROS_H
#define HBM_LIST_MACORS_H

#define ListPrepend(List_ptr, Cell_ptr) \
        (Cell_ptr)->prev = NULL; \
        (Cell_ptr)->next = (List_ptr)->head; \
        if  ((List_ptr)->head) \
            (List_ptr)->head->prev = (Cell_ptr); \
        if  ((List_ptr)->tail == NULL) \
            (List_ptr)->tail = (Cell_ptr); \
        (List_ptr)->head = (Cell_ptr);

#define ListAppend(List_ptr, Cell_ptr) \
        (Cell_ptr)->prev = (List_ptr)->tail; \
        (Cell_ptr)->next = NULL; \
        if  ((List_ptr)->head == NULL) \
            (List_ptr)->head = (Cell_ptr); \
        if  ((List_ptr)->tail) \
            (List_ptr)->tail->next = (Cell_ptr); \
        (List_ptr)->tail = (Cell_ptr); \

#define ListRemove(List_ptr, Cell_ptr) \
        if  ((Cell_ptr)->prev) \
            (Cell_ptr)->prev->next = (Cell_ptr)->next; \
        else \
            (List_ptr)->head = (Cell_ptr)->next; \
        if  ((Cell_ptr)->next) \
            (Cell_ptr)->next->prev = (Cell_ptr)->prev; \
        else \
            (List_ptr)->tail = (Cell_ptr)->prev; \
        (Cell_ptr)->next = (Cell_ptr)->prev = NULL;

#define ListInsertBefore(List_ptr, Cell_ptr, Where_ptr) \
        if  (Where_ptr) \
        { \
            (Cell_ptr)->prev = (Where_ptr)->prev; \
            (Cell_ptr)->next = (Where_ptr); \
            if  ((Where_ptr)->prev) \
                (Where_ptr)->prev->next = (Cell_ptr); \
            else \
                (List_ptr)->head = (Cell_ptr); \
            (Where_ptr)->prev = (Cell_ptr); \
        } \
        else \
        { \
            ListAppend(List_ptr, Cell_ptr) \
        }

#define ListInsertAfter(List_ptr, Cell_ptr, Where_ptr) \
        if  (Where_ptr) \
        { \
            (Cell_ptr)->prev = (Where_ptr); \
            (Cell_ptr)->next = (Where_ptr)->next; \
            if  ((Where_ptr)->next) \
                (Where_ptr)->next->prev = (Cell_ptr); \
            else \
                (List_ptr)->tail = (Cell_ptr); \
            (Where_ptr)->next = (Cell_ptr); \
        } \
        else \
        { \
            ListPrepend(List_ptr, Cell_ptr); \
        }

#endif /* not defined HBM_LIST_MACROS_H */
/*
************************************************************************
**                                                                    **
**  hbm_list_macros.h - end                                           **
**                                                                    **
************************************************************************
*/
