/*
************************************************************************
**                                                                    **
**  hbm_common.h                                                      **
**                                                                    **
************************************************************************
*/
#ifndef HBM_COMMON_H
#define HBM_COMMON_H

#include "globus_hbm_codes.h"

#ifndef HAVE_UTCTIME
#define HAVE_UTCTIME 1
typedef time_t UTCtime;
#endif

/*
**  The next two structs and the corresponding typedefs are used in:
**      globus-hbm-localmonitor.c and
**      hbmcl.c
**  They have the information regarding clients, and as such are used
**  when calling ps to validate or check the status on client processes
**  that are being registered or monitored.
*/

/*  fields per data collector (for a client)  */
struct hbmlm_cldc_fields_s {
    struct hbmlm_cldc_fields_s* next;
    struct hbmlm_cldc_fields_s* prev;
    char*                       CL_DCHostIPNum_str;
    struct sockaddr_in          CL_DCaddrRpt;
    char*                       CL_procNameRpt_str;
    UTCtime                     CL_regTime;
    unsigned int                CL_DCMsgNum;
    char*                       CL_DCMsgString;
    unsigned int                CL_rptNumber;
    UTCtime                     CL_rptTimeLast;
    unsigned int                CL_rptInterval;
    UTCtime                     CL_rptTimeNext;
    unsigned int                CL_shutdownType;
    UTCtime                     CL_shutdownTime; /* unregistration time */
    unsigned int                CL_shutdownMsgCt;
};
typedef struct hbmlm_cldc_fields_s hbmlm_cldc_fields_t;

struct hbmlm_cldc_list_head_s {
    hbmlm_cldc_fields_t*        head;
    hbmlm_cldc_fields_t*        tail;
};
typedef struct hbmlm_cldc_list_head_s hbmlm_cldc_list_head_t;

/*  client specific data fields  */
struct hbmlm_cl_fields_s {
    struct hbmlm_cl_fields_s*   prev;
    struct hbmlm_cl_fields_s*   next;
    unsigned int                CL_procPID;
    char*                       CL_procName_str;
    unsigned int                CL_procStatus;
    UTCtime                     CL_blockedTime;
    unsigned int                CL_cpuSecs;
    globus_bool_t               CL_updated;
    hbmlm_cldc_list_head_t      CL_dclist; /* list of data collector info */
};
typedef struct hbmlm_cl_fields_s hbmlm_cl_fields_t;

struct hbmlm_cl_list_head_s {
    hbmlm_cl_fields_t*          head;
    hbmlm_cl_fields_t*          tail;
};
typedef struct hbmlm_cl_list_head_s hbmlm_cl_list_head_t;




/*
**  globus_l_hbm_hbmdc_free_allocated_memory( void* pointer )
**  checks if pointer is not GLOBUS_NULL,
**  if so, frees it and sets to GLOBUS_NULL.
*/
#define globus_hbm_free( pointer ) \
{ \
    if( pointer != GLOBUS_NULL ) \
    { \
        globus_free( pointer ); \
        pointer = GLOBUS_NULL; \
    } \
}

/*
 * PackUInt32(unsigned char Array[4], unsigned long I)
 *
 * Pack the unsigned long I into the 4 byte unsigned
 * character Array in 32-bit, big-endian format.
 */
#define PackUInt32(Array, I) \
{ \
    (Array)[0] = (unsigned char) (((unsigned long)(I) & 0xFF000000) >> 24); \
    (Array)[1] = (unsigned char) (((unsigned long)(I) & 0xFF0000) >> 16); \
    (Array)[2] = (unsigned char) (((unsigned long)(I) & 0xFF00) >> 8); \
    (Array)[3] = (unsigned char)  ((unsigned long)(I) & 0xFF); \
}

/*
 * UnpackUInt32(unsigned char Array[4], unsigned long I)
 *
 * Unpack the 32-bit, big-endian unsigned value from the
 * 4 byte character Array into the unsigned long I.
 */
#define UnpackUInt32(Array, I) \
{ \
    (I) = (  ( ((unsigned long) (unsigned char)(Array)[0]) << 24) \
           | ( ((unsigned long) (unsigned char)(Array)[1]) << 16) \
           | ( ((unsigned long) (unsigned char)(Array)[2]) << 8) \
           |   ((unsigned long) (unsigned char)(Array)[3])); \
}


/* used with the Pack/Unpack macros */
#define NUM_PACKED_BYTES 4

extern int
globus_i_hbm_build_ps_command_string(
                char*                   ps_program_name_str,
                char**                  ps_call_str_ptr );

extern int
globus_i_hbm_call_ps_update_client_data(
                char*                   ps_command_options_str,
                hbmlm_cl_list_head_t    client_list,
                const int               call_ps_reason_code,
                struct timeval*         time_curr_ptr,
                FILE*                   error_file_ptr );

extern int
globus_i_hbm_compare_ps_name_to_client(
                char*                   ps_procname,
                hbmlm_cl_fields_t*      cl_fields );

extern UTCtime
globus_i_hbm_convert_string_to_UTCtime(
                char*                   string,
                long                    time_diff );

extern void
globus_i_hbm_convert_UTC_to_str(
                UTCtime                 time,
                char*                   date_time_str );

extern int
globus_i_hbm_count_chars_in_string(
                char*                   string,
                char                    c );

extern hbmlm_cl_fields_t*
globus_i_hbm_find_cl_fields_entry(
                hbmlm_cl_list_head_t*,
                unsigned long           cl_pid );

extern int
globus_i_hbm_get_inaddr_from_hostname(
                char*                   hostname,
                struct in_addr          *addr );

extern long
globus_i_hbm_get_time_conv_diff();

extern char*
globus_i_hbm_gethostname_from_addr(
                struct in_addr          *addr );

extern int
globus_i_hbm_read_line(
                int                     fd,
                char*                   buf,
                int                     max );

extern char*
globus_i_hbm_validate_path_get_filename(
                char*                   path_str,
                char*                   default_file_name );

#endif /* ifndef HBM_COMMON_H */

/*
************************************************************************
**                                                                    **
**  hbm_common.h - end                                                **
**                                                                    **
************************************************************************
*/
