/*
************************************************************************
**                                                                    **
**  hbm_defaults.h - include file for heartbeat default values        **
**                   and limit fields                                 **
**                                                                    **
************************************************************************
*/
#ifndef HBM_DEFAULTS_H
#define HBM_DEFAULTS_H


#define HBM_FD_SET_CAST NEXUS_FD_SET_CAST

#define GLOBUS_HBM_BUFF_SIZE_CKPT                           1024
#define GLOBUS_HBM_BUFF_SIZE_HOSTENT                        4096
#define GLOBUS_HBM_BUFF_SIZE_MAX                            8192
#define GLOBUS_HBM_BUFF_SIZE_MSG                            1024
#define GLOBUS_HBM_BUFF_SIZE_PS                             4096
#define GLOBUS_HBM_BUFF_SIZE_STATUS                          512

#define GLOBUS_HBM_DC_MSG_SIZE_MAX                           256

#define GLOBUS_HBM_DATE_TIME_LEN                              64

#define GLOBUS_HBM_DEFAULT_FNAME_PS     "ps"
#define GLOBUS_HBM_DEFAULT_PATH_PS      "/bin/ps"

#define GLOBUS_HBM_PORT_MIN_AVAILABLE            (u_short)  1024
#define GLOBUS_HBM_PORT_MAX_AVAILABLE            (u_short) 65535

#define GLOBUS_HBM_TIME_SECS_PER_MIN                          60
#define GLOBUS_HBM_TIME_SECS_PER_HOUR                       3600
#define GLOBUS_HBM_TIME_SECS_PER_DAY                       86400

#define GLOBUS_HBMDC_DEFAULT_MONITOR_INTERVAL                 15
#define GLOBUS_HBMDC_DEFAULT_PORT_HBMSG          (u_short) 12003

#define HBMCL_ACK_TIMEOUT                                     30 /* seconds */
#define HBMCL_DEFAULT_LM_VALIDATE_SECONDS                    180

#define HBMCL_SHORT_MSG_LEN                                   12

/*  Keep shutdown client info for 12 hours (12*60*60 = 43200)  */
#define HBMDC_CL_SHUTDOWN_RETENTION_SECS                   43200

/*  Default evaluation interval is 10 seconds, max is 900 seconds (15 min)  */
#define HBMDC_DEFAULT_EVAL_INTERVAL_SECS                      10
#define HBMDC_DEFAULT_HEARTBEATS_MISSING_OVERDUE               2
#define HBMDC_DEFAULT_HEARTBEATS_MISSING_SHUTDOWN              5

#define HBMDC_DEFAULT_NETWORK_VAR_ALLOWANCE_SECS               2

#define HBMDC_LIM_EVAL_INTERVAL_SECS_MIN                       5
#define HBMDC_LIM_EVAL_INTERVAL_SECS_MAX                     900
#define HBMDC_LIM_HB_INTERVAL_SECS_MIN                         1
#define HBMDC_LIM_HB_INTERVAL_SECS_MAX                      3600
#define HBMDC_LIM_HEARTBEATS_MISSING_OVERDUE_MIN               1
#define HBMDC_LIM_HEARTBEATS_MISSING_OVERDUE_MAX             100
#define HBMDC_LIM_HEARTBEATS_MISSINGSECS_OVERDUE_MIN           1
#define HBMDC_LIM_HEARTBEATS_MISSINGSECS_OVERDUE_MAX        3600
#define HBMDC_LIM_HEARTBEATS_MISSING_SHUTDOWN_MIN              1
#define HBMDC_LIM_HEARTBEATS_MISSING_SHUTDOWN_MAX           1000
#define HBMDC_LIM_HEARTBEATS_MISSINGSECS_SHUTDOWN_MIN          1
#define HBMDC_LIM_HEARTBEATS_MISSINGSECS_SHUTDOWN_MAX      86400
#define HBMDC_LIM_NETWORK_VAR_ALLOWANCE_SECS_MIN               1
#define HBMDC_LIM_NETWORK_VAR_ALLOWANCE_SECS_MAX              30

#define HBMDC_MSG_DELAY_OVERDUE                                5
#define HBMDC_MSG_NUM_OVERDUE_SHUTDOWN                        10


#define HBMLM_ACK_MSG_LEN                                      4

#define HBMLM_DEFAULT_FNAME_CHKPT       "globus-hbm-localmonitor.checkpoint"
#define HBMLM_DEFAULT_FNAME_LOG         "globus-hbm-localmonitor.log"
#define HBMLM_DEFAULT_FNAME_STATUS      "globus-hbm-localmonitor.status"

#define HBMLM_DEFAULT_PORT_REG                   (u_short) 12001
#define HBMLM_DEFAULT_PORT_RPT                   (u_short) 12002
#define HBMLM_DEFAULT_RPT_INTERVAL                            15

#define HBMLM_LIM_REPORT_INTERVAL_MIN                          2
#define HBMLM_LIM_REPORT_INTERVAL_MAX                       3600

#endif /* not defined HBM_DEFAULTS_H */
/*
************************************************************************
**                                                                    **
**  hbm_defaults.h - end                                              **
**                                                                    **
************************************************************************
*/
