/*
************************************************************************
**                                                                    **
**  hbm_datacollector.h - include file for data collectors            **
**                                                                    **
************************************************************************
*/
#ifndef HBM_DATACOLLECTOR_H
#define HBM_DATACOLLECTOR_H

#include <sys/types.h>

#include "globus_common.h"
#include "globus_config.h"

/* hack for UTCtime, should go into configure */
#ifndef HAVE_UTCTIME
#define HAVE_UTCTIME 1
typedef time_t UTCtime;
#endif


/**********************************************************************
 *
 *  Module activation structure
 *
 **********************************************************************
*/
extern globus_module_descriptor_t       globus_i_hbm_datacollector_module;

#define GLOBUS_HBM_DATACOLLECTOR_MODULE (&globus_i_hbm_datacollector_module)


/*
** Definitions
*/

#define GLOBUS_HBM_DATACOLLECTOR_DEFAULT_OVERDUE_DELAY_SECS     10
#define GLOBUS_HBM_DATACOLLECTOR_DEFAULT_SHUTDOWN_NO_RPT_NUM_HB  4

#define GLOBUS_HBM_DATACOLLECTOR_FORCE_DESTROY_NO                1
#define GLOBUS_HBM_DATACOLLECTOR_FORCE_DESTROY_YES               2

/* increment by ^2, events are used in a bit-mask */
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_NONE                      0
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_REGISTRATION              1
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_HEARTBEAT_RECEIVED        2
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_HEARTBEAT_OVERDUE         4
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_SHUTDOWN_NORMAL           8
#define GLOBUS_HBM_DATACOLLECTOR_EVENT_SHUTDOWN_ABNORMAL        16

/*
** Data Structures
*/

struct globus_hbm_client_callbackdata_s{
    struct in_addr  cl_host_ipaddr;
    u_int           cl_pid;
    char*           cl_procname;
    u_int           cl_eventmask;
};
typedef struct globus_hbm_client_callbackdata_s globus_hbm_client_callbackdata_t;

typedef unsigned int globus_hbm_datacollector_handle_t;
typedef struct hbmdc_cl_fields_s hbmdc_cl_fields_t;
typedef hbmdc_cl_fields_t globus_hbm_datacollector_client_entry_t;


typedef void (* hbmdc_tcp_fd_cbf_t)(int fd, globus_hbm_datacollector_handle_t handle);
typedef void (* hbmdc_cbf_t)(globus_hbm_datacollector_handle_t  handle,
                             globus_hbm_client_callbackdata_t* callbackdata,
                             globus_hbm_datacollector_client_entry_t* client,
                             void* user_data);


struct hbmdc_cl_fields_s {
    struct in_addr                     CL_host_addr; /* obtained from HB */
    char*                              CL_hostIPNum;
    char*                              CL_procName;
    unsigned int                       CL_procPID;
    unsigned int                       CL_procStatus;
    UTCtime                            CL_regTime;
    UTCtime                            CL_blockedTime;
    int                                CL_cpuSecs;
    UTCtime                            CL_unregTime;
    UTCtime                            CL_deleteTime;
    unsigned int                       CL_rptNumber;
    UTCtime                            CL_rptTimeLast;
    int                                CL_rptInterval;
    UTCtime                            CL_rptTimeNext;
    int                                CL_overdue_secs;
    int                                CL_shutdown_no_rpt_secs;
    hbmdc_cbf_t                        CL_event_callback;
    u_int                              CL_eventmask;
    void*                              CL_event_callback_user_data;
    int                                CL_MsgNum;
    char*                              CL_Msg;
    struct hbmdc_cl_fields_s          *prev;
    struct hbmdc_cl_fields_s          *next;
};


/*
** Function Prototypes
*/

extern int
globus_hbm_datacollector_clear_unregistered_clients(
                globus_hbm_datacollector_handle_t
                                        dc_handle );

extern int
globus_hbm_datacollector_create(
                u_short*                hb_port_ptr,
                int                     eval_interval_secs,
                int                     network_variation_allowance_secs,
                int                     heartbeats_missing_overdue,
                int                     heartbeats_missing_shutdown,
                char*                   ckpt_filename_restore_str,
                char*                   ckpt_filename_str,
                FILE*                   log_file_ptr,
                void ( *proc_client_reg_callback_ptr )(
                            globus_hbm_datacollector_handle_t
                                        dc_handle,
                            globus_hbm_client_callbackdata_t*
                                        callbackdata_ptr,
                            globus_hbm_datacollector_client_entry_t*
                                        client_ptr,
                            void*       user_data_ptr ),
                            void*       user_data_ptr,
                            globus_hbm_datacollector_handle_t*
                                        dc_handle_ptr );

extern int
globus_hbm_datacollector_destroy(
                globus_hbm_datacollector_handle_t
                                        dc_handle,
                int                     force_mode,
                int*                    num_live_clients_ptr );

extern int
globus_hbm_datacollector_set_clientevent_callback(
                globus_hbm_datacollector_handle_t
                                        dc_handle,
                globus_hbm_client_callbackdata_t*
                                        client_callbackdata_ptr,
                u_int                   overdue_secs,
                u_int                   shutdown_no_rpt_secs,
                void*                   user_data_ptr,
                void ( *proc_event_callback_ptr )(
                            globus_hbm_datacollector_handle_t
                                        dc_handle,
                            globus_hbm_client_callbackdata_t*
                                        callbackdata_ptr,
                            globus_hbm_datacollector_client_entry_t*
                                        client_ptr,
                            void*       user_data_ptr ));

extern int
globus_hbm_datacollector_user_checkpoint(
                globus_hbm_datacollector_handle_t
                                        dc_handle,
                int                     chkpt_fd );

/*
** Temporary API calls to allow the Datacollector to do a blocking select.
** User needs to be able to register a routine that will spit out a
** checkpoint to a socket rather than a file.  This is done today with the
** web site on port 8337 of the datacollector.  When we get an independent
** event loop, this code will go into the users code rather than the API
*/
extern int
globus_hbm_datacollector_reg_tcpfd(
                int                     fd,
                void ( *request_callback )(
                            int         fd,
                            globus_hbm_datacollector_handle_t
                                        handle ),
                globus_hbm_datacollector_handle_t
                                        handle );
extern int
globus_hbm_datacollector_unreg_tcpfd(
                int                     fd,
                globus_hbm_datacollector_handle_t
                                        handle );

#endif /* HBM_DATACOLLECTOR_H */
/*
************************************************************************
**                                                                    **
**  hbm_datacollector.h - end                                         **
**                                                                    **
************************************************************************
*/
