/*
************************************************************************
**                                                                    **
**  globus_hbm_codes.h - include file for heartbeat codes and         **
**                       flag values                                  **
**                                                                    **
************************************************************************
*/
#ifndef GLOBUS_HBM_CODES_H
#define GLOBUS_HBM_CODES_H

#define GLOBUS_HBM_MSGTYPE_REGISTER                            0
#define GLOBUS_HBM_MSGTYPE_SHUTDOWN_NORMAL                     1
#define GLOBUS_HBM_MSGTYPE_SHUTDOWN_ABNORMAL                   2
#define GLOBUS_HBM_MSGTYPE_REGISTER_CANCEL                     3
#define GLOBUS_HBM_MSGTYPE_REGISTER_COMMIT                     4

/*
** possible values retured in globus_hbm_client_register
** globus_hbm_client_regerr_t.dc_error
*/
#define GLOBUS_HBM_FAILURE                                     1
#define GLOBUS_HBM_ACK_TIMEOUT                                 5
#define GLOBUS_HBM_OUT_OF_MEMORY                               3
#define GLOBUS_HBM_INCOMPATIBLE_VERSION                        4

#define GLOBUS_HBM_PROCSTATUS_MINVAL              (u_long)     0
#define GLOBUS_HBM_PROCSTATUS_UNKNOWN             (u_long)     0
#define GLOBUS_HBM_PROCSTATUS_ACTIVE              (u_long)     1
#define GLOBUS_HBM_PROCSTATUS_BLOCKED             (u_long)     2
#define GLOBUS_HBM_PROCSTATUS_OVERDUE             (u_long)     3
#define GLOBUS_HBM_PROCSTATUS_SHUTDOWN_NORMAL     (u_long)     4
#define GLOBUS_HBM_PROCSTATUS_SHUTDOWN_ABNORMAL   (u_long)     5
#define GLOBUS_HBM_PROCSTATUS_SHUTDOWN_DIED       (u_long)     6
#define GLOBUS_HBM_PROCSTATUS_SHUTDOWN_NO_RPT     (u_long)     7
#define GLOBUS_HBM_PROCSTATUS_MAXVAL              (u_long)     7

#define GLOBUS_HBM_LM_STATUS_UNKNOWN                           0
#define GLOBUS_HBM_LM_STATUS_ALIVE                             1
#define GLOBUS_HBM_LM_STATUS_DEGRADED                          2
#define GLOBUS_HBM_LM_STATUS_DEAD                              3

#define GLOBUS_HBM_VALIDATE_PATH_ERROR                        -1
#define GLOBUS_HBM_VALIDATE_PATH_INVALID                       0
#define GLOBUS_HBM_VALIDATE_PATH_VALID_DIRECTORY               1
#define GLOBUS_HBM_VALIDATE_PATH_VALID_FILE_EXISTS             2
#define GLOBUS_HBM_VALIDATE_PATH_VALID_FILE_NOT_EXISTS         3

#define GLOBUS_HBM_CALL_PS_GET_PROCNAME                        1
#define GLOBUS_HBM_CALL_PS_CHECK_PROCNAME                      2
#define GLOBUS_HBM_CALL_PS_GET_STATUS                          3

#endif /* GLOBUS_HBM_CODES_H */
/*
************************************************************************
**                                                                    **
**  globus_hbm_codes.h - end                                          **
**                                                                    **
************************************************************************
*/
