/*
************************************************************************
**                                                                    **
**  globus_hbm_client.h - include file for heartbeat clients          **
**                                                                    **
************************************************************************
*/
#ifndef GLOBUS_HBM_CLIENT_H
#define GLOBUS_HBM_CLIENT_H

#include "globus_common.h"
#include "globus_config.h"
#include "globus_rsl.h"

#include "globus_hbm_codes.h"


#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

EXTERN_C_BEGIN
/**********************************************************************
 *
 *  Module activation structure
 *
 **********************************************************************
*/
extern globus_module_descriptor_t       globus_i_hbm_client_module;

#define GLOBUS_HBM_CLIENT_MODULE (&globus_i_hbm_client_module)


/**********************************************************************
 *
 *  Structure and Type definitions
 *
 **********************************************************************
*/

struct globus_hbm_client_regerr_s {
    int num_reg_ok;
    int first_bad_dc;
    int dc_error;
};
typedef struct globus_hbm_client_regerr_s globus_hbm_client_regerr_t;


/**********************************************************************
 *
 *  Definitions
 *
 **********************************************************************
*/

#define GLOBUS_HBM_SHUTDOWN_NORMAL                          0
#define GLOBUS_HBM_SHUTDOWN_ABNORMAL                        1


/**********************************************************************
 *
 *  Function Prototypes
 *
 **********************************************************************
*/

extern int
globus_hbm_client_register(
                pid_t                   client_pid,
                char*                   dc_spec_str,
                globus_bool_t           require_all,
                char*                   lm_status_file_str,
                int                     lm_status_validation_time_limit_secs,
                globus_hbm_client_regerr_t*
                                        hbm_reg_return_ptr );

extern int
globus_hbm_client_unregister_all(
                pid_t                   client_pid,
                unsigned int            cl_unregister_mode,
                char*                   lm_status_file_str,
                int                     lm_status_validation_time_limit_secs );


EXTERN_C_END

#endif /*  not defined GLOBUS_HBM_CLIENT_H  */
/*
************************************************************************
**                                                                    **
**  end of hbm_client.h                                               **
**                                                                    **
************************************************************************
*/
