/*
** TODO: This file is no longer correct, needs to be fixed
*/

/*
************************************************************************
**  Example GUSTO Heartbeat Client                                    **
************************************************************************
*/

/*
************************************************************************
**  Include the include file globus_hbm_client.h                      **
************************************************************************
*/
#include "globus_hbm_client.h"
/*
************************************************************************
**  Include the include file globus_hbm_client.h (above)              **
************************************************************************
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>

int
main(   argc,
        argv)
    int                 argc;
    char                *argv[];
{
    int                 array_idx,
                        array_idx_max   = 1023;

    int                 array_wk[1024];

    int                 retcd;

    struct timeval      time_curr,
                        time_end;

    globus_hbm_client_regerr_t
                        regerr;

    time_curr.tv_sec = 0;
    gettimeofday(       &time_curr,
                        NULL);
    time_end.tv_sec = time_curr.tv_sec + 120;

/*
************************************************************************
**  Include the following code to register with the                   **
**  heartbeat monitor.                                                **
**                                                                    **
**  Definition of globus_hbm_client_register is as follows:           **
**                                                                    **
**  int  globus_hbm_client_register( client_pid,                      **
**                                   dc_spec_str,                     **
**                                   require_all,                     **
**                                   lm_status_file_str,              **
**                                   hbm_reg_return_ptr )             **
**                                                                    **
**  Parameters:                                                       **
**      pid_t client_pid - pid type (unsigned short on most systems), **
**                        pid of the process to register,             **
**                        -1 for the calling process                  **
**      char* dc_spec_str -                                           **
**                        rsl string specifying the data collector(s) **
**                        to which heartbeat messages are to be sent, **
**                        and the parameters for doing so.            **
**                        Format:                                     **
**                            &(Host=999.999.999.999)(Portnum=99999)  **
**                             (Rptname=xxxx)(Interval=9999)          **
**                             (Message=xxxx)                         **
**                        Where Host and Portnum are required, and    **
**                        the other fields are optional.              **
**      globus_bool_t require_all -                                   **                                                  **
**                        A flag designating that the registration    **
**                        should only be done if all of the DC specs  **
**                        validate and can be properly registered     **
**                        (if value is GLOBUS_TRUE)                   **
**                        or that registration for the valid dc specs **
**                        should be done even if there are others     **
**                        that are invalid (if GLOBUS_FALSE)          **
**      char* lm_status_file_str -                                    **
**                        Name of the file with the LM status         **
**                        The file contains LM PID and Process name   **
**                        (for validation) and a port number (to use  **
**                        for the TCP connection with the LM)         **
**      int lm_status_validation_time_limit_secs -                    **
**                        The total amount of time (maximum) that     **
**                        should be spent trying to validate the      **
**                        Local Monitor before giving up and          **
**                        declaring failure.                          **
**                        (-1 means never give up).                   **
**      globus_hbm_client_regerr_t* hbm_reg_return_ptr -              **
**                        pointer to an error return code struct with **
**                        the following elements:                     **
**                            int num_reg_ok -                        **
**                                the number of DCs for which the     **
**                                registration was successful         **
**                            int first_bad_dc -                      **
**                                the number (starting with 1) of the **
**                                first DC for which registration     **
**                                failed (0 if all successful)        **
**                            int dc_error -                          **
**                                error code for the first failed     **
**                                registration                        **
**                                (0 if internal failure)             **
**                                                                    **
**  Returned values:                                                  **
**      globus_hbm_client_register() returns an integer return code.  **
**          Successful completion:   = 0.                             **
**          Unsuccessful completion: < 0.                             **
**                                                                    **
**  Operation:                                                        **
**      globus_hbm_client_register()  reads the file named by         **
**      lm_status_file_str to get the pid and process name to verify  **
**      that the Local Monitor (LM) is running. It tries every        **
**      seconds until the total time consumed exceeds .                **
**      If it succeeds in validating the LM, then it uses the         **
**      registration port number (also from the status file) to       **
**      establish a tcp connection with the LM to do the              **
**      registration. It then opens a tcp connection for registering, **
**      registers, and closes the tcp socket.                         **
**                                                                    **
************************************************************************
*/

    globus_libc_fprintf(
                        stderr,
                        "registerring\n" );
    if( globus_module_activate( GLOBUS_HBM_CLIENT_MODULE ) != GLOBUS_SUCCESS )
    {
        globus_libc_fprintf(
                        stderr,
                        "globus_module_activate(): FAILED\n" );

        return GLOBUS_FAILURE;
    }

    if(( retcd = globus_hbm_client_register(
                        -1,
                        /*  Note that Host and Portnum are required,
                            the rest are optional. */
                        "&(Host=130.221.194.176)(Portnum=12003)"
                        "(Rptname=testprocname)"
                        "(Interval=5)"
                        "(Message=yourid@your.host.name)",
                        GLOBUS_FALSE,
                        "../var/globus-hbm-localmonitor.status",
                        180,
                        &regerr )) != GLOBUS_SUCCESS )
    {
        globus_libc_fprintf(
                        stderr,
                        "\n%s: Error on registration\n",
                        *argv );

        return retcd;
    }
    globus_libc_fprintf(
                        stderr,
                        "registered successfully\n" );

/*
************************************************************************
**  End of code for registering with the Heartbeat Monitor.           **
************************************************************************
*/

    while( time_curr.tv_sec <= time_end.tv_sec )
    {
        globus_libc_fprintf(
                        stderr,
                        "time remaining: %3ld seconds\n",
                        time_end.tv_sec-time_curr.tv_sec );
        sleep( (unsigned int) 5 );
        for(    array_idx = 0;
                array_idx < array_idx_max;
                array_idx++ )
            array_wk[array_idx] = array_idx_max - array_idx;
        gettimeofday( &time_curr, NULL );
    }


/*
************************************************************************
**  Include the following code to un-register with the                **
**  heartbeat monitor.                                                **
**                                                                    **
**  Definition of globus_hbm_client_unregister_all is as follows:     **
**                                                                    **
**  int  globus_hbm_client_unregister_all( client_pid,                **
**                                         cl_unregister_mode,        **
**                                         lm_status_file_str )       **
**                                                                    **
**  Parameters:                                                       **
**      pid_t client_pid - pid type (unsigned short on most systems), **
**                        pid of the process to register,             **
**                        -1 for the calling process                  **
**      unsigned int cl_unregister_mode -                             **
**                        Integer code for unregistration type.       **
**                        Valid values are:                           **
**                            GLOBUS_HBM_SHUTDOWN_NORMAL -            **
**                                Normal unregistration.              **
**                            GLOBUS_HBM_SHUTDOWN_ABNORMAL -          **
**                                Abnormal registration, as when      **
**                                terminating due to a trapped error. **
**      char* lm_status_file_str -                                    **
**                        Name of the file with the LM status         **
**                        The file contains LM PID and Process name   **
**                        (for validation) and a port number (to use  **
**                        for the TCP connection with the LM)         **
**      int lm_status_validation_time_limit_secs -                    **
**                        The total amount of time (maximum) that     **
**                        should be spent trying to validate the      **
**                        Local Monitor before giving up and          **
**                        declaring failure.                          **
**                        (-1 means never give up).                   **
**                                                                    **
**  Returned values:                                                  **
**      globus_hbm_client_unregister_all() returns an integer return  **
**          code.                                                     **
**          Successful completion:   = 0.                             **
**          Unsuccessful completion: < 0.                             **
**                                                                    **
**  Operation:                                                        **
**      globus_hbm_client_unregister_all()  reads the file named by   **
**      lm_status_file_str to get the pid and process name to verify  **
**      that the Local Monitor (LM) is running. It tries 12 times     **
**      over the course of a minute (every 5 seconds).                **
**      If it succeeds in validating the LM, then it uses the         **
**      registration port number (also from the status file) to       **
**      establish a tcp connection with the LM to do the              **
**      unregistration. It then opens a tcp connection for            **
**      unregistering, unregisters, and closes the tcp socket.        **
**                                                                    **
************************************************************************
*/
    globus_libc_fprintf(
                        stderr,
                        "unregisterring\n" );
    if(( retcd = globus_hbm_client_unregister_all(
                        -1,
                        GLOBUS_HBM_SHUTDOWN_NORMAL,
                        "../var/globus-hbm-localmonitor.status",
                        180 )) !=
                                GLOBUS_SUCCESS )
    {
        globus_libc_fprintf(
                        stderr,
                        "\n%s: Error on unregistration\n",
                        *argv );

        return retcd;
    }
    globus_libc_fprintf(
                        stderr,
                        "unregistered successfully\n" );
    if( globus_module_deactivate( GLOBUS_HBM_CLIENT_MODULE ) != GLOBUS_SUCCESS )
    {
        globus_libc_fprintf(
                        stderr,
                        "globus_module_deactivate(): failure.\n\n" );

        return GLOBUS_FAILURE;
    }

  /*
************************************************************************
**  End of code for unregistering with the Heartbeat Monitor.         **
************************************************************************
*/

    globus_libc_fprintf(
                        stdout,
                        "\n%s: Done\n",
                        *argv );

    return 0;
}
