#include "globus_gass_transfer_assist.h"
#include <stdlib.h>

enum
{
    UNKNOWN,
    GET,
    PUT,
    APPEND
};

int
main(
    int					argc,
    char **				argv)
{
    int					c;
    int					mode = UNKNOWN;
    globus_gass_transfer_request_t	request;
    extern int				optind;
    extern char *			optarg;

    while((c = getopt(argc, argv, "pag")) != EOF)
    {
	switch(c)
	{
	  case 'p':
	    mode = PUT;
	    break;

	  case 'a':
	    mode = APPEND;
	    break;

	  case 'g':
	    mode = GET;
	    break;

	  default:
	    printf("Usage: %s -p|-a|-g url\n",
		   argv[0]);
	    return 1;
	}
    }
    if(optind == argc ||
       mode == UNKNOWN)
    {
	printf("Usage: %s -p|-a|-g url\n",
	       argv[0]);
	return 2;
    }

    globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_module_activate(GLOBUS_GASS_TRANSFER_MODULE);

    if(mode == GET)
    {
	globus_gass_transfer_assist_get_file_from_url(&request,
						      GLOBUS_NULL,
						      argv[optind],
						      "/dev/stdout",
						      GLOBUS_NULL);
    }
    else if(mode == PUT)
    {
	globus_gass_transfer_assist_put_file_to_url(&request,
						GLOBUS_NULL,
						argv[optind],
						"/etc/termcap",
						GLOBUS_NULL);
    }
    else if(mode == APPEND)
    {
	globus_gass_transfer_assist_append_file_to_url(&request,
						GLOBUS_NULL,
						argv[optind],
						"/etc/termcap",
						GLOBUS_NULL);
    }
}

