#include "globus_gass_transfer.h"
#include <stdlib.h>

globus_bool_t done = GLOBUS_FALSE;
globus_mutex_t mutex;
globus_cond_t cond;

int buflen=999;
int read_bytes=0;
int failure_bytes=10000000;
char * subject = GLOBUS_NULL;

void
fail_callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    printf("Request %d failed\n",
	   (int)request);
    globus_gass_transfer_request_destroy(request);
}

void
bytes_callback(
    void *arg,
    globus_gass_transfer_request_t request,
    globus_byte_t *	bytes,
    globus_size_t	len,
    globus_bool_t	last_data)
{
    int i;

    globus_mutex_lock(&mutex);
    for(i = 0; i < len; i++)
    {
	printf("%c", bytes[i]);
    }
    read_bytes += len;

    fflush(stdout);
    if(last_data)
    {
	globus_gass_transfer_request_status_t status;
	done=GLOBUS_TRUE;
	status = globus_gass_transfer_request_get_status(request);
	if(status != GLOBUS_GASS_TRANSFER_REQUEST_DONE)
	{
	    printf("request failed!?!\n");
	}
	else
	{
	    printf("request succeeded\n");
	}
	globus_free(bytes);
	globus_gass_transfer_request_destroy(request);
	globus_cond_signal(&cond);
    }
    else if(read_bytes >= failure_bytes)
    {
	done=GLOBUS_TRUE;
	globus_free(bytes);
	globus_gass_transfer_fail(request,
				  fail_callback,
				  GLOBUS_NULL);
    }
    else
    {
	globus_gass_transfer_receive_bytes(
	    request,
	    bytes,
	    buflen,
	    1,
	    bytes_callback,
	    GLOBUS_NULL);
    }
    globus_mutex_unlock(&mutex);
}

void
callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    globus_gass_transfer_request_status_t status;
    globus_gass_transfer_requestattr_t *  attr;

    attr = (globus_gass_transfer_requestattr_t *) arg;

    status = globus_gass_transfer_request_get_status(request);

    switch(status)
    {
      case GLOBUS_GASS_TRANSFER_REQUEST_REFERRED:
	{
	    globus_gass_transfer_referral_t		referral;
	    int rc;

	    globus_gass_transfer_request_get_referral(request,
						      &referral);
	    globus_gass_transfer_request_destroy(request);

	    printf("Referral to %s\n",
		   globus_gass_transfer_referral_get_url(&referral,
							 0));
	    rc = globus_gass_transfer_register_get(
		&request,
		attr,
		globus_gass_transfer_referral_get_url(&referral,
						      0),
		callback,
		attr);
	    globus_gass_transfer_referral_destroy(&referral);
	    if(rc != GLOBUS_SUCCESS)
	    {
		printf("get of referred entity failed\n");
		goto wakeup_main;
	    }
	    break;
	}
      case GLOBUS_GASS_TRANSFER_REQUEST_PENDING:
	printf("pending\n");
	globus_gass_transfer_receive_bytes(
	    request,
	    globus_malloc(buflen),
	    buflen,
	    1,
	    bytes_callback,
	    GLOBUS_NULL);
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_DONE:
	printf("done\n");
	goto wakeup_main;
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_DENIED:
	printf("denied: %d %s\n",
	       globus_gass_transfer_request_get_denial_reason(request),
	       globus_gass_transfer_request_get_denial_message(request));
	goto wakeup_main;
      case GLOBUS_GASS_TRANSFER_REQUEST_FAILED:
	printf("failed\n");
	goto wakeup_main;
    }
    return;
  wakeup_main:
    globus_gass_transfer_request_destroy(request);
    globus_mutex_lock(&mutex);
    done = 1;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);

    return;
}

int main(int argc, char **argv)
{
    globus_gass_transfer_request_t 	request[5];
    globus_gass_transfer_requestattr_t  attr;
    char *				url;
    int					c;
    globus_bool_t			textmode = GLOBUS_FALSE;
    globus_size_t			blocksize = 0;
    extern int				optind;
    extern char *			optarg;
    globus_url_t			purl;
    int					rc;
    int					i;

    while ((c = getopt(argc, argv, "tb:f:s:")) != EOF)
    {
	switch (c)
	{
	  case 't':
	    textmode=GLOBUS_TRUE;
	    break;
	  case 'b':
	    blocksize = atoi(optarg);
	    break;
	  case 'f':
	    failure_bytes = atoi(optarg);
	    break;
	  case 's':
	    subject = optarg;
	    break;
	  default:
	    printf("Usage: %s [-t] [-b blocksize] [-f fail_after] [-s subject] [URL]\n");
	    return 1;
	}
    }
    if(optind < argc)
    {
	url = argv[optind];
    }
    else
    {
	url = "http://www.globus.org/gass";
    }

    globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_module_activate(GLOBUS_GASS_TRANSFER_MODULE);

    rc = globus_url_parse(url,
			  &purl);
    if(rc != GLOBUS_SUCCESS)
    {
	goto finish;
    }
    globus_mutex_init(&mutex,
		      GLOBUS_NULL);
    globus_cond_init(&cond,
		     GLOBUS_NULL);

    globus_gass_transfer_requestattr_init(&attr,
					  purl.scheme);
    
    if(strcmp(purl.scheme, "https") == 0)
    {
	if(subject)
	{
	    globus_gass_transfer_secure_requestattr_set_authorization(
		&attr,
		GLOBUS_GASS_TRANSFER_AUTHORIZE_SUBJECT,
		subject);
	}
    }
    globus_url_destroy(&purl);

    if(textmode)
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_TEXT);
    }
    else
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_BINARY);
    }

    if(blocksize)
    {
	globus_gass_transfer_requestattr_set_block_size(
	    &attr,
	    1024*1024);
    }

    for(i = 0; i < 5; i++)
    {
	globus_gass_transfer_register_get(
	    &request[i],
	    &attr,
	    url,
	    callback,
	    &attr);
    }

    /*
    globus_mutex_lock(&mutex);
    while(!done)
    {
	globus_cond_wait(&cond, &mutex);
    }
    globus_mutex_unlock(&mutex);
    */

    globus_gass_transfer_requestattr_destroy(&attr);

  finish:
    globus_module_deactivate(GLOBUS_GASS_TRANSFER_MODULE);
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
}

