#include "globus_gass_transfer.h"
#include <stdlib.h>
#include <fcntl.h>

globus_bool_t done = GLOBUS_FALSE;
globus_mutex_t mutex;
globus_cond_t cond;

int buflen=999;
int read_bytes=0;
int failure_bytes=10000000;
globus_bool_t send_length = GLOBUS_FALSE;
char * subject = GLOBUS_NULL;
globus_gass_transfer_requestattr_t  attr;
globus_bool_t in_accept;

static
void
listen_callback(
    void *				callback_arg,
    globus_gass_transfer_listener_t	listener);

void
fail_callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    printf("Request %d failed\n",
	   (int)request);
    globus_gass_transfer_request_destroy(request);
}

void
bytes_callback(
    void *arg,
    globus_gass_transfer_request_t request,
    globus_byte_t *	bytes,
    globus_size_t	len,
    globus_bool_t	last_data)
{
    int fd;
    globus_size_t amt;

    fd = (int) arg;
    switch(globus_gass_transfer_request_get_type(request))
    {
      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_APPEND:
      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_PUT:
	fd = (int) arg;

	globus_libc_write(fd, bytes, len);
	if(last_data)
	{
	    goto finish_up;
	}
	globus_gass_transfer_receive_bytes(request,
					   bytes,
					   1024,
					   1,
					   bytes_callback,
					   arg);
	return;

      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_GET:
	fd = (int) arg;
	amt = globus_libc_read(fd, bytes, len);
	if(last_data)
	{
	    goto finish_up;
	}
	if(amt == 0)
	{
	    globus_gass_transfer_send_bytes(request,
					    bytes,
					    0,
					    GLOBUS_TRUE,
					    bytes_callback,
					    arg);
	}
	else
	{
	    globus_gass_transfer_send_bytes(request,
					    bytes,
					    amt,
					    GLOBUS_FALSE,
					    bytes_callback,
					    arg);
	}
	return;
    }
    
  finish_up:
    close(fd);
    globus_free(bytes);
    globus_gass_transfer_request_destroy(request);
}

static
void
close_callback(
    void *				callback_arg,
    globus_gass_transfer_listener_t	listener)
{
    if(!(int)callback_arg)
    {
	globus_mutex_lock(&mutex);
	done = 1;
	printf("Signalling done from close_callback\n");
	globus_cond_signal(&cond);
	globus_mutex_unlock(&mutex);
    }
}

static
void
accept_callback(
    void *				arg,
    globus_gass_transfer_request_t	request)
{
    char *				url;
    char				result;
    char *				referral_url[1] = { "http://www.globus.org/gass" };
    globus_url_t			parsed_url;
    int					flags;
    int					rc;
    struct stat				s;
    globus_byte_t *			buf;
    globus_size_t			amt;
    char *				subject;

    printf("accept callback\n");

    url = globus_gass_transfer_request_get_url(request);

    if(url == GLOBUS_NULL)
    {
	printf("Bogus request\n");
	fflush(stdout);
	goto reregister;
    }

    subject = globus_gass_transfer_request_get_subject(request);

    if(subject)
    {
	printf("Request from <%s>\n", subject);
    }
    switch(globus_gass_transfer_request_get_type(request))
    {
      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_PUT:
	printf("PUT %s [A/R/D]: ", url);
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_APPEND:
	printf("APPEND %s [A/R/D]: ", url);
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_GET:
	printf("GET %s [A/R/D]: ", url);
	break;
      default:
	printf("unupported or invalid request, ignoring....\n");
    }

    fflush(stdout);
    do
    {
	scanf("%c", &result);
    } while(result != 'a' &&
	    result != 'A' &&
	    result != 'D' &&
	    result != 'd' &&
	    result != 'r' &&
	    result != 'R');

    switch(result)
    {
      case 'A':
      case 'a':
	flags=0;
	/* authorize */
	switch(globus_gass_transfer_request_get_type(request))
	{
	  case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_APPEND:
	    flags = O_CREAT | O_APPEND;
	  case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_PUT:
	    flags |= (O_CREAT | O_WRONLY);
	    globus_url_parse(url,
			     &parsed_url);
	    rc = globus_libc_open(parsed_url.url_path, flags, 0600);
	    globus_url_destroy(&parsed_url);
	    if(rc < 0)
	    {
		goto deny;
	    }
	    globus_gass_transfer_authorize(request, 0);
	    globus_gass_transfer_receive_bytes(request,
					       globus_malloc(1024),
					       1024,
					       1,
					       bytes_callback,
					       (void *) rc);
	    break;
	  case GLOBUS_GASS_TRANSFER_REQUEST_TYPE_GET:
	    flags = O_RDONLY;
	    globus_url_parse(url,
			     &parsed_url);
	    rc = globus_libc_open(parsed_url.url_path, flags, 0600);
	    if(rc < 0)
	    {
		goto deny;
	    }
	    globus_url_destroy(&parsed_url);
	    fstat(rc, &s);

	    buf = globus_malloc(1024);
	    if(s.st_size != 0)
	    {
		amt = read(rc, buf, 1024 > s.st_size ? s.st_size : 1024);
	    }
	    else
	    {
		amt = -1;
	    }
	    if(amt == -1)
	    {
		globus_free(buf);
		goto deny;
	    }
	    globus_gass_transfer_authorize(request,
					   send_length ? s.st_size : 0);

	    globus_gass_transfer_send_bytes(request,
					    buf,
					    amt,
					    GLOBUS_FALSE,
					    bytes_callback,
					    (void *) rc);
	    break;
	  default:
	    printf("unupported or invalid request, ignoring....\n");
	}
	break;
      case 'R':
      case 'r':
	/* refer */
	globus_gass_transfer_refer(request,
				   referral_url,
				   1);
	globus_gass_transfer_request_destroy(request);
	break;
      case 'D':
      case 'd':
      deny:
	globus_mutex_lock(&mutex);
	globus_gass_transfer_deny(request, 404, "Not Found");
	globus_gass_transfer_request_destroy(request);
	globus_gass_transfer_close_listener((globus_gass_transfer_listener_t) arg,
					close_callback,
					(void *) (result=='a' || result == 'A'));
	globus_gass_transfer_request_destroy(request);
	globus_mutex_unlock(&mutex);
	return;
    }
  reregister:
    globus_gass_transfer_register_listen((globus_gass_transfer_listener_t) arg,
					 listen_callback,
					 &attr);

}

static
void
listen_callback(
    void *				callback_arg,
    globus_gass_transfer_listener_t	listener)
{
    globus_gass_transfer_request_t	request;
    printf("listener ready!\n");

    globus_gass_transfer_register_accept(&request,
					 (globus_gass_transfer_requestattr_t *)
					 callback_arg,
					 listener,
					 accept_callback,
					 (void *) listener);
}

int
main(int argc, char **argv)
{
    globus_gass_transfer_request_t 	request;
    char *				url;
    int					c;
    globus_bool_t			textmode = GLOBUS_FALSE;
    globus_size_t			blocksize = 0;
    extern int				optind;
    extern char *			optarg;
    globus_url_t			purl;
    int					rc;
    globus_bool_t			secure = GLOBUS_FALSE;
    char *				base_url;
    globus_gass_transfer_listener_t	listener;
    char *				subject=GLOBUS_NULL;
    unsigned short			port = 0;
    globus_gass_transfer_listenerattr_t lattr;

    while ((c = getopt(argc, argv, "p:tb:f:sa:l")) != EOF)
    {
	switch (c)
	{
	  case 't':
	    textmode=GLOBUS_TRUE;
	    break;
	  case 'b':
	    blocksize = atoi(optarg);
	    break;
	  case 'f':
	    failure_bytes = atoi(optarg);
	    break;
	  case 's':
	    secure=GLOBUS_TRUE;
	    break;
	  case 'a':
	    secure=GLOBUS_TRUE;
	    subject = optarg;
	    break;
	  case 'l':
	    send_length = GLOBUS_TRUE;
	    break;
	  case 'p':
	    port = (unsigned short) atoi(optarg);
	    break;
	  default:
	    printf("Usage: %s [-t] [-s] [-l] [-a subject] [-b blocksize] [-f fail_after]\n", argv[0]);
	    return 1;
	}
    }
    globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_module_activate(GLOBUS_GASS_TRANSFER_MODULE);

    globus_mutex_init(&mutex,
		      GLOBUS_NULL);
    globus_cond_init(&cond,
		     GLOBUS_NULL);

    if(secure)
    {
	globus_gass_transfer_requestattr_init(&attr,
					      "https");
	globus_gass_transfer_listenerattr_init(&lattr,
					       "https");
    }
    else
    {
	globus_gass_transfer_requestattr_init(&attr,
					      "http");
	globus_gass_transfer_listenerattr_init(&lattr,
					       "http");
    }
    
    if(textmode)
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_TEXT);
    }
    else
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_BINARY);
    }

    if(blocksize)
    {
	globus_gass_transfer_requestattr_set_block_size(
	    &attr,
	    1024*1024);
    }
    if(subject)
    {
	globus_gass_transfer_secure_requestattr_set_authorization(
	    &attr,
	    GLOBUS_GASS_TRANSFER_AUTHORIZE_SUBJECT,
	    subject);
    }

    if(port)
    {
	globus_gass_transfer_listenerattr_set_port(&lattr,
						   port);
    }
    if(secure)
    {
	globus_gass_transfer_create_listener(
	    &listener,
	    &lattr,
	    "https");
    }
    else
    {
	globus_gass_transfer_create_listener(
	    &listener,
	    &lattr,
	    "http");
    }
    base_url = globus_gass_transfer_listener_get_base_url(listener);

    globus_gass_transfer_register_listen(listener,
					 listen_callback,
					 &attr);
    printf("Listening on %s\n",
	   base_url);

    globus_mutex_lock(&mutex);
    while(!done)
    {
	globus_cond_wait(&cond, &mutex);
    }
    globus_mutex_unlock(&mutex);

    globus_gass_transfer_requestattr_destroy(&attr);


  finish:
    globus_module_deactivate(GLOBUS_GASS_TRANSFER_MODULE);
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
}

