#include "globus_gass_transfer.h"
#include <stdlib.h>

globus_bool_t done = GLOBUS_FALSE;
globus_mutex_t mutex;
globus_cond_t cond;

#define TEST_STREAM		"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \
				"1..2..3..4..5..6..7..8..9..10\n" \

int buflen			= 999;
int read_bytes			= 0;
int failure_bytes		= 10000000;
int test_iterations		= 1;

void
fail_callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    printf("Request %d failed\n",
	   (int)request);
    globus_mutex_lock(&mutex);
    globus_gass_transfer_request_destroy(request);
    done=1;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);
}
void
bytes_callback(
    void *arg,
    globus_gass_transfer_request_t request,
    globus_byte_t *	bytes,
    globus_size_t	len,
    globus_bool_t	last_data)
{
    int i;

    globus_mutex_lock(&mutex);
    /*   printf("Sent data\n"); */
    read_bytes += len;

    fflush(stdout);
    if(last_data)
    {
	globus_gass_transfer_request_status_t status;
	done=GLOBUS_TRUE;
	status = globus_gass_transfer_request_get_status(request);
	if(status != GLOBUS_GASS_TRANSFER_REQUEST_DONE)
	{
	    printf("request failed!?!\n");
	}
	else
	{
	    printf("request succeeded\n");
	}
	globus_gass_transfer_request_destroy(request);
	done=1;
	globus_cond_signal(&cond);
    }
    else if(read_bytes >= failure_bytes)
    {
	done=GLOBUS_TRUE;
	globus_gass_transfer_fail(request,
				  fail_callback,
				  GLOBUS_NULL);
    }
    else
    {
	globus_gass_transfer_send_bytes(
	    request,
            (globus_byte_t *) TEST_STREAM,
	    strlen(TEST_STREAM),
	    --test_iterations > 0 ? GLOBUS_FALSE
	                          : GLOBUS_TRUE,
	    bytes_callback,
	    GLOBUS_NULL);
    }
    globus_mutex_unlock(&mutex);
}

void
callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    globus_gass_transfer_request_status_t status;
    globus_gass_transfer_requestattr_t *  attr;
    char *msg;

    attr = (globus_gass_transfer_requestattr_t *) arg;

    status = globus_gass_transfer_request_get_status(request);

    switch(status)
    {
      case GLOBUS_GASS_TRANSFER_REQUEST_REFERRED:
	{
	    globus_gass_transfer_referral_t		referral;
	    int rc;

	    globus_gass_transfer_request_get_referral(request,
						      &referral);
	    globus_gass_transfer_request_destroy(request);

	    printf("Referral to %s\n",
		   globus_gass_transfer_referral_get_url(&referral,
							 0));
	    rc = globus_gass_transfer_register_get(
		&request,
		attr,
		globus_gass_transfer_referral_get_url(&referral,
						      0),
		callback,
		attr);
	    globus_gass_transfer_referral_destroy(&referral);
	    if(rc != GLOBUS_SUCCESS)
	    {
		printf("get of referred entity failed\n");
		goto wakeup_main;
	    }
	    break;
	}
      case GLOBUS_GASS_TRANSFER_REQUEST_PENDING:
	printf("pending\n");
	globus_gass_transfer_send_bytes(
	    request,
            (globus_byte_t *) TEST_STREAM,
	    strlen(TEST_STREAM),
	    --test_iterations > 0 ? GLOBUS_FALSE
	                          : GLOBUS_TRUE,
	    bytes_callback,
	    GLOBUS_NULL);
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_DONE:
	printf("done\n");
	goto wakeup_main;
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_DENIED:
	msg = globus_gass_transfer_request_get_denial_message(request);
	printf("denied: %d %s\n",
	       globus_gass_transfer_request_get_denial_reason(request),
	       msg);
	globus_libc_free(msg);
	goto wakeup_main;
      case GLOBUS_GASS_TRANSFER_REQUEST_FAILED:
	printf("failed\n");
	goto wakeup_main;
    }
    return;
  wakeup_main:
    globus_gass_transfer_request_destroy(request);
    globus_mutex_lock(&mutex);
    done = 1;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);

    return;
}

int main(int argc, char **argv)
{
    globus_gass_transfer_request_t 	request;
    globus_gass_transfer_requestattr_t  attr;
    char *				url;
    int					c;
    globus_bool_t			textmode = GLOBUS_FALSE;
    globus_size_t			blocksize = 0;
    extern int				optind;
    extern char *			optarg;
    globus_bool_t			send_length = GLOBUS_TRUE;
    char *				output_file = GLOBUS_NULL;
    globus_url_t			tmp_url;
    int					rc;

    globus_module_activate(GLOBUS_COMMON_MODULE);

    while ((c = getopt(argc, argv, "tb:f:i:o:l")) != EOF)
    {
	switch (c)
	{
	  case 't':
	    textmode=GLOBUS_TRUE;
	    break;
	  case 'b':
	    blocksize = atoi(optarg);
	    break;
	  case 'f':
	    failure_bytes = atoi(optarg);
	    break;
	  case 'l':
	    send_length = GLOBUS_TRUE;
	    break;
	  case 'o':
	    output_file=optarg;
	    break;
	  case 'i':
	    test_iterations = atoi(optarg);
	    break;
	  default:
	    printf("Usage: %s\n"
		   "    [-t]\n"
		   "    [-b blocksize]\n"
		   "    [-f fail_after]\n"
		   "    [-o output_url]\n"
		   "    [-l] \n"
		   "    [-i iterations]\n",
		   argv[0]);
	    goto error_exit;
	}
    }

    if(output_file == GLOBUS_NULL)
    {
	url = "http://goshen.mcs.anl.gov:8080/putdir/testfile";
    }
    else
    {
	url = output_file;
    }

    globus_module_activate(GLOBUS_GASS_TRANSFER_MODULE);

    globus_mutex_init(&mutex,
		      GLOBUS_NULL);
    globus_cond_init(&cond,
		     GLOBUS_NULL);

    rc = globus_url_parse(url,
                          &tmp_url);
    if(rc != GLOBUS_SUCCESS)
    {
        goto bad_url;
    }

    globus_gass_transfer_requestattr_init(&attr,
					  tmp_url.scheme);
    globus_url_destroy(&tmp_url);
    
    if(textmode)
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_TEXT);
    }
    else
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_BINARY);
    }

    if(blocksize)
    {
	globus_gass_transfer_requestattr_set_block_size(
	    &attr,
	    1024*1024);
    }

    globus_gass_transfer_register_put(
	&request,
	&attr,
	url,
	send_length ? (strlen(TEST_STREAM) * test_iterations)
	            : GLOBUS_GASS_LENGTH_UNKNOWN,
	callback,
	&attr);

    globus_mutex_lock(&mutex);
    while(!done)
    {
	globus_cond_wait(&cond, &mutex);
    }
    globus_mutex_unlock(&mutex);
    
    globus_gass_transfer_requestattr_destroy(&attr);
  bad_url:
    globus_module_deactivate(GLOBUS_GASS_TRANSFER_MODULE);
  error_exit:
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
}

