#define GLOBUS_GASS_TRANSFER_HTTP_PARSER_TEST 1
#include "globus_gass_transfer_keyvalue.c"
#include "globus_gass_transfer_http.c"
#include <sys/stat.h>
#include <fcntl.h>

/* From www.mcs.anl.gov */
#define string1		"HTTP/1.1 200 OK" CRLF \
			"Server: Microsoft-IIS/4.0" CRLF \
			"Date: Tue, 18 May 1999 15:01:30 GMT" CRLF \
			"Connection: close" CRLF \
			"Content-Type: text/html" CRLF \
			"Set-Cookie: ASPSESSIONIDGGGQQHGJ=" \
			    "MIEHIKKADFIDNPKMLKDALBOE; path=/" CRLF \
			"Cache-control: private" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			CRLF \
			"0" CRLF \
			CRLF

/* Same string, but with a continuation */
#define string2		"HTTP/1.1 200 OK" CRLF \
			"Server: Microsoft-IIS/4.0" CRLF \
			"Date: Tue, 18 May 1999 15:01:30 GMT" CRLF \
			"Connection: close" CRLF \
			"Content-Type: text/html" CRLF \
			"Set-Cookie: ASPSESSIONIDGGGQQHGJ=" \
			    "MIEHIKKADFIDNPKMLKDALBOE;" CRLF \
			" path=/" CRLF \
			"Cache-control: private" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			CRLF \
			"0" CRLF \
			CRLF

/* From slashdot.org */
#define string3		"HTTP/1.1 200 OK" CRLF \
			"Date: Wed, 19 May 1999 00:59:23 GMT" CRLF \
			"Server: Apache/1.3.6 (Unix) mod_perl/1.18" CRLF \
			"Connection: close" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF

/* from www.yahoo.com */
#define string4		"HTTP/1.0 200 OK" CRLF \
			"Content-Length: 9995" CRLF \
			"Expires: Thu, 20 May 1999 14:00:03 GMT" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF
/* from www-isi.globus.org */
#define string5		"HTTP/1.0 200 OK" CRLF \
			"Server: Netscape-Enterprise/2.0a" CRLF \
			"Date: Tue, 18 May 1999 18:16:42 GMT" CRLF \
			"Accept-ranges: bytes" CRLF \
			"Last-modified: Tue, 18 Aug 1998 18:50:34 GMT" CRLF \
			"Content-length: 5945" CRLF \
			"Content-type: text/html" CRLF \
			CRLF

/* from www.microsoft.com */
#define string6		"HTTP/1.0 200 OK" CRLF \
			"Server: Microsoft-IIS/4.0" CRLF \
			"Content-Location: " \
				"http://www.microsoft.com/Default.htm" CRLF \
			"Date: Tue, 18 May 1999 18:18:21 GMT" CRLF \
			"Content-Type: text/html" CRLF \
			"Accept-Ranges: bytes" CRLF \
			"Last-Modified: Mon, 17 May 1999 20:28:44 GMT" CRLF \
			"ETag: \"026c2dba3a0be1:7639a\"" CRLF \
			"Content-Length: 19785" CRLF \
			CRLF
/* from www.netscape.com */
#define string7		"HTTP/1.1 200 OK" CRLF \
			"Server: Netscape-Enterprise/3.6" CRLF \
			"Date: Tue, 18 May 1999 19:00:41 GMT" CRLF \
			"Set-Cookie: UIDC=140.221.9.107:0927054042:184896;domain=.netscape.com;path=/;expires=31-Dec-2010 23:59:59 GMT" CRLF \
			"Set-cookie: NGUserID=cdbcf705-8980-927054042-1; expires=Wednesday, 09-Nov-99 23:12:40 GMT; path=/" CRLF \
			"Content-type: text/html" CRLF \
			"Connection: close" CRLF \
			CRLF
#define string8		"HTTP/1.1 302 Moved Temporarily" CRLF \
			"Date: Tue, 18 May 1999 19:02:37 GMT" CRLF \
			"Server: Apache/1.3b3" CRLF \
			"Location: http://www-fp.mcs.anl.gov/division/" CRLF \
			"Connection: close" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF

/* Not an HTTP response (from ftp.mcs.anl.gov) */
#define string9		"220 charlotte.mcs.anl.gov FTP server (Version wu-2.4.2-academ[BETA-18-VR13](1) Fri Feb 12 08:37:05 CST 1999) ready." CRLF

/* Bogus HTTP response header */
#define string10	"HTTP/1.1 OK" CRLF \
			"Some: header" CRLF \
			CRLF

/* Bogus HTTP response header */
#define string11	"HTTP/1.1 200 OK" CRLF \
			"Some-header-without-a-value" CRLF \
			CRLF

/* Bogus HTTP response header (should fail, but doesn't) */
#define string12	"HTTP/1.1 200 OK" CRLF \
			"A-valid-header: yes" CRLF \
			"Some-header-without-a-value" CRLF \
			" and-an-illegal-continuation: foo" CRLF \
			CRLF
#define string13	"HTTP/1.1 200 OK" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			CRLF \
			"0" CRLF \
			CRLF
/* http://www.mcs.anl.gov/ */
#define string14	"HTTP/1.1 302 Moved Temporarily" CRLF \
			"Date: Fri, 21 May 1999 14:44:32 GMT" CRLF \
			"Server: Apache/1.3b3" CRLF \
			"Location: http://www-fp.mcs.anl.gov/division/" CRLF \
			"Connection: close" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF \
			"bc" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"0" CRLF \
			CRLF
/* Same as previous, but with multiple chunks */
#define string15	"HTTP/1.1 302 Moved Temporarily" CRLF \
			"Date: Fri, 21 May 1999 14:44:32 GMT" CRLF \
			"Server: Apache/1.3b3" CRLF \
			"Location: http://www-fp.mcs.anl.gov/division/" CRLF \
			"Connection: close" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF \
			"bc" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"bc" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"0" CRLF \
			CRLF

/* same as above, but with chunk-ext's defined */
#define string16	"HTTP/1.1 302 Moved Temporarily" CRLF \
			"Date: Fri, 21 May 1999 14:44:32 GMT" CRLF \
			"Server: Apache/1.3b3" CRLF \
			"Location: http://www-fp.mcs.anl.gov/division/" CRLF \
			"Connection: close" CRLF \
			"Transfer-Encoding: chunked" CRLF \
			"Content-Type: text/html" CRLF \
			CRLF \
			"bc;var=\"value-with" CRLF \
			"    continuation\"" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"bc ; var = value; var2 = value2" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"bc; var; var2=value" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"bc; var; var2" CRLF \
			"<HTML><HEAD>" LF_STRING \
			"<TITLE>302 Moved Temporarily</TITLE>" LF_STRING \
			"</HEAD><BODY>" LF_STRING \
			"<H1>Moved Temporarily</H1>" LF_STRING \
			"The document has moved <A HREF=\"http://www-fp.mcs.anl.gov/division/\">here</A>.<P>" LF_STRING \
			"</BODY></HTML>" LF_STRING \
			"" CRLF \
			"0" CRLF \
			CRLF
void
run_test(char *string);

int main(int argc,
	 char * argv[])
{
    int i;
    char *test_strings[] =  { string1,
			      string2,
			      string3,
			      string4,
			      string5,
			      string6,
			      string7,
			      string8,
			      string9,
			      string10,
			      string11,
			      string12,
			      string13,
			      string14,
			      string15,
			      string16,
			      NULL };
    if(argc > 1)
    {
	if(isdigit(argv[1][0]))
	{
	    size_t  target;

	    target = (size_t) atoi(argv[1]);

	    if(target < 1 ||
	       target > (sizeof(test_strings) / sizeof(char *) - 1))
	    {
		printf("Illegal test number %ld [valid tests 1-%d]\n",
		       (long) target,

		       (int) (sizeof(test_strings) / sizeof(char *) - 1));
		exit(1);
	    }
	    run_test(test_strings[target - 1]);
	}
	else
	{
	    size_t			read_amt;
	    ssize_t			this_read;
	    struct stat			s;
	    char *			string;
	    int				fd;
	    int				rc;

	    rc = stat(argv[1], &s);
	    if(rc != 0)
	    {
		printf("Cannot access file %s\n", argv[1]);
	    }

	    string = globus_malloc(s.st_size+1);
	    fd = open(argv[1], O_RDONLY);

	    read_amt = 0;
	    while(read_amt < s.st_size)
	    {
		this_read = read(fd,
		     string + read_amt,
		     s.st_size - read_amt);
		if(this_read < 0)
		{
		    printf("Error reading file %s\n", argv[1]);
		    exit(1);
		}
		else
		{
		    read_amt += this_read;
		}
	    }
	    string[s.st_size] = '\0';
	    run_test(string);
	}
    }
    else
    {
	for(i = 0; test_strings[i] != NULL; i++)
	{
	    printf("Running test %d\n",
		   i + 1);
	    run_test(test_strings[i]);
	}
    }

    return 0;
}

void
run_test(char *string)
{
    globus_gass_transfer_http_request_proto_t *	proto;
    int	i;
    globus_byte_t *response;
    int len;

    response = (globus_byte_t *) strdup(string);
    len = strlen((char *) response);

    proto = globus_malloc(sizeof(globus_gass_transfer_http_request_proto_t));
    proto->response_buffer = response;
    proto->response_buflen = strlen((char *) response);
    proto->response_offset = 0;
    proto->parsed_offset = 0;
    proto->code = 0;
    proto->reason = 0;
    proto->headers = GLOBUS_NULL;
    proto->parse_error = 0;
    proto->user_buffer = globus_malloc(1024);
    proto->recv_state = GLOBUS_GASS_TRANSFER_HTTP_RECV_STATE_CHUNK_SIZE;
    proto->user_buflen = 1024;
    proto->user_waitlen = 1;
    proto->user_offset = 0;

    /* Parse header information */
    for(i = 0; i <= len; i++)
    {
	proto->response_offset = i;

	if(!globus_l_gass_transfer_http_parse_response(proto))
	{
	    break;
	}

	if(proto->parse_error)
        {
	    break;
	}
    }
    if(proto->reason != GLOBUS_NULL)
    {
	printf("Response was %d: %s\n", proto->code, proto->reason);
    }
    if(proto->parse_error != GLOBUS_NULL)
    {
	printf("Parse error occurred at %c\n", (char) proto->response_buffer[i]);
    }
    proto->response_offset = len;
    {
	globus_list_t *		tmp;
	tmp = proto->headers;
	while(!globus_list_empty(tmp))
	{
	    globus_gass_transfer_keyvalue_t *t;
	    t = globus_list_first(tmp);

	    printf("Header (%s ==> %s)\n",
		   t->key,
		   t->value);
	    tmp = globus_list_rest(tmp);
	}
    }
    
    if(globus_i_gass_transfer_keyvalue_lookup(&proto->headers,
					     "transfer-encoding"))
    {
	globus_size_t				j;

	printf("Printing chunked data\n");
	proto->chunk_left = 0;
	proto->text_mode = GLOBUS_TRUE;
	proto->chunked = GLOBUS_TRUE;
	proto->line_mode = GLOBUS_L_LINE_MODE_UNKNOWN;
	proto->handled = 0;

	while(!globus_l_gass_transfer_http_handle_chunk(proto))
	{
	    if(proto->recv_state == GLOBUS_GASS_TRANSFER_HTTP_RECV_STATE_ERROR
	       || proto->recv_state == GLOBUS_GASS_TRANSFER_HTTP_RECV_STATE_EOF
	       || proto->parse_error)
	    {
		break;
	    }
	    for(j=0; j < proto->user_offset; j++)
	    {
		printf("%c", proto->user_buffer[j]);
	    }
	    fflush(stdout);
	    proto->user_offset = 0;
	}
    }
    globus_free(proto->response_buffer);
    globus_free(proto->user_buffer);
    globus_i_gass_transfer_keyvalue_destroy(&proto->headers);
    globus_free(proto->reason);
    globus_free(proto);
}
