#include "globus_gass_transfer.h"
#include <stdlib.h>

globus_bool_t done = GLOBUS_FALSE;
globus_mutex_t mutex;
globus_cond_t cond;

int buflen=999;
int read_bytes=0;
int failure_bytes=10000000;
char * subject = GLOBUS_NULL;
FILE *fpOUT;
globus_bool_t write_to_file = GLOBUS_FALSE;

void
fail_callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    printf("Request %d failed\n",
	   (int)request);
    globus_mutex_lock(&mutex);
    globus_gass_transfer_request_destroy(request);
    done=1;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);
}

void
bytes_callback(
    void *arg,
    globus_gass_transfer_request_t request,
    globus_byte_t *	bytes,
    globus_size_t	len,
    globus_bool_t	last_data)
{
    int i;

    globus_mutex_lock(&mutex);
    for(i = 0; i < len; i++)
    {
	if(write_to_file)
	    fprintf(fpOUT, "%c", bytes[i]);
	else    
	    printf("%c", bytes[i]);
    }
    read_bytes += len;

    fflush(stdout);
    if(last_data)
    {
	globus_gass_transfer_request_status_t status;
	if(write_to_file)
	    fclose(fpOUT);
	done=GLOBUS_TRUE;
	status = globus_gass_transfer_request_get_status(request);
	if(status != GLOBUS_GASS_TRANSFER_REQUEST_DONE)
	{
	    printf("request failed!?!\n");
	    if(status == GLOBUS_GASS_TRANSFER_REQUEST_FAILED)
		printf("status: GLOBUS_GASS_TRANSFER_REQUEST_FAILED\n");
	    /*	       globus_gass_transfer_request_get_denial_reason(request),
		       globus_gass_transfer_request_get_denial_message(request));
		       */
	}
	else
	{
	    printf("request succeeded\n");
	}
	globus_free(bytes);
	globus_gass_transfer_request_destroy(request);
	globus_cond_signal(&cond);
    }
    else if(read_bytes >= failure_bytes)
    {
	done=GLOBUS_TRUE;
	globus_free(bytes);
	globus_gass_transfer_fail(request,
				  fail_callback,
				  GLOBUS_NULL);
    }
    else
    {
	globus_gass_transfer_receive_bytes(
	    request,
	    bytes,
	    buflen,
	    1,
	    bytes_callback,
	    GLOBUS_NULL);
    }
    globus_mutex_unlock(&mutex);
}

void
callback(
    void *arg,
    globus_gass_transfer_request_t request)
{
    globus_gass_transfer_request_status_t status;
    globus_gass_transfer_requestattr_t *  attr;

    attr = (globus_gass_transfer_requestattr_t *) arg;

    status = globus_gass_transfer_request_get_status(request);

    switch(status)
    {
      case GLOBUS_GASS_TRANSFER_REQUEST_REFERRED:
	{
	    globus_gass_transfer_referral_t		referral;
	    int rc;

	    globus_gass_transfer_request_get_referral(request,
						      &referral);
	    globus_gass_transfer_request_destroy(request);

	    printf("Referral to %s\n",
		   globus_gass_transfer_referral_get_url(&referral,
							 0));
	    rc = globus_gass_transfer_register_get(
		&request,
		attr,
		globus_gass_transfer_referral_get_url(&referral,
						      0),
		callback,
		attr);
	    globus_gass_transfer_referral_destroy(&referral);
	    if(rc != GLOBUS_SUCCESS)
	    {
		printf("get of referred entity failed\n");
		goto wakeup_main;
	    }
	    break;
	}
      case GLOBUS_GASS_TRANSFER_REQUEST_PENDING:
      {
	int rc;
	  
	printf("pending\n");
	rc = globus_gass_transfer_receive_bytes(
	    request,
	    globus_malloc(buflen),
	    buflen,
	    1,
	    bytes_callback,
	    GLOBUS_NULL);
	if(rc != GLOBUS_SUCCESS)
	    printf("globus_gass_transfer_receive_bytes: returned error code %d\n", rc);
	break;
      }
      case GLOBUS_GASS_TRANSFER_REQUEST_DONE:
	printf("done\n");
	goto wakeup_main;
	break;
      case GLOBUS_GASS_TRANSFER_REQUEST_DENIED:
	printf("denied: %d %s\n",
	       globus_gass_transfer_request_get_denial_reason(request),
	       globus_gass_transfer_request_get_denial_message(request));
	goto wakeup_main;
      case GLOBUS_GASS_TRANSFER_REQUEST_FAILED:
	printf("failed\n");
	goto wakeup_main;
    }
    return;
  wakeup_main:
    globus_gass_transfer_request_destroy(request);
    globus_mutex_lock(&mutex);
    done = 1;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);

    return;
}

int main(int argc, char **argv)
{
    globus_gass_transfer_request_t 	request;
    globus_gass_transfer_requestattr_t  attr;
    char *				url;
    int					c;
    globus_bool_t			textmode = GLOBUS_FALSE;
    globus_size_t			blocksize = 0;
    extern int				optind;
    extern char *			optarg;
    globus_url_t			purl;
    int					rc;

    while ((c = getopt(argc, argv, "tb:f:s:w:")) != EOF)
    {
	switch (c)
	{
	  case 'w':
	    write_to_file = GLOBUS_TRUE;
	    /*  fpOUT = fopen("tmp.out", "w");  */
	    fpOUT = fopen(optarg, "w");
	    if (fpOUT == NULL)
	    {
	      globus_libc_fprintf(stderr, "ERROR: could not open output file: %s\n", optarg);
	      exit(1);
	    }
	    break;
	  case 't':
	    textmode=GLOBUS_TRUE;
	    break;
	  case 'b':
	    blocksize = atoi(optarg);
	    break;
	  case 'f':
	    failure_bytes = atoi(optarg);
	    break;
	  case 's':
	    subject = optarg;
	    break;
	  default:
	    printf("Usage: %s [-t] [-b blocksize] [-f fail_after] [-s subject] [-w write_to_local_filename] [URL]\n", argv[0]);
	    return 1;
	}
    }
    if(optind < argc)
    {
	url = argv[optind];
    }
    else
    {
	url = "http://www.globus.org/gass";
    }

    globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_module_activate(GLOBUS_GASS_TRANSFER_MODULE);

    rc = globus_url_parse(url,
			  &purl);
    if(rc != GLOBUS_SUCCESS)
    {
	goto finish;
    }
    globus_mutex_init(&mutex,
		      GLOBUS_NULL);
    globus_cond_init(&cond,
		     GLOBUS_NULL);

    globus_gass_transfer_requestattr_init(&attr,
					  purl.scheme);
    
    if(strcmp(purl.scheme, "https") == 0)
    {
	if(subject)
	{
	    globus_gass_transfer_secure_requestattr_set_authorization(
		&attr,
		GLOBUS_GASS_TRANSFER_AUTHORIZE_SUBJECT,
		subject);
	}
    }
    globus_url_destroy(&purl);

    if(textmode)
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_TEXT);
    }
    else
    {
	globus_gass_transfer_requestattr_set_file_mode(
	    &attr,
	    GLOBUS_GASS_TRANSFER_FILE_MODE_BINARY);
    }

    if(blocksize)
    {
	globus_gass_transfer_requestattr_set_block_size(
	    &attr,
	    1024*1024);
    }

    globus_gass_transfer_register_get(
	&request,
	&attr,
	url,
	callback,
	&attr);

    globus_mutex_lock(&mutex);
    while(!done)
    {
	globus_cond_wait(&cond, &mutex);
    }
    globus_mutex_unlock(&mutex);

    globus_gass_transfer_requestattr_destroy(&attr);

    globus_poll_nonblocking();

  finish:
    
    globus_module_deactivate(GLOBUS_GASS_TRANSFER_MODULE);
    
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
}

