#include "globus_gass_file.h"

static int verboseflag = 0;

int 
main(int argc,
     char **argv)
{
    FILE *fp;
    int i;
    int rv;
    
    if((rv = globus_module_activate(GLOBUS_GASS_FILE_MODULE)))
    {
	fprintf(stderr, "Couldn't activate GLOBUS_GASS_FILE_MODULE");
	exit(1);
    }
    if (argv[1] && strcmp(argv[1], "-v") == 0)
    {
	++verboseflag;
	++argv,--argc;
    }
    if (argc != 2) 
    {
	fprintf(stderr, "%s: Usage: %s [-v] gass-file-name-to-append-to", 
		argv[0], argv[0]);
	exit(1);
    }
	
    fp = globus_gass_fopen(argv[1], "a");
    if (!fp) {
	fprintf(stderr, "%s: globus_gass_fopen(%s) failed.\n", 
		argv[0], argv[1]);
	exit(1);
    } else {
	if (verboseflag)
	    fprintf(stderr, "%s: Successfully opened %s\n", argv[0], argv[1]);
    }
    for(i = 0; i < 100; i++)
    {
         fprintf(fp,
		 "testing...1...2...3\n");
/*	 sleep(1);*/
	 if(i % 30 == 0)
	 {
	     fflush(fp);
	     globus_poll();
	 }
    }
    if((rv = globus_gass_fclose(fp)))
    {
	fprintf(stderr, "globus_gass_fclose() failed!\n");
	exit(1);
    }
    if((rv = globus_module_deactivate(GLOBUS_GASS_FILE_MODULE)))
    {
	fprintf(stderr, 
		"globus_module_deactivate(GLOBUS_GASS_FILE_MODULE) failed!\n");
	exit(1);
    }
    exit(0);
}
