#include "globus_gass_copy.h"
#include "printf_plugin.h"
#include <stdlib.h>

globus_bool_t done = GLOBUS_FALSE;
globus_mutex_t mutex;
globus_cond_t cond;

char *				source_url;
char *				dest_url;

typedef struct
{
    globus_mutex_t                      mutex;
    globus_cond_t                       cond;
    volatile globus_bool_t              done;
    int                                 count;
    volatile globus_bool_t              use_err;
} my_monitor_t;

my_monitor_t global_monitor;

static
void
my_monitor_callback(
    void * callback_arg,
    globus_gass_copy_handle_t * handle,
    globus_object_t * err)
{
    my_monitor_t       *monitor;
    monitor = (my_monitor_t*)callback_arg;

    globus_mutex_lock(&monitor->mutex);
    if(err!= GLOBUS_SUCCESS)
    {
	monitor->use_err = GLOBUS_TRUE;
	globus_libc_fprintf(stderr, "TEST: monitor_callback: ERROR: %s\n", globus_object_printable_to_string(err)); 
    }
    else
	globus_libc_fprintf(stderr, "TEST: monitor_callback: transfer successful\n");
    
    monitor->done = GLOBUS_TRUE;
    monitor->count++;
    globus_cond_signal(&monitor->cond);
    globus_mutex_unlock(&monitor->mutex);

    return;
} /* my_monitor_callback() */

static
void
test_monitor_callback(
    void * callback_arg,
    globus_gass_copy_handle_t * handle,
    globus_object_t * err)
{
    my_monitor_t       *monitor;
    monitor = (my_monitor_t*)callback_arg;

    globus_mutex_lock(&monitor->mutex);
    if(err!= GLOBUS_SUCCESS)
    {
	monitor->use_err = GLOBUS_TRUE;
	globus_libc_fprintf(stderr, "TEST: monitor_callback: ERROR: %s\n", globus_object_printable_to_string(err)); 
    }
    
    monitor->done = GLOBUS_TRUE;
    monitor->count++;
    globus_libc_fprintf(stderr, "TEST: monitor_callback: monitor->count: %d\n", monitor->count); 
    globus_gass_copy_handle_destroy(handle);
    
    globus_cond_signal(&monitor->cond);
    globus_mutex_unlock(&monitor->mutex);

    return;
} /* my_monitor_callback() */

void * copy_thread_function(void * arg){
    char l_src_url[512];
    char l_dst_url[512];
    globus_result_t                     l_result;
    my_monitor_t                        l_monitor;
    globus_gass_copy_handle_t           l_handle;
    int* num = (int*)arg;

    globus_mutex_init(&l_monitor.mutex, GLOBUS_NULL);
    globus_cond_init(&l_monitor.cond, GLOBUS_NULL);
    l_monitor.done = GLOBUS_FALSE;
    l_monitor.use_err = GLOBUS_FALSE;
    l_monitor.count = 0;
    
    globus_gass_copy_handle_init(&l_handle, GLOBUS_NULL);
    
    sprintf(l_src_url, "%s.%d", source_url, num);
    sprintf(l_dst_url, "%s.%d", dest_url, num);    
    l_result = globus_gass_copy_register_url_to_url(
		&l_handle,
		/*GLOBUS_NULL,*/
		l_src_url,
		GLOBUS_NULL,
		l_dst_url,
		GLOBUS_NULL,
		my_monitor_callback,
		(void *) &l_monitor);

    if(l_result != GLOBUS_SUCCESS)
    {
	globus_libc_fprintf(stderr, "TEST: test FAILED: globus_gass_copy_register_url_to_url() returned !!!GLOBUS_SUCCESS for num: %d\n", num);
	l_monitor.done = GLOBUS_TRUE;
	l_monitor.use_err = GLOBUS_TRUE;
	exit (1);
    }
    
    globus_mutex_lock(&l_monitor.mutex);
    
    while(! l_monitor.done)
    {
	globus_cond_wait(&l_monitor.cond, &l_monitor.mutex);
    } 
    globus_mutex_unlock(&l_monitor.mutex);

    globus_mutex_destroy(&l_monitor.mutex);
    globus_cond_destroy(&l_monitor.cond);

    globus_gass_copy_handle_destroy(&l_handle);

    globus_mutex_lock(&global_monitor.mutex);
    global_monitor.count++;
    globus_libc_fprintf(stderr, "TEST: thread %d, global_monitor.count: %d\n", num, global_monitor.count);
    globus_cond_signal(&global_monitor.cond);
    globus_mutex_unlock(&global_monitor.mutex);

    return;
    
}



int main(int argc, char **argv)
{
    /*   
    globus_gass_transfer_requestattr_t  source_attr;
    globus_gass_transfer_requestattr_t  dest_attr;
    */
    /*
    char *				source_url;
    char *				dest_url;
    */
    char                                source_multi_url[512];
    char                                dest_multi_url[512];
    int                                 loop;
    int                                 outer_loop;
    int					c;
    int                                 rc;
    globus_bool_t			blocking = GLOBUS_FALSE;
    extern int				optind;
    extern char *			optarg;
    globus_url_t			p_s_url;
    globus_url_t			p_d_url;
    int                                 mode=0;
    int                                 multi = 1;
    globus_io_handle_t *                source_handle;
    globus_io_handle_t *                dest_handle;
    globus_gass_copy_handle_t           handle;
    globus_gass_copy_handle_t           multi_handle[50];
    globus_thread_t                     copy_thread[50];
    globus_result_t                     result;
    globus_gass_copy_handleattr_t	handle_attr;
    globus_ftp_client_handleattr_t	ftp_handleattr;
    globus_ftp_client_plugin_t *	plugin;
    globus_bool_t                       use_plugin = GLOBUS_FALSE;
    my_monitor_t        monitor;
    /* int                 timer=0; */
    int bufLen = 0;
   
    if(argc <3)
    {
      globus_libc_fprintf(stderr, "Usage: %s [-b (buffer length)] [-s] [-d] [srcURL] [destURL]\n", argv[0]);
      return 1;
    }
    
    globus_mutex_init(&monitor.mutex, GLOBUS_NULL);
    globus_cond_init(&monitor.cond, GLOBUS_NULL);
    monitor.done = GLOBUS_FALSE;
    monitor.use_err = GLOBUS_FALSE;
    monitor.count = 0;
    
    while ((c = getopt(argc, argv, "b:sdcm:p:t:l")) != EOF)
    {
	switch (c)
	{
	case 'l':
	    use_plugin = GLOBUS_TRUE;
	    break;
	case 'b':
	    bufLen = atoi(optarg);
	    break;
	case 's':  /* source is a handle */
	    mode=1;
	    break;
	case 'd':  /* dest is a handle */
	    mode=2;
	    break;
	case 'm':  /* do multiple, consecutive transfers using the same handle */
	    mode=3;
	    multi = atoi(optarg);
	    break;
	case 'p':  /* (parallel transfers)do single, simulatneous transfers using the multiple handles*/
	    mode=4;
	    multi = atoi(optarg);
	    
	    if(multi>50)
	    {
		multi = 50;
		globus_libc_fprintf(stderr, "the limit on multiple simulatneous transfers is set to 50\n");
	    }
	    break;
	    
	case 't': /* create separate thread for each transfer */
	    mode=5;
	    multi = atoi(optarg);
	    
	    if(multi>50)
	    {
		multi = 50;
		globus_libc_fprintf(stderr, "the limit on multiple simulatneous transfers is set to 50\n");
	    }
	          
	    break;
	default:
	    globus_libc_fprintf(stderr, "Usage: %s [-b (blocking)] [-s] [-d] [srcURL] [destURL]\n", argv[0]);
	    return 1;
	}
    }
 
    globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_module_activate(GLOBUS_GASS_COPY_MODULE);
 
    source_url = argv[optind];
    dest_url = argv[optind+1];

    switch(mode)
    {
    case 0: /* url_to_url */
	globus_ftp_client_handleattr_init(&ftp_handleattr);
	
	if(use_plugin)
	{
	    
	    globus_module_activate(GLOBUS_FTP_CLIENT_PRINTF_PLUGIN_MODULE);
	    plugin = globus_libc_malloc(sizeof(globus_ftp_client_plugin_t));
	    globus_ftp_client_printf_plugin_init(plugin);
	    
	    globus_ftp_client_handleattr_add_plugin(&ftp_handleattr, plugin);

	}
	globus_gass_copy_handleattr_set_ftp_attr(&handle_attr,
						 &ftp_handleattr);
	globus_gass_copy_handle_init(&handle, &handle_attr);
	
	if(bufLen)
	    globus_gass_copy_set_buffer_length(&handle, bufLen);
	if(blocking)
	{
	  globus_gass_copy_url_to_url(
	      &handle,
	      source_url,
	      GLOBUS_NULL,
	      dest_url,
	      GLOBUS_NULL);
	}
	else
	{
	  result = globus_gass_copy_register_url_to_url(
	      &handle,
	      /*GLOBUS_NULL,*/
	      source_url,
	      GLOBUS_NULL,
	      dest_url,
	      GLOBUS_NULL,
	      my_monitor_callback,
	      (void *) &monitor);

	  if(result != GLOBUS_SUCCESS)
	  {
	      globus_libc_fprintf(stderr, "TEST: test FAILED: globus_gass_copy_register_url_to_url() returned !!!GLOBUS_SUCCESS\n");
	      monitor.done = GLOBUS_TRUE;
	      monitor.use_err = GLOBUS_TRUE;
	  }
	  globus_mutex_lock(&monitor.mutex);
   
	  while(!monitor.done)
	  {
	    globus_cond_wait(&monitor.cond, &monitor.mutex);
	  }
	  
	  globus_mutex_unlock(&monitor.mutex);
	} /* else (!blocking) */

	if(!monitor.use_err)
	    globus_libc_fprintf(stderr, "TEST: supposedly i just copied: \n\t%s to\n\t%s\n", source_url, dest_url);
	else
	    globus_libc_fprintf(stderr, "TEST: bummer! an error occurred trying to copy: \n\t%s to\n\t%s\n", source_url, dest_url);

	globus_gass_copy_handle_destroy(&handle);
	break;

    case 1: /* handle_to_url */
        globus_gass_copy_handle_init(&handle, GLOBUS_NULL);
	rc = globus_url_parse(source_url, &p_s_url);
	if(rc!= GLOBUS_SUCCESS)
	{
	    globus_libc_fprintf(stderr, "TEST: globus_url_parse returned !GLOBUS_SUCCESS for \n\tsource_url: %s\n", source_url);
	    exit(1);
	}
	else
	    if(p_s_url.scheme_type != GLOBUS_URL_SCHEME_FILE)
	    {
		globus_libc_fprintf(stderr, "TEST: the source_url: %s \n\tneeds to be of type GLOBUS_URL_SCHEME_FILE\n ", source_url);
		exit(1);
	    }
	
        source_handle =(globus_io_handle_t *)
            globus_libc_malloc(sizeof(globus_io_handle_t));

        result = globus_io_file_open(
                 p_s_url.url_path,
                 GLOBUS_IO_FILE_RDONLY,
                 GLOBUS_IO_FILE_IRUSR,
                 GLOBUS_NULL,
                 source_handle);
	if(result==GLOBUS_SUCCESS)
	  globus_libc_fprintf(stderr, "TEST: SUCCESS opening %s\n",p_s_url.url_path);
	else
	{
	    globus_libc_fprintf(stderr, "TEST: ERROR opening %s\n",p_s_url.url_path);
	    exit(1);
	}
	
	if(blocking)
	{
	  globus_gass_copy_handle_to_url(
	      &handle,
	      source_handle,
	      dest_url,
	      GLOBUS_NULL);
	}
	else
	{
	  globus_gass_copy_register_handle_to_url(
	      &handle,
	      source_handle,
	      dest_url,
	      GLOBUS_NULL,
	      my_monitor_callback,
	      (void *) &monitor);
	
	  globus_mutex_lock(&monitor.mutex);
	  
	  while(!monitor.done)
	  {
	    globus_cond_wait(&monitor.cond, &monitor.mutex);
	  }
	
	  globus_mutex_unlock(&monitor.mutex);
	}/* else (!blocking) */
	
	
	globus_libc_fprintf(stderr, "TEST: \nsupposedly i just copied :\n\t%s to\n\t%s\nusing handle_to_url\n", source_url, dest_url);

	globus_io_close(source_handle);
	globus_gass_copy_handle_destroy(&handle);
        break;

    case 2:
        globus_gass_copy_handle_init(&handle, GLOBUS_NULL);
	rc = globus_url_parse(dest_url, &p_d_url);

	if(rc!= GLOBUS_SUCCESS)
	{
	    globus_libc_fprintf(stderr, "TEST: globus_url_parse returned !GLOBUS_SUCCESS for \n\tdest_url: %s\n", dest_url);
	    exit(1);
	}
	else
	    if(p_d_url.scheme_type != GLOBUS_URL_SCHEME_FILE)
	    {
		globus_libc_fprintf(stderr, "TEST: the dest_url: %s \n\tneeds to be of type GLOBUS_URL_SCHEME_FILE\n ", dest_url);
		exit(1);
	    }
	
        dest_handle =(globus_io_handle_t *)
            globus_libc_malloc(sizeof(globus_io_handle_t));

        result = globus_io_file_open(
                 p_d_url.url_path,
                 (GLOBUS_IO_FILE_WRONLY|GLOBUS_IO_FILE_CREAT|GLOBUS_IO_FILE_TRUNC),
                 (GLOBUS_IO_FILE_IRWXU|GLOBUS_IO_FILE_IRWXG|GLOBUS_IO_FILE_IRWXO),
                 GLOBUS_NULL,
                 dest_handle);
	
	if(result==GLOBUS_SUCCESS)
	  globus_libc_fprintf(stderr, "TEST: SUCCESS opening %s\n",p_d_url.url_path);
	else
	{
	    globus_libc_fprintf(stderr, "TEST: ERROR opening %s\n",p_d_url.url_path);
	    exit(1);
	}
	
	if(blocking)
	{
	  globus_gass_copy_url_to_handle(
	      &handle,
	      source_url,
	      GLOBUS_NULL,
	      dest_handle);
	}
	else
	{
	  globus_gass_copy_register_url_to_handle(
	      &handle,
	      source_url,
	      GLOBUS_NULL,
	      dest_handle,
	      my_monitor_callback,
	      (void *) &monitor);
	
	  globus_mutex_lock(&monitor.mutex);
   
	  while(!monitor.done)
	  {
	    /*
	    sleep(1);
	    printf("***** globus_gass_copy_get_status(&handle): %d\ttime: %d\n", globus_gass_copy_get_status(&handle), timer++ );*/
	    globus_cond_wait(&monitor.cond, &monitor.mutex);
	  }
	
	  globus_mutex_unlock(&monitor.mutex);
	} /* else (!blocking) */
	
	globus_libc_fprintf(stderr, "TEST: \nsupposedly i just copied :\n\t%s to\n\t%s\nusing globus_gass_copy_url_to_handle\n", source_url, dest_url);

	globus_io_close(dest_handle);
	globus_gass_copy_handle_destroy(&handle);
        break;

    case 3: /* url_to_url, single handle, multiple transfers */

	globus_gass_copy_handle_init(&handle, GLOBUS_NULL);
	if(bufLen)
	    globus_gass_copy_set_buffer_length(&handle, bufLen);

	sprintf(source_multi_url, "%s", source_url);
	sprintf(dest_multi_url, "%s", dest_url);

	for(loop=0; loop<multi; loop++)
	{
	    globus_libc_fprintf(stderr, "\n\n********************************************************\n\n");
	    globus_libc_fprintf(stderr, "TEST: pass %d\n", loop);
	    
	    result = globus_gass_copy_url_to_url(
		&handle,
		source_multi_url,
		GLOBUS_NULL,
		dest_multi_url,
		GLOBUS_NULL);
	    
	    if(result == GLOBUS_SUCCESS)
	    {
		globus_libc_fprintf(stderr, "TEST: copied \t%s to\n\t%s\n", source_multi_url, dest_multi_url);
	    }
	    else
	    {
		globus_libc_fprintf(stderr, "TEST: FAILED to copy \t%s to\n\t%s\n", source_multi_url, dest_multi_url);
		exit(1);
	    }

	} /* for (loop... */

	globus_gass_copy_handle_destroy(&handle);
	
	break;

    case 4: /* url_to_url , single transfers on multiple handles simultanaously*/
	monitor.count = 0;
	
	for(loop=0; loop<multi; loop++)
	    globus_gass_copy_handle_init(&multi_handle[loop], GLOBUS_NULL);
	
	
	for(loop=0; loop<multi; loop++)
	{
	    sprintf(source_multi_url, "%s.%d", source_url, loop);
	    sprintf(dest_multi_url, "%s.%d", dest_url, loop);    
	    result = globus_gass_copy_register_url_to_url(
		&multi_handle[loop],
		/*GLOBUS_NULL,*/
		source_multi_url,
		GLOBUS_NULL,
		dest_multi_url,
		GLOBUS_NULL,
		my_monitor_callback,
		(void *) &monitor);

	    if(result != GLOBUS_SUCCESS)
	    {
		globus_libc_fprintf(stderr, "TEST: test FAILED: globus_gass_copy_register_url_to_url() returned !!!GLOBUS_SUCCESS\n");
		monitor.done = GLOBUS_TRUE;
		monitor.use_err = GLOBUS_TRUE;
		break;
	    }

	}

	globus_mutex_lock(&monitor.mutex);
   	
	  while(monitor.count < multi)
	  {
	    globus_cond_wait(&monitor.cond, &monitor.mutex);
	  }
	  
	  globus_mutex_unlock(&monitor.mutex);
	
	if(!monitor.use_err)
	    globus_libc_fprintf(stderr, "TEST: supposedly i just copied: \n\t%s to\n\t%s\n%d times\n", source_url, dest_url, multi);
	else
	    globus_libc_fprintf(stderr, "TEST: bummer! an error occurred trying to copy: \n\t%s to\n\t%s\n", source_url, dest_url);

	
	for(loop=0; loop<multi; loop++)
	    globus_gass_copy_handle_destroy(&multi_handle[loop]);
	 
	break;

    case 5: /* url_to_url , single transfers on multiple handles simultanaously, each in it's own thread*/

	globus_mutex_init(&global_monitor.mutex, GLOBUS_NULL);
	globus_cond_init(&global_monitor.cond, GLOBUS_NULL);

	for(outer_loop=0; outer_loop<2; outer_loop++)
	{
	    global_monitor.done = GLOBUS_FALSE;
	    global_monitor.use_err = GLOBUS_FALSE;
	    global_monitor.count = 0;
	    globus_libc_fprintf(stderr,"\n*********  TEST pass %d ********\n\n", outer_loop);
	    for(loop=0; loop<multi; loop++)
		globus_thread_create( &copy_thread[loop], NULL, copy_thread_function, (void*)loop );

	    globus_mutex_lock(&global_monitor.mutex);
	
	    while(global_monitor.count < multi)
	    {
		globus_cond_wait(&global_monitor.cond, &global_monitor.mutex);
		globus_libc_fprintf(stderr,"TEST: in main while, pass: %d, global_monitor.count: %d\n", outer_loop, global_monitor.count);
	    }
	    globus_mutex_unlock(&global_monitor.mutex);

	} /* for(outer_loop...) */
	
	globus_mutex_destroy(&global_monitor.mutex);
	globus_cond_destroy(&global_monitor.cond);
	globus_libc_fprintf(stderr,"\n");
      break;
	
    } /* switch */
    
finish:
 
    globus_mutex_destroy(&monitor.mutex);
    globus_cond_destroy(&monitor.cond);
    /*
    globus_libc_fprintf(stderr,"TEST: about to globus_module_deactivate_all() \n");
    globus_module_deactivate_all();
    globus_libc_fprintf(stderr,"TEST: done with globus_module_deactivate_all() \n");
    */
    /*
    rc= globus_module_deactivate(GLOBUS_GASS_COPY_MODULE);
    if(rc!= GLOBUS_SUCCESS)
	globus_libc_fprintf(stderr, "TEST: globus_module_deactivate(GLOBUS_GASS_COPY_MODULE): returned an error!\n");
    */
    globus_libc_fprintf(stderr,"TEST: about to globus_module_deactivate(GLOBUS_GASS_COPY_MODULE) \n");
    globus_module_deactivate(GLOBUS_GASS_COPY_MODULE);
    globus_libc_fprintf(stderr,"TEST: about to globus_module_deactivate(GLOBUS_COMMON_MODULE) \n");
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
    
    if(!monitor.use_err)
	globus_libc_fprintf(stderr, "TEST: we did it, we did it.\n");
}

