/******************************************************************************

gass_cache_test.c

Description:

  Test proglobus_gramm for globus_gass_cache, enabling the test of all globus_gass_cache function
  interactivelly.
  
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/tests/cache/gass_cache_test.c,v $
    $Date: 2000/05/25 18:43:59 $
    $Revision: 1.17 $
    $Author: bester $
******************************************************************************/
#include <stdio.h>
#include <fcntl.h>
#include "globus_common.h"
#include "globus_gass_cache.h"
#include "globus_gass_file.h"

/* global variable */
unsigned long time_stamp;

int
display_result(int rc)
{
    switch (rc)
    {
    case GLOBUS_SUCCESS:
	printf("Success \n");
	break;
    case GLOBUS_GASS_CACHE_ADD_NEW:
	printf("globus_gass_cache return ADD_NEW, timestatmp %ld\n",time_stamp);
	break;
    case GLOBUS_GASS_CACHE_URL_NOT_FOUND:
	printf("globus_gass_cache return URL_NOT_FOUND, timestatmp %ld\n",time_stamp);
	break;
    case GLOBUS_GASS_CACHE_ADD_EXISTS:
	printf("globus_gass_cache return ADD_EXISTS, timestatmp %ld\n",time_stamp);
	break;
	
    default:
	printf("globus_gass_cache return an error: (%d) %s\n",rc,globus_gass_cache_error_string(rc));
	break;
    }
    
    return(rc);
}

void print_list(globus_gass_cache_entry_t *  entry,
	       int                   size)
{

    int i, j;

    if (size == 0)
	printf("\n No entry in cache\n\n");
    
    for (i=0; i< size; i++)
    {

	
	printf("\nURL              : %s\n",(entry+i)->url);
	printf("  Filename       : %s\n",(entry+i)->filename);
	printf("  Timestamp      : %ld\n",(entry+i)->timestamp);
	if ((entry+i)->lock_tag != GLOBUS_NULL)
	    printf("  Locked by: %s\n",(entry+i)->lock_tag);
	else
	    printf("  Not locked\n");
	
	printf("  Number of tags : %d\n",(entry+i)->num_tags);
	for (j=0; j<(entry+i)->num_tags; j++)
	{
	    if (((entry+i)->tags+j)->tag != GLOBUS_NULL)
	    {
		printf("    Tag          : %s\n",((entry+i)->tags+j)->tag);
		printf("    Count        : %d\n\n",((entry+i)->tags+j)->count);
	    }
	}
    }
   
} /* print_list() */

void print_menu()
{
    printf("\no : Open Cache\n");
    printf("c : Close cache\n");
    printf("a : Add a Cache entry\n");
    printf("n : Add Url DONE\n");
    printf("e : Add Url DONE, using previously used url/tag\n");
    printf("d : Delete a Cache entry\n");
    printf("t : Cleanup Tag(url)\n");
    printf("u : Cleanup URL\n");
    printf("l : List Cache\n");
    printf("p : Dump an x-gass-cache URL\n");
    printf("x : Exit\n");
    printf("h : Help: this menu\n");
}

int main(int argc, char **argv)
{
    int rc;
    char         cdir[PATH_MAX];
    globus_gass_cache_t  mycache;
    char *        f_name;
    globus_bool_t   mode;
    globus_gass_cache_entry_t * entries_pt;
    int size;
    char          url[80];
    char          tag[80];
    int           create;
    char          readline[512];
    

    char          rep;

    globus_module_activate(GLOBUS_COMMON_MODULE);
/*    globus_module_activate(GLOBUS_GASS_FILE_MODULE);
 */
    rep = 'h';
    do
    {
	switch(rep)
	{
	case 'o':
	    printf("\n\nOpen Cache...\n");
	    do
	    {
		printf("Use default directory ? (y/n):");
		scanf("%c%*c",&rep);
		printf("%c\n",rep);
	    }
	    while (rep != 'y' && rep != 'n') ;
	    if (rep == 'n')
	    {
		printf("\nCache directory (empty use default):");
		/* this  code can be improved... */
		scanf("%80s%*c",cdir);
		display_result(globus_gass_cache_open(cdir,&mycache));
		
	    }
	    else
		display_result(globus_gass_cache_open((char *)NULL,
					       &mycache));
	    
	    break;
	case 'c':
	    printf("\n\nClose Cache\n");
	    display_result( globus_gass_cache_close(&mycache));
	    break;
	case 'p':
	    printf("\n\nDump an x-gass-cache-url:\n");
	    {
		char x_gass_cache_url[1024];
		char c;
		int fd;
		printf("\nGive the x-gass-cache-url:");
		scanf("%s*c",x_gass_cache_url);
		
		fd = globus_gass_open(x_gass_cache_url,O_RDONLY);
		if (fd <0)
		{
		    printf("\nError opening x_gass_cache_url\n");
		    break;
		}
		while (read(fd, &c, 1) != 0)
		{
		   printf("%c",c);
		}
		globus_gass_close(fd);
	    }
	    break;
	        
	case 'a':
	    /* add an url... */
	    printf("\n\nAdd a Cache entry:\n");
	    printf("\nurl tag create(1/0):");
	    scanf("%s%s%d%*c",url,tag,&create);
	    
	    mode = create;
	    
	    rc = display_result( globus_gass_cache_add(&mycache,
					   url,
					   tag,
					   mode,
					   &time_stamp,
					   &f_name));
	    if (rc==GLOBUS_SUCCESS | rc==GLOBUS_GASS_CACHE_ADD_NEW | rc==GLOBUS_GASS_CACHE_ADD_EXISTS)
	    {
		printf("Timestamp: %d\n",time_stamp);
		if(f_name != GLOBUS_NULL)
		{
		    printf("Filename: \"%s\"",f_name);
		    free(f_name);
		    f_name=GLOBUS_NULL;
		}
	    }
	    break;
	case 'n':
	    printf("\n\nAdd Url DONE:\n");
	    printf("\nurl tag :");
	    scanf("%s%s%*c",url,tag);
	    /* no break in purpose */
	case 'e': /* use previous values */
	    printf("\nUsing url : %s  and Tag : %s\n",url, tag);
	    printf("\nTimestamp please :");
	    scanf("%ld%*c",&time_stamp);
	        
	    display_result( globus_gass_cache_add_done(&mycache,
						url,
						tag,
						time_stamp));
	    break;

	case 'l':
	    printf("\n\nCache Listing:\n");
	    if (display_result(globus_gass_cache_list(&mycache,&entries_pt,&size)) == GLOBUS_SUCCESS)
	    {
		print_list(entries_pt, size) ;
		globus_gass_cache_list_free(entries_pt,size);
	    }
	    break;
	    
        case 'd':
	    printf("\n\nDelete a Cache entry:\n");
	    printf("\nurl tag:");
	    scanf("%s%s%*c",url,tag);
	    printf("\nStart delete...");
	    display_result( globus_gass_cache_delete_start(&mycache,
						    url,
						    tag,
						    &time_stamp));
	    printf("Timestamp: %ld\n",time_stamp);
	    printf("\nFinish delete");
	    printf("\nTimestamp:");
	    scanf("%ld%*c",&time_stamp);
	        
	    display_result( globus_gass_cache_delete(&mycache,
					      url,
					      tag,
					      time_stamp,
					      GLOBUS_TRUE));    
	    break;
	case 'x':
	    printf("exit...\n");
	    goto quit;
	    break;
	case 't':
	    printf("\n\nCleanup Tag(url):\n");
	    printf("\nurl tag:");
	    scanf("%s%s%*c",url,tag);
	    printf("\nStart Cleanup URL %s...",url);
	    display_result( globus_gass_cache_cleanup_tag(&mycache,
						   url,
						   tag));
	    break;
	case 'u':
	    printf("\n\nCleanup URL:\n");
	    printf("\nurl:");
	    scanf("%s%*c",url);
	    printf("\nStart Cleanup URL %s...",url);
	    display_result( globus_gass_cache_cleanup_file(&mycache,
						    url));
	case '#':
	    break;
	     
	case 'h':
	default:
	    print_menu();
	    break;
	} /* switch */
	if (rep != '#')
	{
	    printf("\nGive a command (h for help) : ");
	}
	gets(readline);
	sscanf(readline,"%c",&rep);
	
    }    while (1);
quit:
    globus_module_deactivate(GLOBUS_COMMON_MODULE);

}








