/******************************************************************************
globus_gass_put.c 

Description:

CVS Information:

    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/programs/globus_gass_put/globus_gass_put.c,v $
    $Date: 1998/09/10 15:10:04 $
    $Revision: 1.5 $
    $Author: tedesco $
******************************************************************************/

/******************************************************************************
                             Include header files
******************************************************************************/
#include "globus_common.h"

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>

#include "globus_gass_client.h"

int
main(int argc, char **argv)
{
    int fd=-1;
    int rc=0;

    globus_module_activate(GLOBUS_COMMON_MODULE);
    if(argc == 2)
    {
	if(strncmp(argv[1], "-v", 2) == 0 ||
	   strncmp(argv[1], "--v", 3) == 0)
        {
	    if(GLOBUS_RELEASE_NOT_BETA)
	    {
		globus_libc_printf("Version %d.%d.%d\n"
				   "GASS Protocol Version %d\n",
				   globus_release_major(),
				   globus_release_minor(),
				   globus_release_patch(),
				   GLOBUS_GASS_PROTO_VERSION);
	    }
	    else
	    {
		globus_libc_printf("Version %d.%d.%db%d\n"
				   "GASS Protocol Version %d\n",
				   globus_release_major(),
				   globus_release_minor(),
				   globus_release_patch(),
				   globus_release_beta(),
				   GLOBUS_GASS_PROTO_VERSION);
			      
	    }
	    rc=0;
	    goto end;
        }
    }
    if(argc != 3)
    {
	globus_libc_printf("%s: -v\n"
	                   "%s: fromFile toURL\n"
	                   "%s: - toURL\n",
	                   argv[0],
	                   argv[0],
	                   argv[0]);
        rc=-1;
	goto end;
    }

    if (strcmp(argv[1], "-"))
    {
	fd = globus_libc_open(argv[1], O_RDONLY, 0);
	if(fd < 0)
	{
	    globus_libc_printf("%s: Error opening %s\n",
			       argv[0], argv[1]);
	    rc=-2;
	    goto end;
	}
    }
    else
    {
	fd = 0;
    }

    globus_module_activate(GLOBUS_GASS_CLIENT_MODULE);
    rc = globus_gass_client_put_fd(argv[2], 
				   GLOBUS_NULL,
				   fd,
				   GLOBUS_GASS_LENGTH_UNKNOWN,
				   GLOBUS_GASS_LENGTH_UNKNOWN,
				   GLOBUS_FALSE,
				   GLOBUS_GASS_ACK_NONE,
				   GLOBUS_NULL,
				   GLOBUS_NULL,
				   GLOBUS_NULL);
    if(rc != GLOBUS_SUCCESS)
    {
	globus_libc_printf("%s: Error accessing URL %s\n",
	                   argv[0],
	                   argv[2]);
    }
    globus_module_deactivate(GLOBUS_GASS_CLIENT_MODULE);

end:
    if(fd >= 0)
    {
	globus_libc_close(fd);
    }
    globus_module_deactivate(GLOBUS_COMMON_MODULE);

    return rc;
}
