/******************************************************************************
globus_gass_get.c 

Description:

CVS Information:

    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/programs/globus_gass_get/globus_gass_get.c,v $
    $Date: 1998/09/26 15:44:28 $
    $Revision: 1.7 $
    $Author: bester $
******************************************************************************/

/******************************************************************************
                             Include header files
******************************************************************************/
#include "globus_common.h"

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>

#include "globus_gass_client.h"

/*****************************************************************************
                          Module specific prototypes
*****************************************************************************/
static char *globus_l_gass_get_dest(char *src, char *path);

/******************************************************************************
Function: main()

Description: 

Parameters: 

Returns: 
******************************************************************************/
int
main(int argc, char **argv)
{
    int fd=-1;
    int rc;
    char *dest;

    globus_module_activate(GLOBUS_COMMON_MODULE);
    if(argc == 2)
    {
	if(strncmp(argv[1], "-v", 2) == 0 ||
	   strncmp(argv[1], "--v", 3) == 0)
        {
	    if(GLOBUS_RELEASE_NOT_BETA)
	    {
		globus_libc_printf("Globus Version %d.%d.%d\n"
				   "GASS Protocol Version %d\n",
				   globus_release_major(),
				   globus_release_minor(),
				   globus_release_patch(),
				   GLOBUS_GASS_PROTO_VERSION);
	    }
	    else
	    {
		globus_libc_printf("Globus Version %d.%d.%db%d\n"
				   "GASS Protocol Version %d\n",
				   globus_release_major(),
				   globus_release_minor(),
				   globus_release_patch(),
				   globus_release_beta(),
				   GLOBUS_GASS_PROTO_VERSION);
			      
	    }
	    rc=0;
	    goto end;
        }
    }
    if(argc != 3)
    {
	globus_libc_printf("%s: -v\n"
	                   "%s: fromURL toFile\n"
	                   "%s: fromURL - \n",
	                   argv[0],
	                   argv[0],
	                   argv[0]);
        rc=-1;
	goto end;
    }

    if (strcmp(argv[2], "-"))
    {
	dest = globus_l_gass_get_dest(argv[1],
				      argv[2]);
	
	fd = globus_libc_open(dest,
			      O_WRONLY|O_CREAT|O_TRUNC,
			      S_IRWXU|S_IRWXG|S_IRWXO);
	if(fd < 0)
	{
	    globus_libc_printf("%s: Error opening or creating %s\n",
			       argv[0],
			       argv[2]);
	    rc=-2;
	    goto end;
	}
    }
    else
    {
	fd = 1;
    }

    globus_module_activate(GLOBUS_GASS_CLIENT_MODULE);
    rc = globus_gass_client_get_fd(argv[1], 
				   GLOBUS_NULL,
				   fd,
				   GLOBUS_GASS_LENGTH_UNKNOWN,
				   GLOBUS_NULL,
				   GLOBUS_NULL,
				   GLOBUS_NULL);
    if(rc != GLOBUS_SUCCESS)
    {
	globus_libc_printf("%s: Error accessing URL %s\n",
	                   argv[0],
	                   argv[1]);
    }
    globus_module_deactivate(GLOBUS_GASS_CLIENT_MODULE);

end:
    if(fd >= 0)
    {
	globus_libc_close(fd);
    }
    globus_module_deactivate(GLOBUS_COMMON_MODULE);

    return rc;
} /* main() */

/******************************************************************************
Function: main()

Description: 

Parameters: 

Returns: 
******************************************************************************/
static char *
globus_l_gass_get_dest(char *src, char *path)
{
    struct stat s;
    int rc;
    char *dest;

    rc = stat(path, &s);

    /* doesn't exist */
    if(rc < 0)
    {
	globus_libc_lock();
	dest = strdup(path);
	globus_libc_unlock();
	
	return dest;
    }
    else if(S_ISDIR(s.st_mode))
    {
	size_t i;
	char *basename;
	for(i = strlen(src) - 1; i >= 0U; i--)
	{
	    if(src[i] == '/')
	    {
		break;
	    }
	}
	if(i == 0U &&
	   src[i] != '/')
	{
	    basename = src;
	}
	else
	{
	    basename = src + i + 1;
	}

	dest = globus_malloc(strlen(path) + strlen(basename) + 2);
	globus_libc_sprintf(dest,
			    "%s/%s",
			    path,
			    basename);

	return dest;
    }
    else
    {
	globus_libc_lock();
	dest = strdup(path);
	globus_libc_unlock();

	return dest;
    }
} /* globus_l_gass_get_dest() */
    












