/******************************************************************************
globus_i_gass_transfer_assist.h
 
Description:
    This header defines the GASS transfer assist library internal structures
    and functions.
 
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/libraries/transfer_assist/globus_i_gass_transfer_assist.h,v $
    $Date: 1999/06/30 14:48:42 $
    $Revision: 1.1 $
    $Author: bester $
******************************************************************************/
#ifndef GLOBUS_I_INCLUDE_GASS_TRANSFER_ASSIST_H
#define GLOBUS_I_INCLUDE_GASS_TRANSFER_ASSIST_H

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_gass_transfer_assist.h"

EXTERN_C_BEGIN


typedef struct
{
    globus_bool_t				done;
    globus_mutex_t				mutex;
    globus_cond_t				cond;
} globus_gass_transfer_assist_monitor_t;

typedef struct
{
    globus_gass_transfer_request_t		request;
    globus_io_handle_t				handle;
    globus_byte_t *				buffer;

    globus_bool_t				last_data;
    globus_gass_transfer_callback_t		callback;
    void *					user_arg;
} globus_gass_transfer_assist_callback_info_t;

void
globus_i_gass_transfer_assist_monitor_callback(
    void *				arg,
    globus_gass_transfer_request_t	request);

void
globus_i_gass_transfer_assist_close_callback(
    void *					callback_arg,
    globus_io_handle_t *			handle,
    globus_result_t				result);

void
globus_i_gass_transfer_assist_fail_callback(
    void *					arg,
    globus_gass_transfer_request_t		request);

EXTERN_C_END

#endif /* GLOBUS_I_INCLUDE_GASS_TRANSFER_ASSIST_H */
