/******************************************************************************
globus_gass_transfer_assist_common.c
 
Description:
    This module implements the common get/put functionality of the
    GASS transfer assist library
 
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/libraries/transfer_assist/globus_gass_transfer_assist_common.c,v $
    $Date: 1999/06/30 14:48:40 $
    $Revision: 1.1 $
    $Author: bester $
******************************************************************************/

#include "globus_i_gass_transfer_assist.h"


void
globus_i_gass_transfer_assist_monitor_callback(
    void *				arg,
    globus_gass_transfer_request_t	request)
{
    globus_gass_transfer_assist_monitor_t *monitor;

    monitor = (globus_gass_transfer_assist_monitor_t *)
	arg;

    globus_mutex_lock(&monitor->mutex);
    monitor->done = GLOBUS_TRUE;
    globus_cond_signal(&monitor->cond);
    globus_mutex_unlock(&monitor->mutex);
}

void
globus_i_gass_transfer_assist_close_callback(
    void *					callback_arg,
    globus_io_handle_t *			handle,
    globus_result_t				result)
{
    globus_gass_transfer_assist_callback_info_t *	callback_info;

    callback_info = (globus_gass_transfer_assist_callback_info_t *) callback_arg;

    callback_info->callback(callback_info->user_arg,
			    callback_info->request);

    globus_free(callback_info->buffer);
    globus_free(callback_info);
}

void
globus_i_gass_transfer_assist_fail_callback(
    void *					arg,
    globus_gass_transfer_request_t		request)
{
    globus_gass_transfer_assist_callback_info_t *	callback_info;
    
    callback_info = (globus_gass_transfer_assist_callback_info_t *) arg;

    globus_io_register_close(&callback_info->handle,
			     globus_i_gass_transfer_assist_close_callback,
			     callback_info);
}

