/******************************************************************************
globus_gass_transfer_assist.h
 
Description:
    This header defines the GASS transfer assist library interface
 
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/libraries/transfer_assist/globus_gass_transfer_assist.h,v $
    $Date: 1999/09/17 15:21:48 $
    $Revision: 1.3 $
    $Author: bester $
******************************************************************************/
#ifndef GLOBUS_INCLUDE_GASS_TRANSFER_ASSIST_H
#define GLOBUS_INCLUDE_GASS_TRANSFER_ASSIST_H

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_gass_transfer.h"

EXTERN_C_BEGIN

/* API functions */
#define \
globus_gass_transfer_assist_register_put_file_to_url(\
    request, \
    attr, \
    url, \
    file, \
    file_attr, \
    callback, \
    user_arg) \
    globus_i_gass_transfer_assist_register_file_to_url( \
	request, \
	attr, \
	url, \
	file, \
	file_attr, \
	GLOBUS_L_GASS_TRANSFER_ASSIST_PUT, \
	callback, \
	user_arg)

#define \
globus_gass_transfer_assist_register_append_file_to_url(\
    request, \
    attr, \
    url, \
    file, \
    file_attr, \
    callback, \
    user_arg) \
    globus_i_gass_transfer_assist_register_file_to_url( \
	request, \
	attr, \
	url, \
	file, \
	file_attr, \
	GLOBUS_L_GASS_TRANSFER_ASSIST_APPEND, \
	callback, \
	user_arg)

#define globus_gass_transfer_assist_put_file_to_url( \
    request, \
    attr, \
    url, \
    file, \
    file_attr, \
    follow_referrals) \
    globus_i_gass_transfer_assist_file_to_url( \
	request, \
	attr, \
	url, \
	file, \
	file_attr, \
	follow_referrals, \
	GLOBUS_L_GASS_TRANSFER_ASSIST_PUT);

#define globus_gass_transfer_assist_append_file_to_url( \
    request, \
    attr, \
    url, \
    file, \
    file_attr, \
    follow_referrals) \
    globus_i_gass_transfer_assist_file_to_url( \
	request, \
	attr, \
	url, \
	file, \
	file_attr, \
	follow_referrals, \
	GLOBUS_L_GASS_TRANSFER_ASSIST_APPEND);
typedef enum
{
    GLOBUS_L_GASS_TRANSFER_ASSIST_PUT,
    GLOBUS_L_GASS_TRANSFER_ASSIST_APPEND
} globus_i_gass_transfer_assist_op_t;

int
globus_i_gass_transfer_assist_register_file_to_url(
    globus_gass_transfer_request_t *		request,
    globus_gass_transfer_requestattr_t *	attr,
    char *					url,
    char *					file,
    globus_io_attr_t *				file_attr,
    globus_i_gass_transfer_assist_op_t		op,
    globus_gass_transfer_callback_t		callback,
    void *					user_arg);

int
globus_i_gass_transfer_assist_file_to_url(
    globus_gass_transfer_request_t *		request,
    globus_gass_transfer_requestattr_t *	attr,
    char *					url,
    char *					file,
    globus_io_attr_t *				file_attr,
    globus_bool_t				follow_referrals,
    globus_i_gass_transfer_assist_op_t		op);

int
globus_gass_transfer_assist_register_get_file_from_url(
    globus_gass_transfer_request_t *		request,
    globus_gass_transfer_requestattr_t *	attr,
    char *					url,
    char *					file,
    globus_io_attr_t *				file_attr,
    globus_gass_transfer_callback_t		callback,
    void *					user_arg);

int
globus_gass_transfer_assist_get_file_from_url(
    globus_gass_transfer_request_t *		request,
    globus_gass_transfer_requestattr_t *	attr,
    char *					url,
    char *					file,
    globus_io_attr_t *				file_attr,
    globus_bool_t				follow_referrals);

/* Module descriptor */
extern
globus_module_descriptor_t globus_i_gass_transfer_assist_module;

#define GLOBUS_GASS_TRANSFER_ASSIST_MODULE	\
        (&globus_i_gass_transfer_assist_module)

EXTERN_C_END

#endif /* GLOBUS_INCLUDE_GASS_TRANSFER_ASSIST_H */
