/******************************************************************************
globus_gass_common.h
 
Description:
    This header contains the GASS common info
 
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/libraries/common/globus_i_gass_common.h,v $
    $Date: 1999/05/22 17:47:35 $
    $Revision: 1.6 $
    $Author: bresnaha $
******************************************************************************/
#ifndef _GLOBUS_INCLUDE_GLOBUS_I_GASS_COMMON_H_
#define _GLOBUS_INCLUDE_GLOBUS_I_GASS_COMMON_H_

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_gass_common.h"

EXTERN_C_BEGIN

/* Server Listener Handler Table indices */
#define GLOBUS_I_GASS_PUT_REQUEST_CONNECT 0
#define GLOBUS_I_GASS_GET_REQUEST_CONNECT 1
#define GLOBUS_I_GASS_INFO_REQUEST_CONNECT 2

/* Server Put Handler Table Indices */
#define GLOBUS_I_GASS_PUT_REQUEST_DATA 0
#define GLOBUS_I_GASS_PUT_REQUEST_FAIL 1

/* Server Get Handler Table Indices */
#define GLOBUS_I_GASS_GET_REQUEST_FAIL 0

/* Client Put Handler Table Indices */
#define GLOBUS_I_GASS_PUT_REQUEST_CONNECT_REPLY 0
/*#define GLOBUS_I_GASS_PUT_REQUEST_FAIL 1*/
#define GLOBUS_I_GASS_PUT_REQUEST_ACK 2

/* Client Get Handler Table Indices */
/*#define GLOBUS_I_GASS_GET_REQUEST_FAIL 0*/
#define GLOBUS_I_GASS_GET_REQUEST_CONNECT_REPLY 1
#define GLOBUS_I_GASS_GET_REQUEST_DATA 2

/* Client Info Handler Table Index */
#define GLOBUS_I_GASS_INFO_REQUEST_CONNECT_REPLY 0

typedef void (*globus_i_gass_poll_callback_t) (void *);

/* poll.c */
struct globus_i_gass_poll_s 
{
    void *                             arg;
    globus_callback_handle_t           handle;
    globus_i_gass_poll_callback_t      callback;
    struct globus_i_gass_poll_s *      next;
} ;

int globus_i_gass_poll_init();
int globus_i_gass_poll_callback_register(void *arg,
				 globus_i_gass_poll_callback_t callback,
				 globus_i_gass_poll_t *callback_handle);
int globus_i_gass_poll_callback_unregister(globus_i_gass_poll_t *poll_handle);

#ifdef GLOBUS_GASS_CLIENT
#define globus_gass_debug_print1(arg) \
	globus_gass_client_diagnostics_printf(arg)
#define globus_gass_debug_print2(arg1,arg2) \
    	globus_gass_client_diagnostics_printf(arg1, arg2)
#define globus_gass_debug_print3(arg1,arg2,arg3) \
    	globus_gass_client_diagnostics_printf(arg1,arg2,arg3)
#define globus_gass_debug_print4(arg1,arg2,arg3,arg4) \
    	globus_gass_client_diagnostics_printf(arg1,arg2,arg3,arg4)
#endif

#ifdef GLOBUS_GASS_SERVER
#define globus_gass_debug_print1(arg) \
	globus_gass_server_diagnostics_printf(arg)
#define globus_gass_debug_print2(arg1,arg2) \
    	globus_gass_server_diagnostics_printf(arg1, arg2)
#define globus_gass_debug_print3(arg1,arg2,arg3) \
    	globus_gass_server_diagnostics_printf(arg1,arg2,arg3)
#define globus_gass_debug_print4(arg1,arg2,arg3,arg4) \
    	globus_gass_server_diagnostics_printf(arg1,arg2,arg3,arg4)
#endif

#ifdef DEBUG
#ifdef BUILD_LITE
#define globus_i_gass_mutex_lock(m) \
{\
    globus_gass_diagnostics_printf("locking mutex %s on line %d of file %s\n",\
            #m, __LINE__, __FILE__);\
    globus_mutex_lock(m);\
}
#define globus_i_gass_mutex_unlock(m)\
{\
    if((*m) == 0)\
    {\
	globus_gass_diagnostics_printf(\
	    "unlocking ALREADY UNLOCKED mutex %s on line %d of file %s\n",\
	    #m, __LINE__, __FILE__);\
    }\
    else\
    {\
	globus_gass_diagnostics_printf(\
	    "unlocking mutex %s on line %d of file %s\n",\
            #m, __LINE__, __FILE__);\
    }\
    globus_mutex_unlock(m);\
}
#define globus_i_gass_cond_wait(c,m) \
{\
    globus_gass_diagnostics_printf(\
        "cond wait is unlocking mutex %s on line %d of file %s\n",\
        #m, __LINE__, __FILE__);\
    globus_cond_wait(c,m);\
}
#else
#define globus_i_gass_mutex_lock(m) \
{\
    globus_gass_diagnostics_printf(\
        "locking mutex %s on line %d of file %s\n",#m, __LINE__, __FILE__);\
    globus_mutex_lock(m);\
}
#define globus_i_gass_mutex_unlock(m) \
{\
    globus_gass_diagnostics_printf( \
        "unlocking mutex %s on line %d of file %s\n",\
        #m, __LINE__, __FILE__);\
    globus_mutex_unlock(m);\
}
#define globus_i_gass_cond_wait(c,m) \
{\
    globus_gass_diagnostics_printf( \
        "cond wait is unlocking mutex %s on line %d of file %s\n",\
        #m, __LINE__, __FILE__);\
    globus_cond_wait(c,m);\
}
#endif
#else
#define globus_i_gass_mutex_lock(m) globus_mutex_lock(m)
#define globus_i_gass_mutex_unlock(m) globus_mutex_unlock(m)
#define globus_i_gass_cond_wait(c,m) globus_cond_wait(c,m)
#endif

/* data_queue.c */
/* Every exported symbol from this module is defined with a _client_
 * and _server_ version. The algorithms and code are the same for the
 * symmetric cases (client_get and server_put, and vice versa), with a
 * couple of minor exceptions. The symbols need to be defined with
 * unique names, so that proglobus_grams can link against both the client and
 * server libraries. It would be bad if this header were public.
 *
 * Will look into doing pseudo-inheritence to eliminate this sometime...
 */
   
#ifndef GLOBUS_GASS_FILE

#ifdef GLOBUS_GASS_CLIENT
#define globus_i_gass_write		 globus_i_gass_client_write
#define globus_i_gass_src_fail_notify    globus_i_gass_client_put_fail_notify
#define globus_i_gass_sink_fail_notify   globus_i_gass_client_get_fail_notify
#define globus_i_gass_src_buffer_send    globus_i_gass_client_put_request_send
#define globus_i_gass_sink_data_handler  globus_i_gass_client_get_handler
#define globus_i_gass_sink_request_destroy globus_i_gass_client_get_request_destroy
#define globus_i_gass_src_send		 globus_i_gass_client_put_request_send
#define globus_i_gass_src_request_destroy globus_i_gass_client_put_request_destroy
#define globus_i_gass_remove_sink_request globus_i_gass_client_remove_get_request
#define globus_i_gass_remove_src_request globus_i_gass_client_remove_put_request
#define globus_i_gass_sink_fd_done_t     globus_gass_client_get_request_fd_done_t
#define globus_i_gass_sink_memory_done_t globus_gass_client_get_request_memory_done_t
#define globus_i_gass_src_fd_done_t      globus_gass_client_put_request_fd_done_t 
#define globus_i_gass_src_memory_done_t  globus_gass_client_put_request_memory_done_t

#define globus_i_gass_sink_incoming_s    globus_i_gass_client_sink_incoming_s
#define globus_i_gass_sink_outstanding_s globus_i_gass_client_sink_outstanding_s
#define globus_i_gass_src_outstanding_s  globus_i_gass_client_src_outstanding_s

#define globus_i_gass_sink_incoming_t    globus_i_gass_client_sink_incoming_t
#define globus_i_gass_sink_outstanding_t globus_i_gass_client_sink_outstanding_t
#define globus_i_gass_src_outstanding_t  globus_i_gass_client_src_outstanding_t

#define globus_i_gass_sink_incoming_init       globus_i_gass_client_incoming_init
#define globus_i_gass_sink_incoming_destroy    globus_i_gass_client_sink_incoming_destroy
#define globus_i_gass_sink_outstanding_init    globus_i_gass_client_sink_outstanding_init
#define globus_i_gass_sink_outstanding_destroy globus_i_gass_client_sink_outstanding_destroy

#define globus_i_gass_src_outstanding_init     globus_i_gass_client_src_outstanding_init
#define globus_i_gass_src_outstanding_destroy  globus_i_gass_client_src_outstanding_destroy

#define globus_i_gass_sink_request_t           globus_gass_client_get_request_t
#define globus_i_gass_src_request_t            globus_gass_client_put_request_t

#define globus_i_gass_src_poll                 globus_i_gass_client_src_poll
#define globus_i_gass_sink_poll                globus_i_gass_client_sink_poll
#define globus_i_gass_src_schedule_fd_read     globus_i_gass_client_src_schedule_fd_read

#define globus_i_gass_sink_request_memory      globus_i_gass_client_sink_request_memory
#define globus_i_gass_sink_request_fd          globus_i_gass_client_sink_request_fd
#define globus_i_gass_src_request_memory       globus_i_gass_client_src_request_memory
#define globus_i_gass_src_request_fd           globus_i_gass_client_src_request_fd
#define globus_i_gass_sink_schedule_socket_read globus_i_gass_client_sink_schedule_socket_read
#endif

#ifdef GLOBUS_GASS_SERVER
#define globus_i_gass_write		 globus_i_gass_server_write
#define globus_i_gass_src_fail_notify    globus_i_gass_server_get_fail_notify
#define globus_i_gass_sink_fail_notify   globus_i_gass_server_put_fail_notify
#define globus_i_gass_src_buffer_send    globus_i_gass_server_get_request_send
#define globus_i_gass_sink_data_handler  globus_i_gass_server_put_handler
#define globus_i_gass_sink_request_destroy globus_i_gass_server_put_request_destroy
#define globus_i_gass_src_send		 globus_i_gass_server_get_request_send
#define globus_i_gass_src_request_destroy globus_i_gass_server_get_request_destroy
#define globus_i_gass_remove_src_request globus_i_gass_server_remove_get_request
#define globus_i_gass_remove_sink_request globus_i_gass_server_remove_put_request
#define globus_i_gass_sink_fd_done_t     globus_gass_server_put_request_fd_done_t
#define globus_i_gass_sink_memory_done_t globus_gass_server_put_request_memory_done_t
#define globus_i_gass_src_fd_done_t      globus_gass_server_get_request_fd_done_t 
#define globus_i_gass_src_memory_done_t  globus_gass_server_get_request_memory_done_t

#define globus_i_gass_sink_incoming_s    globus_i_gass_server_sink_incoming_s
#define globus_i_gass_sink_outstanding_s globus_i_gass_server_sink_outstanding_s
#define globus_i_gass_src_outstanding_s  globus_i_gass_server_src_outstanding_s

#define globus_i_gass_sink_incoming_t    globus_i_gass_server_sink_incoming_t
#define globus_i_gass_sink_outstanding_t globus_i_gass_server_sink_outstanding_t
#define globus_i_gass_src_outstanding_t  globus_i_gass_server_src_outstanding_t

#define globus_i_gass_sink_incoming_init       globus_i_gass_server_incoming_init
#define globus_i_gass_sink_incoming_destroy    globus_i_gass_server_sink_incoming_destroy
#define globus_i_gass_sink_outstanding_init    globus_i_gass_server_sink_outstanding_init
#define globus_i_gass_sink_outstanding_destroy globus_i_gass_server_sink_outstanding_destroy

#define globus_i_gass_src_outstanding_init     globus_i_gass_server_src_outstanding_init
#define globus_i_gass_src_outstanding_destroy  globus_i_gass_server_src_outstanding_destroy

#define globus_i_gass_sink_request_t           globus_gass_server_put_request_t
#define globus_i_gass_src_request_t            globus_gass_server_get_request_t

#define globus_i_gass_src_poll                 globus_i_gass_server_src_poll
#define globus_i_gass_sink_poll                globus_i_gass_server_sink_poll
#define globus_i_gass_src_schedule_fd_read     globus_i_gass_server_src_schedule_fd_read

#define globus_i_gass_sink_request_memory      globus_i_gass_server_sink_request_memory
#define globus_i_gass_sink_request_fd          globus_i_gass_server_sink_request_fd
#define globus_i_gass_src_request_memory       globus_i_gass_server_src_request_memory
#define globus_i_gass_src_request_fd           globus_i_gass_server_src_request_fd
#define globus_i_gass_sink_schedule_socket_read globus_i_gass_server_sink_schedule_socket_read
#endif

struct globus_i_gass_sink_incoming_s
{
    globus_nexus_buffer_t 	nexus_data_buffer;
    globus_byte_t 		*socket_data_buffer;
    unsigned long		data_length; /*amount left in the buffer*/
    globus_bool_t 		last_data;

    globus_i_gass_sink_incoming_t *next;
};

struct globus_i_gass_sink_outstanding_s
{
    globus_bool_t fd_request;
    int fd;

    unsigned long block_size;	/* preferred size of data to transfer to fd */
    unsigned long max_length;	/* The maximum amount of data to arrive for */
				/* this request, equal to buffer_length for */
				/* memory requests, possibly larger for fd */
				/* ones */
    globus_byte_t *buffer;
    unsigned long buffer_length;
    
    unsigned long buffer_used;	/* needed if a memory request is partially */
				/* filled by an rsr, but less than wait_for */
				/* arrives */
    
    unsigned long wait_for;	/* minimum amount of data to arrive for */
				/* a mem_request */
    unsigned long length_so_far;
    globus_bool_t last_data;

    globus_i_gass_sink_fd_done_t fd_callback;
    globus_i_gass_sink_memory_done_t mem_callback;
    
    globus_i_gass_sink_outstanding_t *next;
};


/* transfer state for data source outstanding request parts */
#define GLOBUS_I_GASS_DATA_PENDING 0
#define GLOBUS_I_GASS_DATA_ACTIVE  1
#define GLOBUS_I_GASS_DATA_DONE    2

struct globus_i_gass_src_outstanding_s
{
    globus_bool_t fd_request;
    globus_byte_t *buffer;
    unsigned long buffer_length;
    int fd;
    globus_bool_t last_data;

    unsigned long block_size;
    unsigned long max_length;
    unsigned long length_so_far;

    globus_i_gass_src_fd_done_t fd_callback;
    globus_i_gass_src_memory_done_t mem_callback;

    int transfer_state; /* GLOBUS_I_GASS_DATA_{PENDING|ACTIVE|DONE} */
    globus_i_gass_src_outstanding_t *next;
};

extern int globus_i_gass_sink_incoming_init(globus_i_gass_sink_incoming_t *data);
extern int globus_i_gass_sink_incoming_destroy(globus_i_gass_sink_incoming_t *data);
extern int globus_i_gass_sink_outstanding_init(globus_i_gass_sink_outstanding_t *data);
extern int globus_i_gass_sink_outstanding_destroy(globus_i_gass_sink_outstanding_t *data);

extern int globus_i_gass_src_outstanding_init(globus_i_gass_src_outstanding_t *data);
extern int globus_i_gass_src_outstanding_destroy(globus_i_gass_src_outstanding_t *data);


extern void globus_i_gass_sink_poll(void *arg);
extern void globus_i_gass_src_poll(void *arg);
extern void globus_i_gass_src_schedule_fd_read(globus_i_gass_src_request_t *r);

extern int globus_i_gass_src_request_memory(globus_i_gass_src_request_t *request,
					    globus_byte_t *buffer,
					    unsigned long buffer_length,
					    globus_bool_t last_data,
					    globus_i_gass_src_memory_done_t callback);

extern int globus_i_gass_src_request_fd(globus_i_gass_src_request_t *request,
					int fd,
					unsigned long block_size,
					unsigned long max_length,
					globus_bool_t last_data,
					globus_i_gass_src_fd_done_t callback);

extern int globus_i_gass_sink_request_fd(globus_i_gass_sink_request_t *request,
					 int fd,
					 unsigned long block_size,
					 unsigned long max_length,
					 globus_i_gass_sink_fd_done_t callback);

extern int globus_i_gass_write(int fd,
			       globus_byte_t *buffer,
			       size_t length);

extern int globus_i_gass_sink_request_memory(globus_i_gass_sink_request_t *request,
					     globus_byte_t *buffer,
					     unsigned long buffer_length,
					     unsigned long wait_length,
					     globus_i_gass_sink_memory_done_t callback);

extern void globus_i_gass_sink_data_handler(globus_nexus_endpoint_t *ep,
					    globus_nexus_buffer_t *buffer,
					    globus_bool_t non_threaded);

void globus_i_gass_sink_schedule_socket_read(globus_i_gass_sink_request_t *r);
#endif

extern int
globus_i_gass_poll_activate(void);
extern int
globus_i_gass_poll_deactivate(void);
extern void globus_i_gass_src_buffer_send(globus_i_gass_src_request_t *r,
					  globus_i_gass_src_outstanding_t *d,
					  unsigned long nbytes,
					  globus_bool_t last_data);

#define GLOBUS_I_GASS_POLL_MODULE (&globus_i_gass_poll_module)
extern globus_module_descriptor_t globus_i_gass_poll_module;

EXTERN_C_END

#endif
