#ifndef GLOBUS_DONT_DOCUMENT_INTERNAL
/**
 * @file globus_gass_common.h
 *
 * This header contains the GASS common info
 *
 * CVS Information:
 *
 *  $Source: /home/globdev/CVS/globus-current/Globus/FileAccess/gass/libraries/common/globus_gass_common.h,v $
 *  $Date: 2001/03/12 18:16:05 $
 *  $Revision: 1.9 $
 *  $Author: bester $
 */
#endif

/**
 * @mainpage GASS Common
 * This documentation set describes common error and values and
 * constants used in the various GASS Transfer libraries.
 */

#ifndef _GLOBUS_GASS_INCLUDE_GLOBUS_GASS_COMMON_H_
#define _GLOBUS_GASS_INCLUDE_GLOBUS_GASS_COMMON_H_

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_common.h"

EXTERN_C_BEGIN

/**
 * @defgroup globus_gass_constants GASS Constants
 */

/**
 * GASS error codes
 * @ingroup globus_gass_constants
 */
enum
{
    /** Invalid port in URL */
    GLOBUS_GASS_ERROR_BAD_PORT = 2,
    /** Something bad occurred while processing the request */
    GLOBUS_GASS_ERROR_INTERNAL_ERROR,
    /** Unparsable URL */
    GLOBUS_GASS_ERROR_BAD_URL,
    /** Invalid file open mode in the GASS File library */
    GLOBUS_GASS_ERROR_NOT_SUPPORTED,
    /** Operation not supported by GASS for this type of URL */
    GLOBUS_GASS_ERROR_NOT_IMPLEMENTED,
    /** Out of memory */
    GLOBUS_GASS_ERROR_MALLOC_FAILED,
    /** Uninitialized or invalid handle */
    GLOBUS_GASS_ERROR_NOT_INITIALIZED,
    /** NULL pointer passed as parameter */
    GLOBUS_GASS_ERROR_NULL_POINTER,
    /** GASS Server not yet registered */
    GLOBUS_GASS_ERROR_NOT_REGISTERED,
    /** URL not in cache */
    GLOBUS_GASS_ERROR_NOT_FOUND,
    /** Invalid use of a GASS handle */
    GLOBUS_GASS_ERROR_INVALID_USE,
    /** Bytes array exceeds GASS request size */
    GLOBUS_GASS_ERROR_TOO_LARGE,
    /** GASS Transfer request did not complete successfully */
    GLOBUS_GASS_ERROR_REQUEST_FAILED,
    /** GASS handle already closed before this operation began*/
    GLOBUS_GASS_ERROR_DONE,
    /** GASS handle already registered for processing */
    GLOBUS_GASS_ERROR_ALREADY_REGISTERED,
    /** Could not open local file */
    GLOBUS_GASS_ERROR_OPEN_FAILED,
    /** A protocol error or client-initiated failure has occurred */
    GLOBUS_GASS_ERROR_TRANSFER_FAILED
};

/**
 * @ingroup globus_gass_constants
 *
 * Default buffer length for the globus_gass_transfer_assist library.
 *
 * @hideinitializer
 */
enum
{
    GLOBUS_GASS_DEFAULT_BUFFER_LENGTH = 1024
};

/**
 * @ingroup globus_gass_constants
 *
 * Value for files we don't know the length of.
 *
 * @hideinitializer
 */
#define GLOBUS_GASS_LENGTH_UNKNOWN 0UL

/**
 * @ingroup globus_gass_constants
 *
 * Value for timestamps we don't know the value of.
 *
 * @hideinitializer
 */
#define GLOBUS_GASS_TIMESTAMP_UNKNOWN 0UL


EXTERN_C_END

#endif
