#if !defined(GFTPD_H)
#define      GFTPD_H

#include <globus_common.h>
#include <globus_ftp_control.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <string.h>
#include <globus_io.h>
#include <sys/stat.h>


#define SFTPD_STRING_SIZE           512
#define SFTPD_NLST_COMMAND          "/bin/ls -c1"
#define SFTPD_LIST_COMMAND          "/bin/ls"

typedef enum gftpd_control_state_e
{
    SFTPD_CONTROL_STATE_NONE,
    SFTPD_CONTROL_STATE_CLOSING,
} gftpd_control_state_t;

typedef struct gftpd_monitor_s
{
    globus_mutex_t                         mutex;
    globus_cond_t                          cond;
    globus_bool_t                          done;
    int                                    count;
    globus_result_t                        res;
} gftpd_monitor_t;

typedef struct gftpd_control_handle_s
{
    globus_mutex_t                         mutex;
    globus_cond_t                          cond;
    globus_bool_t                          done; 

    globus_ftp_control_handle_t            client_handle;
    gftpd_control_state_t                  state;

    globus_bool_t                          client_handle_connected;
} gftpd_control_handle_t;

typedef globus_result_t
(*gftpd_command_function_t)(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_control_handle_close(
    gftpd_control_handle_t *                 control_handle);

/*
 * functions from internal.c
 */
void
gftpd_print_help();

globus_bool_t
gftpd_parse_main_args(
    int                                          argc,
    char *                                       argv[]);

void
gftpd_debug_print(
    int                                       level,
    char *                                    fmt,
    ...);

globus_bool_t
gftpd_set_debug_print_file(
    char *                                      argv[],
    int                                         argc,
    int *                                       ctr);

void
gftpd_log_message(
    int                                        type,
    char *                                     fmt,
    ...);

int
gftpd_parse_into_substrings(
    char *                                      list,
    char *                                      arg[],
    int                                         argc);

void
gftpd_substrings_destroy(
    char *                                      arg[],
    int                                         argc);

void 
gftpd_monitor_init(
    gftpd_monitor_t *                           monitor);

void 
gftpd_monitor_destroy(
    gftpd_monitor_t *                           monitor);

void 
gftpd_monitor_reset(
    gftpd_monitor_t *                           monitor);

void
gftpd_command_read_commands_callback(
    void *                                      callback_arg,
    struct globus_ftp_control_handle_s *        handle,
    globus_object_t *                           error,
    union globus_ftp_control_command_u *        command);

/*
 *  global variables
 */
extern globus_bool_t                            g_secure;
extern char                                     g_hostname[];
extern char                                     g_version[];

extern unsigned short                           g_port;
extern unsigned short                           g_backend_port;

extern globus_bool_t                            g_fork;
extern globus_bool_t                            g_daemon;

extern char *                                   g_backend;
extern char **                                  g_backend_args;

extern globus_reltime_t                         g_timeout;

#endif
