#include <gftpd.h>

int
run_daemon();

/*
 *  main root process
 *
 *  listen for connections from both ftp clients and mpi process
 *  groups.
 *
 *  for no this should be kept short and simple since it is all
 *  being done with socket code instead of globus_io
 */
int
main(
    int                                         argc,
    char *                                      argv[])
{
    int                                         fd;

    if(!gftpd_parse_main_args(argc, argv))
    {
        return 1;
    }

    if(g_daemon)
    {
        run_daemon();
    }
    else
    {
        fd = fileno(stdin);
        gftpd_control_main(fd);
    }

    return 0;
}

int
run_daemon()
{
    int                                         fd;
    int                                         client_sock;
    int                                         client_fd;
    int                                         done = 0;
    struct sockaddr_in                          client_addr;
    struct sockaddr                             client_accept_addr;
    int                                         addr_len;
    pid_t                                       pid;
    int                                         flags;

    /*
     *  setup the client listener socket
     */
    client_sock = socket(AF_INET, SOCK_STREAM, 0);
    if(client_sock < 0)
    {
        goto err;
    }
    flags = fcntl(client_sock, F_GETFL, 0);
    flags |= O_NDELAY;
    fcntl(client_sock, F_SETFL, flags);
    client_addr.sin_addr.s_addr = INADDR_ANY;
    client_addr.sin_family = AF_INET;
    client_addr.sin_port = htons(g_port);
    memset(&client_addr, '\0', sizeof(client_addr));
    if(bind(client_sock, 
            (struct sockaddr *)&client_addr, sizeof(client_addr)) != 0)
    {
        goto err;
    }
    if(listen(client_sock, -1) != 0)
    {
        goto err;
    }
    addr_len = sizeof(client_addr);
    getsockname(client_sock,  (struct sockaddr *)&client_addr, &addr_len);
    g_port = ntohs(client_addr.sin_port); 

    gftpd_debug_print(1, "listening on port %d\n", g_port);
    while(!done)
    {
        addr_len = sizeof(client_accept_addr);
        client_fd = accept(client_sock, &client_accept_addr, &addr_len);
        if(client_fd >= 0)
        {
            pid = 0;
            if(g_fork)
            {
                pid = fork();
            }
            else
            {
                done = GLOBUS_TRUE;
            }

            /*
             *  Child:  control process
             */
            if(pid == 0)
            {
                /* call control_main() */
                gftpd_control_main(client_fd);
                goto exit;
            }
            else
            {
                close(client_fd);
            }
        }
    }

    /*
     *  send the die message to all of the slaves
     */

exit:
    return 0;

err:
    return 1;
}
