#include <gftpd.h>

globus_result_t
gftpd_command_cwd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_dele(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_help(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_list(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_mkd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_mode(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_nlst(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_pass(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_pasv(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_port(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_pwd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_quit(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_size(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_syst(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_stat(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_type(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

globus_result_t
gftpd_command_user(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len);

/*
 *  table of server implemented commands
 */
typedef struct gftpd_command_table_entry_s
{
    globus_ftp_control_command_code_t        command;
    char *                                   command_str;
    char *                                   description;
    gftpd_command_function_t                 func;
} gftpd_command_table_entry_t;

static gftpd_command_table_entry_t           g_command_table[] =
{
    {GLOBUS_FTP_CONTROL_COMMAND_CWD,
     "CWD",
      "change current directory",
      gftpd_command_cwd},
    {GLOBUS_FTP_CONTROL_COMMAND_DELE,
     "DELE",
      "delete a file",
      gftpd_command_dele},
    {GLOBUS_FTP_CONTROL_COMMAND_HELP,
     "HELP",
      "list the commands",
      gftpd_command_help},
    {GLOBUS_FTP_CONTROL_COMMAND_MODE,
     "MODE",
      "set the mode",
      gftpd_command_mode},
    {GLOBUS_FTP_CONTROL_COMMAND_MKD,
     "MKD",
      "change current directory",
      gftpd_command_mkd},
    {GLOBUS_FTP_CONTROL_COMMAND_PASS,
     "PASS",
      "change current directory",
      gftpd_command_pass},
    {GLOBUS_FTP_CONTROL_COMMAND_PASV,
     "PASV",
      "change current directory",
      gftpd_command_pasv},
    {GLOBUS_FTP_CONTROL_COMMAND_PORT,
     "PORT",
      "change current directory",
      gftpd_command_port},
    {GLOBUS_FTP_CONTROL_COMMAND_PWD,
     "PWD",
      "return current directory",
      gftpd_command_pwd},
    {GLOBUS_FTP_CONTROL_COMMAND_QUIT,
     "QUIT",
      "change current directory",
      gftpd_command_quit},
    {GLOBUS_FTP_CONTROL_COMMAND_RMD,
     "RMD",
      "change current directory",
      gftpd_command_dele},
    {GLOBUS_FTP_CONTROL_COMMAND_SIZE,
     "SIZE",
      "change current directory",
      gftpd_command_size},
    {GLOBUS_FTP_CONTROL_COMMAND_SYST,
     "SYST",
      "change current directory",
      gftpd_command_syst},
    {GLOBUS_FTP_CONTROL_COMMAND_STAT,
     "SIZE",
      "change current directory",
      gftpd_command_stat},
    {GLOBUS_FTP_CONTROL_COMMAND_TYPE,
     "TYPE",
      "change current directory",
      gftpd_command_type},
    {GLOBUS_FTP_CONTROL_COMMAND_USER,
     "USER",
      "change current directory",
      gftpd_command_user},
/* not implemented */
    {GLOBUS_FTP_CONTROL_COMMAND_LIST,
     "LIST",
      "list the files in the directory",
      gftpd_command_list},
    {GLOBUS_FTP_CONTROL_COMMAND_NLST,
     "NLST",
      "change current directory",
      gftpd_command_nlst},
};

#define SFTPD_COMMAND_TABLE_SIZE                16

static void
gftpd_command_send_response_callback(
    void *                                      callback_arg,
    struct globus_ftp_control_handle_s *        handle,
    globus_object_t *                           error)
{
    gftpd_control_handle_t *                    control_handle;

    control_handle = (gftpd_control_handle_t *)callback_arg;

    globus_mutex_lock(&control_handle->mutex);
    {
        if(error != GLOBUS_NULL)
        {
            gftpd_control_handle_close(control_handle);
        }
    }
    globus_mutex_unlock(&control_handle->mutex);

}

void
gftpd_command_read_commands_callback(
    void *                                   callback_arg,
    struct globus_ftp_control_handle_s *     handle,
    globus_object_t *                        error,
    union globus_ftp_control_command_u *     command)
{
    int                                      ctr;
    globus_result_t                          res;
    globus_bool_t                            found = GLOBUS_FALSE;
    char                                     response[SFTPD_STRING_SIZE];
    gftpd_control_handle_t *                 control_handle;

    gftpd_debug_print(2, "gftpd_control_read_commands_callback() : start\n");

    control_handle = (gftpd_control_handle_t *)callback_arg;
    gftpd_debug_print(3, "received %s\n", command->base.raw_command);

    globus_mutex_lock(&control_handle->mutex);
    {
        if(error != GLOBUS_NULL)
        {
            gftpd_control_handle_close(control_handle);
        }
        for(ctr = 0; ctr < SFTPD_COMMAND_TABLE_SIZE && !found; ctr++)
        {
            if(command->base.code == g_command_table[ctr].command)
            {
                res = g_command_table[ctr].func(
                          control_handle,
                          command,
                          response,
                          SFTPD_STRING_SIZE);
                if(res == GLOBUS_SUCCESS)
                {
                    res = globus_ftp_control_send_response(
                              &control_handle->client_handle,
                              response,
                              gftpd_command_send_response_callback,
                              (void *)control_handle);
                }
                if(res != GLOBUS_SUCCESS)
                {
                    res = gftpd_control_handle_close(control_handle);
                }
                found = GLOBUS_TRUE;
            }
        }

        if(!found)
        {
            char *                 tmp_ptr;
  
            tmp_ptr = strstr(command->base.raw_command, "\r\n");
            if(tmp_ptr != GLOBUS_NULL)
            {
                *tmp_ptr = '\0';
            }
            sprintf(response, "500 '%s': command not understood.\r\n", 
                command->base.raw_command);
            res = globus_ftp_control_send_response(
                      &control_handle->client_handle,
                      response,
                      gftpd_command_send_response_callback,
                      (void *)control_handle);
            if(res != GLOBUS_SUCCESS)
            {
                res = gftpd_control_handle_close(control_handle);
            }
        }
    }
    globus_mutex_unlock(&control_handle->mutex);

    gftpd_debug_print(2, "gftpd_control_read_commands_callback() : end\n");
}

globus_result_t
gftpd_command_cwd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    if(chdir(command->cwd.string_arg) == 0)
    {
        sprintf(message, "250 CWD command successful\r\n");
    }
    else
    {
        sprintf(message, "550 %s: %s\r\n",
            command->cwd.string_arg,
            strerror(errno));
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_dele(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    if(remove(command->dele.string_arg) == 0)
    {
        sprintf(message, "250 DELE command successful.\r\n");
    }
    else
    {
        sprintf(message, "550 %s: %s\r\n",
            command->dele.string_arg,
            strerror(errno));
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_help(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    sprintf(message, "No help for you.\r\n");
    return GLOBUS_SUCCESS;
}

void
gftpd_list_connect_callback(
    void *                                   callback_arg,
    struct globus_ftp_control_handle_s *     handle,
    unsigned int                             stripe_ndx,
    globus_bool_t                            reused,
    globus_object_t *                        error)
{
    gftpd_monitor_t *                        monitor;

    monitor = (gftpd_monitor_t *)callback_arg;

    globus_mutex_lock(&monitor->mutex);
    {
        if(error != GLOBUS_NULL)
        {
            monitor->res = globus_error_put(globus_object_copy(error));
        } 
        monitor->done = GLOBUS_TRUE;
        globus_cond_signal(&monitor->cond);
    }
    globus_mutex_unlock(&monitor->mutex);
}

void
gftpd_list_data_callback(
    void *                                   callback_arg,
    globus_ftp_control_handle_t *            handle,
    globus_object_t *                        error,
    globus_byte_t *                          buffer,
    globus_size_t                            length,
    globus_off_t                             offset,
    globus_bool_t                            eof)
{
    gftpd_monitor_t *                        monitor;

    monitor = (gftpd_monitor_t *)callback_arg;

    globus_mutex_lock(&monitor->mutex);
    {
        if(error != GLOBUS_NULL)
        {
            monitor->res = globus_error_put(globus_object_copy(error));
        } 
        monitor->count--;
        globus_cond_signal(&monitor->cond);
    }
    globus_mutex_unlock(&monitor->mutex);
}

globus_result_t
gftpd_command_list(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
}

globus_result_t
gftpd_command_mkd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    mode_t                                   mode;

    mode = S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH;

    if(mkdir(command->mkd.string_arg, mode) == 0)
    {
        sprintf(message, "257 %s new directory created.\r\n",
                command->mkd.string_arg);
    }
    else
    {
        sprintf(message, "550 %s: %s\r\n",
            command->mkd.string_arg,
            strerror(errno));
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_mode(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    globus_result_t                          res;

    res = globus_ftp_control_local_mode(
              &control_handle->client_handle,
              command->mode.mode);

    return res; 
}

globus_result_t
gftpd_command_nlst(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
}

globus_result_t
gftpd_command_pass(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    sprintf(message, "503 Loggin with USER first.\r\n");

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_pasv(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    globus_ftp_control_host_port_t           host_port;
    globus_result_t                          res;
    int                                      hi;
    int                                      low;

    host_port.port = 0;
    res = globus_ftp_control_local_pasv(
              &control_handle->client_handle,
              &host_port);
    hi = host_port.port / 256;
    low = host_port.port % 256;

    sprintf(
        message,
        "227 Entering Passive Mode (%d,%d,%d,%d,%d,%d)\r\n",
        host_port.host[0],
        host_port.host[1],
        host_port.host[2],
        host_port.host[3],
        hi, 
        low);

    return res;
}

globus_result_t
gftpd_command_port(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    globus_result_t                          res;

    res = globus_ftp_control_local_port(
              &control_handle->client_handle,
              &command->port.host_port);
    if(res == GLOBUS_SUCCESS)
    {
        sprintf(message, "200 PORT command successful.\r\n");
    }
    else
    {
        sprintf(message, "500 PORT command failed.\r\n");
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_pwd(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    char *                                   buf;

    buf = (char *)globus_malloc(len);
    if(getcwd(buf, len) == NULL)
    {
        /* return error object */
    }

    sprintf(message, "%d %s\r\n", 257, buf);

    globus_free(buf);

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_quit(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    return gftpd_control_handle_close(control_handle);
}

globus_result_t
gftpd_command_size(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    struct stat                              f_info;

    /*
     *  determine size of ascii file
     */
    if(stat(command->size.string_arg, &f_info) == 0)
    {
        sprintf(message, "213 %d.\r\n", f_info.st_size);
    }
    else
    {
        sprintf(message, "550 %s: %s\r\n",
            command->dele.string_arg,
            strerror(errno));
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_syst(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    sprintf(message, "211 Globus FTP Server beta.\r\n");

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_stat(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    sprintf(message, "215 UNIX Type: L8\r\n");

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_type(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    globus_result_t                          res;

    res = globus_ftp_control_local_type(
              &control_handle->client_handle,
              command->type.type,
              0);
    if(res == GLOBUS_SUCCESS)
    {
        sprintf(message, "200 Type set to %c.\r\n",
            (char *)command->type.type);
    }
    else
    {
        sprintf(message, "500 '%s': command not understood.\r\n",
            command->type.raw_command);
    }

    return GLOBUS_SUCCESS;
}

globus_result_t
gftpd_command_user(
    gftpd_control_handle_t *                 control_handle,
    globus_ftp_control_command_t *           command,
    char *                                   message,
    size_t                                   len)
{
    sprintf(message, "530 Already logged in.\r\n");

    return GLOBUS_SUCCESS;
}

