#include "globus_common.h"

#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "globus_ftp_client.h"
#include "globus_ftp_client_plugin.h"

#include "restart_plugin.h"
#include "abort_plugin.h"
#include "printf_plugin.h"
#include "pause_plugin.h"

int test_abort_count = 0;

void
test_parse_args(int argc, 
		char *argv[],
		globus_ftp_client_handleattr_t * handle_attr,
		globus_ftp_client_operationattr_t * operation_attr,
		char **src,
		char **dst)
{
    int c;
    extern char * optarg;
    globus_reltime_t timeout;
    globus_ftp_client_plugin_t *plugin;
    globus_ftp_control_dcau_t dcau;

    *src = GLOBUS_NULL;
    *dst = GLOBUS_NULL;

    setvbuf(stdout, 0, _IONBF, 0);
    
    while((c = getopt(argc, argv, "a:ps:d:r:zc:t:")) != -1)
    {
	switch(c)
	{
	case 'a':
	    globus_module_activate(GLOBUS_FTP_CLIENT_ABORT_PLUGIN_MODULE);
	    
	    plugin = globus_libc_malloc(sizeof(globus_ftp_client_plugin_t));
	    globus_ftp_client_abort_plugin_init(plugin);
	    

	    if(atoi(optarg) >= FTP_ABORT_LAST ||
	       atoi(optarg) < 0)
	    {
		printf("Abort plugin argument out of range\n");
		globus_module_deactivate_all();
		exit(1);
	    }
	    globus_ftp_client_abort_plugin_set_abort_point(plugin,
							   atoi(optarg));

	    globus_ftp_client_abort_plugin_set_abort_counter(
		plugin,
		&test_abort_count);

	    globus_ftp_client_handleattr_add_plugin(handle_attr, plugin);

	    break;
	case 'p':
	    globus_module_activate(GLOBUS_FTP_CLIENT_PRINTF_PLUGIN_MODULE);

	    plugin = globus_libc_malloc(sizeof(globus_ftp_client_plugin_t));
	    globus_ftp_client_printf_plugin_init(plugin);

	    globus_ftp_client_handleattr_add_plugin(handle_attr, plugin);
	    
	    break;
	case 'z':
	    globus_module_activate(GLOBUS_FTP_CLIENT_PAUSE_PLUGIN_MODULE);

	    plugin = globus_libc_malloc(sizeof(globus_ftp_client_plugin_t));
	    globus_ftp_client_pause_plugin_init(plugin);

	    globus_ftp_client_handleattr_add_plugin(handle_attr, plugin);
	    
	    break;
	case 'r':
	    globus_module_activate(GLOBUS_FTP_CLIENT_RESTART_PLUGIN_MODULE);
	    plugin = globus_libc_malloc(sizeof(globus_ftp_client_plugin_t));
	    globus_ftp_client_restart_plugin_init(plugin);
	    if(atoi(optarg) >= FTP_RESTART_LAST ||
	       atoi(optarg) < 0)
	    {
		printf("Restart plugin argument out of range\n");
		globus_module_deactivate_all();
		exit(1);
	    }
	    else
	    {
		char *p;
		p = strchr(optarg, ',');
		if(p)
		{
		    GlobusTimeReltimeSet(timeout, atoi(p+1),0);
		}
		else
		{
		    GlobusTimeReltimeSet(timeout, 0, 0);
		}
		globus_ftp_client_restart_plugin_set_restart_point(
		    plugin,
		    atoi(optarg),
		    &timeout);
		globus_ftp_client_handleattr_add_plugin(handle_attr, plugin);
	    }

	    break;
	case 's':
	    *src = optarg;
	    break;
	case 'd':
	    *dst = optarg;
	    break;
	case 'c':
	    if(!strcmp(optarg, "none"))
	    {
		dcau.mode = GLOBUS_FTP_CONTROL_DCAU_NONE;
		globus_ftp_client_operationattr_set_dcau(operation_attr,
							  &dcau);
	    }
	    else if(!strcmp(optarg, "self"))
	    {
		dcau.mode = GLOBUS_FTP_CONTROL_DCAU_SELF;
		globus_ftp_client_operationattr_set_dcau(operation_attr,
							  &dcau);
	    }
	    else
	    {
		dcau.mode = GLOBUS_FTP_CONTROL_DCAU_SUBJECT;
		dcau.subject.subject = optarg;
		globus_ftp_client_operationattr_set_dcau(operation_attr,
							  &dcau);
	    }
	    break;
	case 't':
	    if(!strcmp(optarg, "clear"))
	    {
		globus_ftp_client_operationattr_set_protection(
			operation_attr,
			GLOBUS_FTP_CONTROL_PROTECTION_CLEAR);
	    }
	    else if(!strcmp(optarg, "safe"))
	    {
		globus_ftp_client_operationattr_set_protection(
			operation_attr,
			GLOBUS_FTP_CONTROL_PROTECTION_SAFE);
	    }
	    else if(!strcmp(optarg, "private"))
	    {
		globus_ftp_client_operationattr_set_protection(
			operation_attr,
			GLOBUS_FTP_CONTROL_PROTECTION_PRIVATE);
	    }
	    break;
	case '?':
	    globus_module_deactivate_all();
	    exit(0);
	}
    }
    if((*src) == GLOBUS_NULL)
    {
	(*src) = "gsiftp://localhost/etc/group";
    }
    if((*dst) == GLOBUS_NULL)
    {
	(*dst) = "gsiftp://localhost/tmp/etc_group";
    }
}
