#! /usr/bin/perl

use strict;
use Test::Harness;
require 5.005;
use vars qw(@tests);

@tests = qw( create_destroy_test.pl
             simple_get.pl
	     lingering_get.pl
	     simple_transfer.pl
	     multiple_block_get.pl
	     simple_get_caching.pl
	     bad_buffer.pl
	     partial_get.pl
	     simple_put.pl
	     partial_put.pl
	     simple_transfer_caching.pl
	     user_auth.pl
	     partial_transfer.pl
	     extended_get.pl
	     extended_put.pl
	     extended_transfer.pl
	     );
	     #ascii_mode.pl
if(0 != system("grid-proxy-info -exists -hours 2") / 255)
{
    print "Security proxy required to run the tests.\n";
    exit 1;
}
print "Running sanity check\n";
if(0 != system("../simple_get > /dev/null") / 255)
{
    print "Sanity check failed.\n";
    exit 1;
}
print "Server appears sane, running tests\n";
runtests(@tests);
