#! /usr/bin/perl 
#
# Test to exercise the deactivation of the client and control libraries,
# an operation is left in progress before deactivating.
#

use strict;
use POSIX;
use Test;

my $test_exec = '../lingering_get';
my @tests;

# Test #1. Try to get a file from an FTP server, but don't ever deal
# with data blocks, deactivating in mid-stream.
sub lingering_get
{
    my $tmpname = POSIX::tmpnam();
    my ($errors,$rc) = ("",0);
    my ($old_proxy);

    unlink('core', $tmpname);

    $rc = system("$test_exec >$tmpname 2>/dev/null") / 256;
    if($rc != 1)
    {
        $errors .= "Test exited with $rc. ";
    }
    if(-r 'core')
    {
        $errors .= "\n# Core file generated.";
    }

    if($errors eq "")
    {
        ok('success', 'success');
    }
    else
    {
        ok($errors, 'success');
    }
    unlink($tmpname);
}
push(@tests, "lingering_get();");

# Now that the tests are defined, set up the Test to deal with them.
plan tests => scalar(@tests);

# And run them all.
foreach (@tests)
{
    eval "&$_";
}
