/*
 * restart marker test. try the various restart marker commands.
 */
#include "globus_i_ftp_client.h"
#include "test_common.h"

static globus_mutex_t lock;
static globus_cond_t cond;
static globus_bool_t done;
static globus_bool_t error = GLOBUS_FALSE;
#define SIZE 42

int main(int argc,
	 char *argv[])
{
    globus_ftp_client_restart_marker_t		marker;
    globus_result_t				result;
    int						ok=0;
    int						tests=0;
    int						not_ok=0;
    char *					marker_str;
    globus_i_ftp_client_range_t * 		range;

    result = (globus_result_t) globus_module_activate(GLOBUS_FTP_CLIENT_MODULE);
    if(result != GLOBUS_SUCCESS)
    {
        goto fail_tests;
    }

    /* #1. Initialize and Destroy a restart marker */
    tests++;
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_init(&marker);
	if(result == GLOBUS_SUCCESS)
	{
            result = globus_ftp_client_restart_marker_destroy(&marker);
	    if(result == GLOBUS_SUCCESS)
	    {
	        ok++;
	    }
	}
    }

    /* #2. Set the offset of a restart marker */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_set_offset(&marker,
	                                                     121);
        if(result == GLOBUS_SUCCESS && 
	   marker.stream.offset == 121 &&
	   marker.stream.ascii_offset == 121)
	{
	    if(globus_ftp_client_restart_marker_destroy(&marker)
	       == GLOBUS_SUCCESS)
	    {
	        ok++;
	    }
	}
    }

    /* #3. Convert a restart marker's offset into a string */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_set_offset(&marker,
							     121);
        if(result == GLOBUS_SUCCESS)
	{
	    result = globus_ftp_client_restart_marker_to_string(&marker,
	                                                        &marker_str);
            if(result == GLOBUS_SUCCESS)
	    {
	        if(strcmp(marker_str, "121") == 0)
	        {
	            ok++;
	        }
		globus_libc_free(marker_str);
	    }
	    (void) globus_ftp_client_restart_marker_destroy(&marker);
        }
    }

    /* #4. Convert a restart marker string into a restart marker */
    tests++;
    result = globus_ftp_client_restart_marker_from_string(&marker,
	                                                  "142");
    if(result == GLOBUS_SUCCESS)
    {
        if(marker.type == GLOBUS_FTP_CLIENT_RESTART_STREAM &&
	   marker.stream.offset == 142 && marker.stream.ascii_offset == 142)
	{
	    ok++;
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }

    /* #5. Insert a single extended block mode range into a restart marker */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                       100,
							       125);
	if(result == GLOBUS_SUCCESS)
	{
	    if(marker.type == GLOBUS_FTP_CLIENT_RESTART_EXTENDED_BLOCK &&
	       globus_fifo_size(&marker.extended_block.ranges) == 1)
	    {
	        range = (globus_i_ftp_client_range_t *)
		    globus_fifo_peek(&marker.extended_block.ranges);
	        if(range->offset == 100 && range->end_offset == 125)
		{
		    ok++;
		}
	    }
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }

    /* 6. Insert a pair of extended block range which are disjoint, and
     * make sure they are both in the fifo
     */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                       100,
							       125);
	if(result == GLOBUS_SUCCESS)
	{
            result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                           200,
							           225);
	    if(result == GLOBUS_SUCCESS &&
	       marker.type == GLOBUS_FTP_CLIENT_RESTART_EXTENDED_BLOCK &&
	       globus_fifo_size(&marker.extended_block.ranges) == 2)
	    {
	        range = (globus_i_ftp_client_range_t *)
		    globus_fifo_peek(&marker.extended_block.ranges);
	        if(range->offset == 100 && range->end_offset == 125)
		{
		    range = (globus_i_ftp_client_range_t *)
		        globus_fifo_tail_peek(&marker.extended_block.ranges);
		    if(range->offset == 200 && range->end_offset == 225)
		    {
		        ok++;
		    }
		}
	    }
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }

    /* 7. Insert a pair of extended block range which are disjoint, and
     * follow with the missing piece, expecting the ranges get combined into
     * one.
     */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                       100,
							       125);
	if(result == GLOBUS_SUCCESS)
	{
            result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                           200,
							           225);
	    if(result == GLOBUS_SUCCESS)
	    {
	        result = globus_ftp_client_restart_marker_insert_range(&marker,
		                                                       126,
		                                                       199);
	    }
	    if(result == GLOBUS_SUCCESS &&
	       marker.type == GLOBUS_FTP_CLIENT_RESTART_EXTENDED_BLOCK &&
	       globus_fifo_size(&marker.extended_block.ranges) == 1)
	    {
	        range = (globus_i_ftp_client_range_t *)
		    globus_fifo_peek(&marker.extended_block.ranges);
	        if(range->offset == 100 && range->end_offset == 225)
		{
		    ok++;
		}
	    }
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }
   /* 8. Convert a multi-range restart marker into a string. */
    tests++;
    result = globus_ftp_client_restart_marker_init(&marker);
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                       100,
							       125);
	if(result == GLOBUS_SUCCESS)
	{
            result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                           200,
							           225);
	    if(result == GLOBUS_SUCCESS)
	    {
	        result = globus_ftp_client_restart_marker_insert_range(&marker,
		                                                       300,
		                                                       325);
	    }
	    if(result == GLOBUS_SUCCESS &&
	       marker.type == GLOBUS_FTP_CLIENT_RESTART_EXTENDED_BLOCK &&
	       globus_fifo_size(&marker.extended_block.ranges) == 3)
	    {
	        result = globus_ftp_client_restart_marker_to_string(&marker,
	                                                            &marker_str);
		if(result == GLOBUS_SUCCESS)
		{
		    if(strcmp(marker_str, "100-125,200-225,300-325") == 0)
		    {
		        ok++;
		    }
		    globus_libc_free(marker_str);
		}
	    }
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }
    
   /* 9. Convert a multi-range restart marker string into a marker, and back
    * to a string. */
    tests++;
    result = globus_ftp_client_restart_marker_from_string(&marker,
                                                          "100-125,200-225");
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_to_string(&marker,
                                                            &marker_str);
	if(result == GLOBUS_SUCCESS)
	{
	    if(strcmp(marker_str, "100-125,200-225") == 0)
	    {
	        ok++;
	    }
	    globus_libc_free(marker_str);
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }

    /* 10. create a marker from a string, insert another range, and convert
     * back to a string
     */
    tests++;
    result = globus_ftp_client_restart_marker_from_string(&marker,
                                                          "100-125,200-225");
    if(result == GLOBUS_SUCCESS)
    {
        result = globus_ftp_client_restart_marker_insert_range(&marker,
	                                                       126,
							       199);
	if(result == GLOBUS_SUCCESS)
	{
            result = globus_ftp_client_restart_marker_to_string(&marker,
                                                                &marker_str);
	    if(result == GLOBUS_SUCCESS)
	    {
	        if(strcmp(marker_str, "100-225") == 0)
	        {
	            ok++;
	        }
	        globus_libc_free(marker_str);
	    }
	}
	(void) globus_ftp_client_restart_marker_destroy(&marker);
    }
   
    if(tests == ok)
    {
        printf("All %d tests successful\n", tests);
    }
    else
    {
        printf("%d of %d Tests FAILED\n", tests-ok, tests);
    }

    globus_module_deactivate_all();
    return 0;

  fail_tests:
    return -1;
}
