/**************************************************************************
*
* Program:      curses code
*               display.h
*
* Written at:   High-Performance Computing Laboratory
*               Department of Computer Science
*               Northern Illinois University
*               DeKalb, IL
*
* Authors:      Robert Bach
*               John Bresnahan
*
* Date Written: 2/97
*
* Description:
*
*     Curses code for talk.
*
**************************************************************************/

#ifndef URL_FILE
#define URL_FILE "/tmp/talk_url"
#endif

#define REMOTE_USER_TYPE 1
#define LOCAL_USER_TYPE 2

#define CTRL_X 24
#define CTRL_W 23
#define CTRL_U 21
#define CTRL_H 8
#define CTRL_R 18
#define BACK_SPACE 127 
#define ESC 27 
#define RETURN 13 

struct UserScreen {
  int row;
  int col;
  char user_name[80];
  int type;
  int StartRow;
  int MaxRow;
};

/*****************************************
*  InitScreen(local user, remote user)   *
*  -----------------------------------   *
*****************************************/
void InitScreen();
void IntroScreen(char *);
void StartTalk(struct UserScreen *, struct UserScreen *, char *);
void InitUser(struct UserScreen *, int);
void PartyLeft(struct UserScreen *);
void ThankYou();
void HelpYou();
/*****************************************
*  AddChar(user, character to add)       * 
*  -----------------------------------   *
*****************************************/
void AddChar(struct UserScreen *, char);

void WaitForConnection();
