/**************************************************************************
*
* Program:      curses code
*               display.c
*
* Written at:   High-Performance Computing Laboratory
*               Department of Computer Science
*               Northern Illinois University
*               DeKalb, IL
*
* Authors:      Robert Bach
*               John Bresnahan
*
* Date Written: 2/97
*
* Description:
*
*     Curses code for talk.
*
**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <curses.h>
#include <nexus.h>
#include "display.h"

#define EASTER_EGG " some one stole my hubcap "
char * global_blank;

WINDOW * main_scr;
int MaxX;
int MaxY;
int DisplayWidth;
int DisplayHeight;
int SectionHeight;
int LocalStartRow;
int RemoteStartRow;
int StartCol;
int MaxCol;
int SpinRow;
int SpinCol;

/*******************************************************************
*
*******************************************************************/
void InitScreen()
{
  int ctr;
 
  main_scr = initscr();


  getmaxyx(main_scr, MaxY, MaxX);


  StartCol = 3;
  MaxCol = MaxX - 3;
  DisplayWidth = MaxX - 1; 
  DisplayHeight = MaxY - 3; 
  SectionHeight = (DisplayHeight - 3) / 2; 
  LocalStartRow = SectionHeight + 4;
  RemoteStartRow = 3;
  SpinRow = 10;
  SpinCol = MaxCol / 2;

}

/*******************************************************************
*
*******************************************************************/
void IntroScreen(char * url)
{
  int row, col;
  int ctr;
  int s_size;
  char msg[33] = "Waiting for attachment on URL: ";

  clear();

  row = 2;
  col = (MaxCol - 21) / 2;
  move(row, col);
  attrset(A_REVERSE);
  addstr("Welcome To Nexus Talk"); 
  attroff(A_REVERSE);
  
  row = row + 2;
  col = (MaxCol - 46) / 2; 
  move(row, col);
  attrset(A_BOLD);
  addstr("Courtesy of the High-Performance Computing Lab"); 
  attroff(A_BOLD);
  
  row = row + 1;
  col = (MaxCol - 31) / 2; 
  move(row, col);
  attrset(A_BOLD);
  addstr("at Northern Illinois University"); 
  attroff(A_BOLD);
  
  row = row + 2;
  col = (MaxCol - 36) / 2;
  move(row, col);
  attrset(A_BLINK);
  addstr("Please wait while your party responds"); 
  attroff(A_BLINK);

  attrset(A_BOLD);
  s_size = strlen(msg) + strlen(url);
  row += 2;
  col = (MaxCol - s_size) / 2;
  move(row, col);
  addstr(msg);
  addstr(url);
  attroff(A_BOLD);

  refresh();
}

/*******************************************************************
*
*******************************************************************/
void StartTalk(struct UserScreen * usr1, struct UserScreen * usr2,
                char * url)
{
  int ctr;
  int x, y;
  int row, col;
  int s_size;
  int colors;
  char *top;
  char *lines;
  char *spaces;
  char nexus_talk[100] = "Attached using URL ";
  

  clear();
  strcat(nexus_talk, url);
  strcpy(usr1->user_name, "Local user");
  strcpy(usr2->user_name, "Remote user");
  s_size = strlen(nexus_talk);
  
  global_blank = (char *)malloc(MaxX + 1);
  lines = (char *)malloc(MaxX + 1);
  spaces = (char *)malloc(MaxX + 1);
  top = (char *)malloc(MaxX + 1);
  for(ctr = 0; ctr < MaxX; ctr++)  global_blank[ctr] = ' ';
  global_blank[MaxCol - 2] = '\0';

  for(ctr = 0; ctr < DisplayWidth; ctr++)
   { 
     lines[ctr] = '-';
     spaces[ctr] = ' ';
     top[ctr] = '=';
   }
  lines[ctr-1] = '\0';
  top[ctr-1] = '\0';
  spaces[ctr - 1] = '\0';
   
  row = RemoteStartRow - 2; 
 
  attrset(A_STANDOUT);
  col = (MaxCol - s_size) / 2; 
  move(row, col); 
  addstr(nexus_talk);
  attroff(A_STANDOUT);

  attrset(A_REVERSE);
  row++;
  move(row, 1); 
  addstr(top);
  row++;		
  for(ctr = 0; ctr < SectionHeight; ctr++)
   {
      move(row, 1); 
      addch('|');
      move(row, MaxCol + 1); 
      addch('|');
      row++;
   }
  move(row, 1); 
  addstr(lines);
  col = (MaxCol - 22) / 2;
  move(row, col);
  addstr("Press <CTRL+X> to quit.");
  row++;		
  for(ctr = 0; ctr < SectionHeight; ctr++)
   {
      move(row, 1); 
      addch('|');
      move(row, MaxCol + 1); 
      addch('|');
      row++;
   }
  move(row, 1); 
  addstr(top);

  InitUser(usr1, REMOTE_USER_TYPE);
  InitUser(usr2, LOCAL_USER_TYPE);

  move(RemoteStartRow - 1, 5);
  addstr(usr1->user_name);
  move(LocalStartRow + SectionHeight, 5);
  addstr(usr2->user_name);

  move(LocalStartRow, StartCol);
  
  attroff(A_REVERSE);

  refresh();
}


/*******************************************************************
*
*******************************************************************/
void InitUser(struct UserScreen * user, int type)
{
  user->type = type;
  user->col = StartCol;

  if(type == REMOTE_USER_TYPE)
   {
     user->row = RemoteStartRow;
     user->StartRow = RemoteStartRow;
   }
  else
   {
     user->row = LocalStartRow;
     user->StartRow = LocalStartRow;
   }
  user->MaxRow = user->row + SectionHeight - 1;
}

/*******************************************************************
*
*******************************************************************/
void AddChar(struct UserScreen * user, char ch)
{
  int ctr;
  int hold_x;
  int hold_y;
  char hold_ch;
  static int egg = 0;

  attrset(A_BOLD);

  if(user->type == REMOTE_USER_TYPE)
   {
     attroff(A_BOLD);
   }

  if(ch == RETURN)
   {
     user->row++;
     if(user->row > user->MaxRow) 
                       user->row = user->StartRow; 
     user->col = StartCol;
     move(user->row, user->col - 1);
     addstr(global_blank);
     move(user->row, user->col);
   }
 else if(ch == CTRL_W && user->col > StartCol)
   { 
     move(user->row, user->col - 1);

     hold_ch = inch();
     if(hold_ch == ' ')
      {
         (user->col) -= 1;
         move(user->row, user->col - 1);
         hold_ch = inch();
      }
     while(hold_ch != ' ' && user->col > StartCol)
      {
         addch(' ');
         (user->col) -= 1;
         move(user->row, user->col - 1);
         hold_ch = inch();
      }
     move(user->row, user->col);
   }
 else if(ch == CTRL_U)
   {
     user->col = StartCol;
     move(user->row, user->col - 1);
     addstr(global_blank);

     move(user->row, user->col);
   }
  else if(ch == CTRL_R)
   {
     for(ctr = user->StartRow; ctr <= user->MaxRow; ctr++)
      {
         move(ctr, StartCol - 1);
         addstr(global_blank); 
      } 
     move(user->StartRow, StartCol);
     user->row = user->StartRow;
     user->col = StartCol;
     if(egg < 2) egg++;
     else  egg = 0;
   }
  else if(ch == BACK_SPACE  || ch == CTRL_H)
   {
     if(user->col > StartCol) 
      {
        user->col--;
        move(user->row, user->col);
        addch(' ');
        move(user->row, user->col);
      } 
    if(egg > 1) egg++;
   }
  else if(ch > 31 && ch < 127)
   {
     move(user->row, user->col);
     addch(ch);
     user->col++;
     if(user->col > MaxCol - 1)
       {
         user->col = StartCol;
         user->row++;
         if(user->row > user->MaxRow) 
                            user->row = user->StartRow; 
         move(user->row, user->col);
         addstr(global_blank);
       }
     move(user->row, user->col);
     if(egg > 2/* && ch == 'J'*/)
       addstr(EASTER_EGG);
     egg = 0;
   }
  attroff(A_BOLD);
  refresh(); 
}

/*******************************************************************
*
*******************************************************************/
void WaitForConnection()
{
  static int ctr = 0;
  char ch;

  if(ctr == 0) ch = '\\';
  else if(ctr == 1) ch = '-';
  else if(ctr == 2) ch = '/';
  else if(ctr == 3) ch = '|';
  else              ctr = -1;

  move(SpinRow, SpinCol);
  addch(ch);
  refresh();
  ctr++;

}

/*******************************************************************
*
*******************************************************************/
void PartyLeft(struct UserScreen * usr)
{
  char msg[35] = "Your party has quit nexus talk";
  char msg2[35] = "Press any key to exit";
  int ctr, s_size;
  int row, col;

  attrset(A_REVERSE);

  s_size = strlen(msg);
  row = (SectionHeight / 2) + usr->StartRow;
  col = (MaxCol - s_size) / 2;
  move(row, col);
  addstr(msg);
  attroff(A_REVERSE);

  attrset(A_BLINK);
  s_size = strlen(msg2);
  row++;
  col = (MaxCol - s_size) / 2;
  move(row, col);
  addstr(msg2);
  attroff(A_BLINK);

  refresh();
}

void ThankYou()
{
  system("clear");
  printf("Thank you for using NEXUS TALK\n");
}

void HelpRtn()
{
  printf("\nnexus talk\n");
  printf("------------\n");

  printf("\ntalk_server must be running prior to executing talk_client.\n");
  printf("If both parties are on the same machine they need not know the\n");
  printf("url of the talk_server and only have to type \"talk_client\" to \n");
  printf("initiate the session.  In all other cases the talk_client user \n");
  printf("must specify the url of the talk_server on the command line.\n");
  printf("EX: talk_client -s x-nexus://olympus:54184/.\n");

}
