
#include <stdio.h>
#include "globus_common.h"
#include "globus_nexus.h"

#define RCV_HANDLER_ID 0

/*
 *      
 * MAIN 
 *      
 */

int 
main(
    int       argc, 
    char *    argv[])
{
    char attach_url[1024];
    globus_nexus_startpoint_t server_sp;
    globus_nexus_buffer_t buffer;
    int an_int;
    int rc;

    /*
     * Module activation: we are using the common and the nexus module 
     */

    rc = globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);

    rc = globus_module_activate(GLOBUS_NEXUS_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);


    /*
     * check for correct command prompt usage and get
     * the attach_url specified in the command line  
     */

    if (argc == 3 && !strncmp(argv[1], "x-nexus://", strlen("x-nexus://")))
    {
	strcpy(attach_url, argv[1]);
	an_int = atoi(argv[2]);
    }
    else
    {
	/* libc functions are usually not re-entrant. Re-entrant functions */
	/* are provided in the Globus COMMON module: They perform the      */
	/* necessary locks.                                                */
	globus_libc_fprintf(stderr, "usage: %s <attach_url> <int>\n", argv[0]);
	globus_module_deactivate_all();
	exit(1);
    } /* endif */

    /*
     * attaching to server
     */

    /*
     * Attachment in Nexus is done by making a request to attach to another
     * process designated by a URL.  If the request is granted, we get a 0
     * return code and a startpoint that points back to the granting process.
     */

    rc = globus_nexus_attach(attach_url, &server_sp);

    /* if things went OK, we now have a startpoint */
    /* (server_sp) to the single_rsr_server        */

    if (rc != GLOBUS_SUCCESS)
    {
        globus_libc_fprintf( 
	    stderr, 
	    "ERROR: Could not attach to server using url: %s\n", 
	    attach_url);
	globus_module_deactivate_all();
	exit(1);
    }

    /*
     * remote service request 
     */

    /*
     * send a RSR containing the integer provided in argv[2] to the server
     * we just connected to.
     *
     * First, we need to initialize a nexus buffer to hold a single integer
     */
    globus_nexus_buffer_init(&buffer, nexus_sizeof_int(1), 0);

    /* placing single integer into buffer */
    globus_nexus_put_int(&buffer, &an_int, 1);

    /* sending buffer to single_rsr_server and invoking rcv_handler() there */

    globus_nexus_send_rsr( &buffer,        /* buffer */
			   &server_sp,     /* destination */
			   RCV_HANDLER_ID, /* handler id */
			   GLOBUS_TRUE,    /* destroy buffer when done */
			   GLOBUS_FALSE);  /* non-threaded handler */

    /*
     * Clean-up 
     */

    globus_nexus_startpoint_destroy(&server_sp);

    globus_module_deactivate_all();
    exit(0);

} /* end main() */





