/*
 * myjobtest.c
 *
 * This file showcases the gram_myjob functionality. It produces the
 * standard "hello world from rank %d" message.
 */

#include "globus_common.h"
#include "globus_gram_myjob.h"


int 
main( 
    int       argc,  
    char *    argv[] )
{
    int	       rc;
    int        myjob_size;
    int        myjob_rank;
    char       my_hostname[256];

    /*
     * Module activation: common, gass_file and gram_myjob are used.
     */
    rc = globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);

    rc = globus_module_activate(GLOBUS_GRAM_MYJOB_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);

    /*
     * Get hostname
     */
    if (globus_libc_gethostname(my_hostname, 256) != GLOBUS_SUCCESS )
        strcpy(my_hostname, "UNKNOWN");

    rc = globus_gram_myjob_rank(&myjob_rank);
    globus_assert(rc == GLOBUS_SUCCESS);

    rc = globus_gram_myjob_size(&myjob_size);
    globus_assert(rc == GLOBUS_SUCCESS);

    globus_libc_printf( "%d: local host %s: myjob size=%d\n",
			myjob_rank,
			my_hostname,
			myjob_size );

    if (myjob_size > 1)
    {
	/* 
	 * TODO: if myjob_rank == 0, send a message to all other ranks
	 * using globus_gram_myjob_send(). The other processes must issue
	 * a globus_gram_myjob_receive().
	 *
	 * See the GRAM_MYJOB API for more information.
	 */
    }
    
    rc = globus_module_deactivate_all();
    globus_assert(rc == GLOBUS_SUCCESS);

    return(0);
}
/* main */









