/*
 * withgass.c
 *
 * copy utility program: extended to use the GASS file module
 */

#include <stdio.h>
#include <stdlib.h>

#include <globus_common.h>
#include <globus_gass_file.h>

int 
main(
    int       argc, 
    char *    argv[])
{
    FILE   *in;
    FILE   *out;
    char   buffer[1024];
    int    n;

    if (argc < 3)
    {
	fprintf(stderr,"provide arguments <source file> <destination file>\n");
	exit(1);
    }

    /* TODO: activate the GASS_FILE module here */
    globus_module_activate(GLOBUS_GASS_FILE_MODULE);

    /* TODO: change fopen() to globus_gass_fopen */

    in = globus_gass_fopen(argv[1],"r");
    if (in < 0)
    {
	fprintf(stderr, "Can not read from %s\n", argv[1]);
	exit(1);
    }

    out = globus_gass_fopen(argv[2],"w");
    if (out < 0)
    {
	fprintf(stderr, "Can not write to %s\n", argv[2]);
	exit(1);
    }

    while (!feof(in))
    {
	n = fread(buffer,sizeof(char),1024,in);
	if (n>0) fwrite(buffer,sizeof(char),n,out);
    }

    /* TODO: change fclose() to globus_gass_fclose */
    if(globus_gass_fclose(in) < 0)
    {
	fprintf(stderr, "Can not close %s\n", argv[1]);
	exit(1);
    }
    
    if(globus_gass_fclose(out) < 0)
    {
	fprintf(stderr, "Can not close %s\n", argv[2]);
	exit(1);
    }

    fprintf(stderr, "Successfully copied %s to %s\n", argv[1], argv[2]);

    /* TODO: GASS_FILE module deactivation */
    globus_module_deactivate(GLOBUS_GASS_FILE_MODULE);

    return 0;
}
/* main */




