/*
 * duroctestruntime.c
 *
 * a program using the duroc barrier call to wait for all subjob
 * processes to get start and running. if argv[1] is defined, the
 * program will sleep for that many seconds before continuing.
 */

#include "globus_common.h"
#include "globus_duroc_runtime.h"

#include <time.h>

int main(
    int       argc, 
    char *    argv[])
{
    int      rc;
    int      usecs;
    char     hn[256];       /* hostname    */
    pid_t    pid;           /* process id  */
    char     buf[30];       /* posix requires minimum 26 */
    time_t   mytime;
    char *   timestr;
    
    /*
     * module activation
     */
    
    rc = globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);
    
    globus_module_activate(GLOBUS_DUROC_RUNTIME_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);
    
    /*
     * check for argument for an optional sleep period.
     */
    
    if (argc > 1)
    {
	usecs = atoi(argv[1]) * 1000000;
	globus_libc_usleep(usecs);
    }

    /*
     * get process id and hostname
     */
    pid = getpid();

    rc = globus_libc_gethostname(hn, 256);
    globus_assert(rc == GLOBUS_SUCCESS);

    /*
     * get current time and convert to string format. setting [25] to 
     * zero will strip the newline charater.
     */
    mytime = time(GLOBUS_NULL);
    timestr = globus_libc_ctime_r( &mytime, buf, 30 );
    timestr[25] = '\0';

    globus_libc_printf("%s : process %d on %s came to life\n", 
		       timestr, pid, hn);

    /*
     * THE BARRIER!!!
     */
    globus_duroc_runtime_barrier();

    /*
     * Passed the barrier: get current time again and print it out.
     */
    mytime = time(GLOBUS_NULL);
    timestr = globus_libc_ctime_r( &mytime, buf, 30 );
    globus_libc_printf("%s : process %d on %s passed the barrier\n",
		       timestr, pid, hn);

    /*
     * TODO 1: get the layout of the DUROC job using first
     *         globus_duroc_runtime_intra_subjob_rank() and then
     *         globus_duroc_runtime_inter_subjob_structure().
     */

    /*
     * We are done.
     */
    rc = globus_module_deactivate_all();
    globus_assert(rc == GLOBUS_SUCCESS);

    return 0;
}
/* main */
