/* activation.c
 *
 * this file demonstrates module activation/deactivation,
 * and how to make use of the portable libc libraries
 * that are included in the common module.
 */

/* module header file */
#include "globus_common.h"


int 
main( 
    int      argc, 
    char *   argv[] )
{
    int      rc;
    char *   hostname;

    /* 
     * Module activation. Each module XXX has defined a
     * unique module descriptor GLOBUS_XXX_MODULE.
     * 
     * globus_assert() will exit the program if statement
     * is not true.
     */

    rc = globus_module_activate(GLOBUS_COMMON_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);

    /*
     * globus_libc_malloc() and globus_libc_free() are provided.
     */
    
    hostname = globus_libc_malloc( 256 );
    
    rc = globus_libc_gethostname( hostname, 256 );
    globus_assert(rc == GLOBUS_SUCCESS);

    globus_libc_printf("Hello, world from %s!\n", hostname);
		
    globus_libc_free( hostname );
      
    /* 
     * To avoid memory leaks, always deactivate all the
     * modules that were previously activated.
     */

    rc = globus_module_deactivate(GLOBUS_COMMON_MODULE);
    globus_assert(rc == GLOBUS_SUCCESS);

    return 0;
}


