
AC_DEFUN(LAC_SSL_ARGS,
[
dnl Allow the user to supply the SSL path
AC_ARG_WITH(ssl-path,
        [  --with-ssl-path=DIR           use SSL files in DIR],
        [if test `echo "$withval" | cut -c1-1` = "/" 
         then
                 ssl_path="$withval"
         else
                 ssl_path="lac_base_path/$withval"
         fi
        ],
        [ssl_path="/usr/local/ssl"])

AC_SUBST(ssl_path)

found_ssl_h=""
if test "$globus_cv_gssapi_ssleay_enable" = "yes" ; then
  AC_MSG_CHECKING(for SSLeay/OpenSSL headers in $ssl_path)

  if test -f $ssl_path/include/ssl.h ; then 
     AC_MSG_RESULT($ssl_path/include/ssl.h)
  elif test -f $ssl_path/include/openssl/ssl.h ; then
     AC_MSG_RESULT($ssl_path/include/openssl/ssl.h)
     globus_cv_pkcs12_enable=no
     AC_MSG_RESULT(Building with OpenSSL, skipping pkcs12)
  else
     AC_MSG_RESULT(failed)
     AC_MSG_ERROR(Could not locate ssl.h)
  fi
fi

AC_CACHE_CHECK(GSI Local Base DN, gsi_cv_local_base_dn, [dnl
AC_ARG_WITH(gsi-base-dn,
	[  --with-gsi-base-dn=value        DN of the local site],
	[gsi_cv_local_base_dn="$withval"],
	[gsi_cv_local_base_dn="Not Configured"])
])

AC_CACHE_CHECK(GSI CA Name, gsi_cv_ca_name, [dnl
    gsi_cv_ca_name="Globus CA"
])

AC_CACHE_CHECK(GSI CA Email Address, gsi_cv_ca_email_addr, [dnl
    gsi_cv_ca_email_addr="ca@globus.org"
])

])

AC_DEFUN(LAC_SSL,
[
   LAC_SSL_ARGS
])


