
dnl LAC_SHARED_LIB_ARGS()
AC_DEFUN(LAC_SHARED_LIB_ARGS,
[
AC_ARG_ENABLE(sharedlib,
	[  --enable-sharedlib            enable building of shared libraries],
	[lac_cv_build_shared="$enableval"],
	[lac_cv_build_shared=${lac_cv_build_shared='no'}])
])


dnl -----------------------------------------------------------------
dnl LAC_SHARED_LIB(
dnl
dnl Determine what flags and commands are
dnl needed to generate shared libraries
dnl
dnl Uses globus_cv_system_type and globus_cv_threads_type
dnl rather than arguments, so these values can be probed once
dnl and cached while this macro sets up Makefile subsitutions
dnl and must be called in every configure.in
dnl
dnl Because almost every different vendor
dnl use a completely non-portable set of
dnl flags and procedures, this macro
dnl pretty much has to end up being a
dnl big case statement.
dnl -------------------------------------------------------------------
AC_DEFUN(LAC_SHARED_LIB,
[
SHARED_CFLAGS=""
SHARED_LDFLAGS=""
LIBEXT="a"
MK_SHARED_LIB=""
makefile_link="makefile.lnk.static"

if test "$lac_cv_build_shared" = "yes"; then
    lac_found_shared="no"
    case "$globus_cv_system_type--$CC" in
        *-hp-hpux*--*gcc )
            makefile_link="makefile.lnk.shared"
            SHARED_CFLAGS='-fPIC'
            MK_SHARED_LIB='ld -b -o $[@]'
            lac_found_shared="yes"
        ;;
        *-hp-hpux*--*cc )
            makefile_link="makefile.lnk.shared"
            SHARED_CFLAGS='+Z'
            MK_SHARED_LIB='ld -b -o $[@]'
            lac_found_shared="yes"
        ;;
        mips-sgi-irix*--*gcc )
            makefile_link="makefile.lnk.shared"
            LIBEXT="so"
            SHARED_CFLAGS='-fPIC'
            MK_SHARED_LIB='ld -shared -rdata_shared -soname `basename $[@]` -o $[@]'
            lac_found_shared="yes"
        ;;
        mips-sgi-irix5*--*cc )
            makefile_link="makefile.lnk.shared"
            LIBEXT="so"
            SHARED_CFLAGS='-KPIC'
            MK_SHARED_LIB='ld -shared -rdata_shared -soname `basename $[@]` -o $[@]'
            lac_found_shared="yes"
        ;;
        mips-sgi-irix6*--*cc )
            makefile_link="makefile.lnk.shared"
            LIBEXT="so"
            SHARED_CFLAGS=''
            LIBPREFIX="lib"
            MK_SHARED_LIB='$(CC) -shared -rdata_shared -soname `basename $[@]` -o $[@]'
            lac_found_shared="yes"
        ;;
        *-*-linux*--*gcc )
            makefile_link="makefile.lnk.shared"
            SHARED_CFLAGS='-fPIC'
            MK_SHARED_LIB="gcc -o \$[@].\$(REL_VERSION) -shared -Wl,-soname,\`basename \$[@].\$(ABI_VERSION)\`,-stats"
            dnl   SHARED_LDFLAGS='-Wl,-rpath,../lib'
            lac_found_shared="yes"
        ;;
        *-*-netbsd*--*gcc )
            makefile_link="makefile.lnk.shared"
            SHARED_CFLAGS='-fpic -DPIC'
            MK_SHARED_LIB='ld -Bshareable -o $[@]'
            lac_found_shared="yes"
        ;;
        *-*-osf1*--* )
            makefile_link="makefile.lnk.shared"
            MK_SHARED_LIB="ld -o \$[@].\$(REL_VERSION) -shared -soname \`basename \$[@].\$(ABI_VERSION)\`"
            dnl   SHARED_LDFLAGS='-Wl,-rpath,../lib'
            lac_found_shared="yes"
        ;;
        *-ibm-aix3*--*cc | *-ibm-aix3*--*xlc* )
            makefile_link="makefile.lnk.shared.aix3"
            if test "$globus_cv_threads_type" != "no" ; then
                MK_SHARED_LIB="-L/usr/lib/dce -lpthreads -lc_r"
            fi
            lac_found_shared="yes"
        ;;
        *sunos5*--*gcc | *solaris2*--*gcc )
            makefile_link="makefile.lnk.shared.cc"
            LIBEXT="so"
            SHARED_CFLAGS="-fpic -shared"
            MK_SHARED_LIB="-fpic -shared"
            lac_found_shared="yes"
        ;;
        *sunos5*--*cc | *solaris2*--*cc )
            makefile_link="makefile.lnk.shared.cc"
            LIBEXT="so"
            SHARED_CFLAGS="-KPIC"
            MK_SHARED_LIB="-KPIC -G"
            lac_found_shared="yes"
        ;;
        *sunos4*--*gcc | *solaris1*--*gcc )
            makefile_link="makefile.lnk.shared.cc"
            LIBEXT="so"
            SHARED_CFLAGS="-fpic -shared"
            MK_SHARED_LIB="-fpic -shared"
            lac_found_shared="yes"
        ;;
        *-*-sysv4--* )
            makefile_link="makefile.lnk.shared"
            SHARED_CFLAGS='-KPIC'
            MK_SHARED_LIB='ld -d y -G -o $[@]'
            LIBEXT="so"
            lac_found_shared="yes"
        ;;
        i*86-*-cygwin*--* )
            makefile_link="makefile.lnk.shared.cygwin"
            SHARED_CFLAGS='-KPIC'
            MK_SHARED_LIB='ld -d y -G -o $[@]'
            LIBEXT="dll"
            lac_found_shared="yes"
        ;;
    esac
    AC_MSG_CHECKING(how to make shared libraries)
    if test "$lac_found_shared" = "yes"; then
        AC_MSG_RESULT(found)
    else
        AC_MSG_RESULT(not found)
    fi
else
    makefile_link="makefile.lnk.static"
    LIBPREFIX="lib"
    LIBEXT="a"
fi

makefile_link=$srcdir/lac_config_path/$makefile_link
AC_SUBST(SHARED_CFLAGS)	
AC_SUBST(SHARED_LDFLAGS)
AC_SUBST(LIBPREFIX)
AC_SUBST(LIBEXT)
AC_SUBST(MK_SHARED_LIB)
AC_SUBST_FILE(makefile_link)
])
