
AC_DEFUN(LAC_NEXUS_ARGS,
[

AC_ARG_ENABLE(macros,
	[  --disable-macros              use function calls instead of macros],
	[lac_cv_macros="$enableval"],
	[lac_cv_macros=${lac_cv_macros='yes'}])

dnl AC_ARG_ENABLE(profile,
dnl	[  --enable-profile              compile in profiling features],
dnl	[lac_cv_profile="$enableval"],
dnl	[lac_cv_profile=${lac_cv_profile='no'}])
lac_cv_profile='no'

AC_ARG_ENABLE(critical-path-timer,
	[  --enable-critical-path-timer  time the critical path],
	[lac_cv_critical_path_timer="$enableval"],
	[lac_cv_critical_path_timer=${lac_cv_critical_path_timer='no'}])

AC_ARG_ENABLE(poll-range-checking,
	[  --enable-poll-range-checking  check poll ranges],
	[lac_cv_poll_range_checking="$enableval"],
	[lac_cv_poll_range_checking=${lac_cv_poll_range_checking='no'}])

AC_ARG_ENABLE(resource,
	[  --enable-resource		nexus resource abstractions],
	[lac_cv_resource="$enableval"],
	[lac_cv_resource=${lac_resource='no'}])

AC_ARG_ENABLE(qos,
	[  --enable-qos			quality of service overseer],
	[lac_cv_qos="$enableval"],
	[lac_cv_qos=${lac_qos='no'}])

proto_tcp="notset"
proto_udp="notset"
globus_cv_nxproto_totem="notset"
proto_shm="notset"

AC_ARG_WITH(tcp,
	[  --with-tcp                    include the TCP/IP protocol],
	[proto_tcp="$withval"],
	[proto_tcp="notset"])

AC_ARG_WITH(udp,
	[  --with-udp                    include the UDP/IP protocol],
	[proto_udp="$withval"],
	[proto_udp="notset"])

AC_ARG_WITH(totem,
	[  --with-totem                  include the Totem protocol],
	[globus_cv_nxproto_totem="$withval"],
	[globus_cv_nxproto_totem="notset"])

AC_ARG_WITH(shm,
	[  --with-shm                    include the System V shared memory protocols],
	[proto_shm="$withval"],
	[proto_shm="notset"])
])

dnl doced out xtp
dnl bresnaha
dnl AC_DEFUN(LAC_GLOBUS_NEXUS_PROTO_XTP_ARGS,
dnl [
dnl globus_cv_nxproto_xtp="notset"
dnl 
dnl AC_ARG_WITH(xtp,
dnl 	    [  --with-xtp                include the XTP protocol],
dnl 	    [globus_cv_nxproto_xtp='yes' ;
dnl 	     globus_cv_nxproto_xtp_dirs="$withval"],
dnl 	    [globus_cv_nxproto_xtp=${globus_cv_nxproto_xtp='no'} ;
dnl 	     globus_cv_nxproto_xtp_dirs=${globus_cv_nxproto_xtp_dirs=''}])
dnl 
dnl if test "$globus_cv_nxproto_xtp" = "yes" ; then
dnl     changequote(<<,>>)dnl
dnl     globus_cv_nxproto_xtp_xdir="`echo ${globus_cv_nxproto_xtp_dirs} | sed 's/^\([^:]*\):.*$/\1/'`"
dnl     globus_cv_nxproto_xtp_mdir="`echo ${globus_cv_nxproto_xtp_dirs} | sed 's/^[^:]*:\(.*\)$/\1/'`"
dnl     changequote([,])dnl
dnl 
dnl     if test "$globus_cv_nxproto_xtp_xdir" = "yes" || test ! -d "$globus_cv_nxproto_xtp_xdir" ; then
dnl 	AC_MSG_WARN([usage: --with-xtp=xtpdir:mtldir])
dnl 	AC_MSG_ERROR([invalid XTP directory])
dnl     fi

dnl     if test "$globus_cv_nxproto_xtp_mdir" = "yes" || test ! -d "$globus_cv_nxproto_xtp_mdir" ; then
dnl 	AC_MSG_WARN([usage: --with-xtp=xtpdir:mtldir])
dnl 	AC_MSG_ERROR([invalid MTL directory])
dnl     fi
dnl fi
dnl ])


AC_DEFUN(LAC_NEXUS,
[

LAC_NEXUS_ARGS

if test "$lac_cv_macros" = "yes" ; then
    AC_DEFINE(BUILD_USING_MACROS)
fi

if test "$lac_cv_profile" = "yes" ; then
    AC_DEFINE(BUILD_PROFILE)
fi

if test "$lac_cv_critical_path_timer" = "yes" ; then
    AC_DEFINE(NEXUS_CRITICAL_PATH_TIMER)
fi

if test "$lac_cv_poll_range_checking" = "yes" ; then
    AC_DEFINE(NEXUS_POLL_RANGE_CHECK)
fi

if test "$lac_cv_qos" = "yes" ; then
    lac_cv_resource="yes"
    AC_DEFINE(HAVE_QOS)
    AC_DEFINE(BUILD_RESOURCE)
    shared_overseer_objs="$shared_overseer_objs overseer_qos.\$(OFILE) qoslib.\$(OFILE)"
fi

if test "$lac_cv_resource" = "yes" ; then
    AC_DEFINE(BUILD_RESOURCE)
fi

if test "$lac_cv_debug" = "yes"; then
    AC_DEFINE(BUILD_DEBUG)
fi

if test "$lac_threads_type" = "no" ; then
    AC_DEFINE(BUILD_LITE)
fi

dnl
dnl Figure out all of the protocol and transform modules
dnl
shared_proto_objs=""
static_proto_objs=""
shared_transform_objs=""
static_transform_objs=""

LAC_SYS_MPI
LAC_SYS_MPL
LAC_SYS_INX
LAC_SYS_TCP_UDP
LAC_SYS_TOTEM
dnl LAC_SYS_XTP
LAC_SYS_SHM

#shared_transform_objs="transform_gzip.\$(OFILE)"

NEXUS_SHARED_PROTO_OBJS="$shared_proto_objs"
NEXUS_STATIC_PROTO_OBJS="$static_proto_objs"
NEXUS_SHARED_TRANSFORM_OBJS="$shared_transform_objs"
NEXUS_STATIC_TRANSFORM_OBJS="$static_transform_objs"
NEXUS_SHARED_OVERSEER_OBJS="$shared_overseer_objs"
NEXUS_STATIC_OVERSEER_OBJS="$static_overseer_objs"
AC_SUBST(NEXUS_SHARED_PROTO_OBJS)
AC_SUBST(NEXUS_STATIC_PROTO_OBJS)
AC_SUBST(NEXUS_SHARED_TRANSFORM_OBJS)
AC_SUBST(NEXUS_STATIC_TRANSFORM_OBJS)
AC_SUBST(NEXUS_SHARED_OVERSEER_OBJS)
AC_SUBST(NEXUS_STATIC_OVERSEER_OBJS)

NEXUS_TH_MODULE="th_p0"
NEXUS_MD_MODULE="md_unix"
NEXUS_NL_MODULE="nl_file"
AC_SUBST(NEXUS_TH_MODULE)
AC_SUBST(NEXUS_MD_MODULE)
AC_SUBST(NEXUS_NL_MODULE)

LAC_DATA_CONVERSION

dnl
dnl Miscellaneous other checks
dnl
LAC_NEXUS_ALIGN
LAC_CHECK_SELECT_PROTOTYPE
AC_TYPE_SIGNAL  dnl #define RETSIGTYPE to int or void
LAC_SYS_X_ACC
LAC_SYS_X_OK

])


dnl AC_DEFUN(LAC_GLOBUS_NEXUS_PROTO_XTP,
dnl [
dnl     LAC_GLOBUS_NEXUS_PROTO_XTP_ARGS
dnl 
dnl     if test "${globus_cv_nxproto_xtp}" = "yes" ; then
dnl     	XTP_CFLAGS="-I${globus_cv_nxproto_xtp_xdir}/include -I${globus_cv_nxproto_xtp_mdir}/include" 
dnl     	XTP_LDFLAGS="-L${globus_cv_nxproto_xtp_xdir}/lib -L${globus_cv_nxproto_xtp_mdir}/lib"
dnl     	XTP_LIBS="-lxtp -lmtl"
dnl     else
dnl 	XTP_CFLAGS=""
dnl 	XTP_LDFLAGS=""
dnl 	XTP_LIBS=""
dnl     fi
dnl     
dnl     AC_SUBST(XTP_CFLAGS)
dnl     AC_SUBST(XTP_LDFLAGS)
dnl     AC_SUBST(XTP_LIBS)
dnl ])


dnl ---------------------------------------------------------------------
dnl LAC_SYS_TCP_UDP()
dnl
dnl Determine if this system supports TCP/IP communication.
dnl Add pr_tcp to the build if it does.
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_TCP_UDP,
[
AC_CHECK_FUNCS(socket connect listen bind accept select getsockname,
                [have_tcp_funcs="yes"],
                [have_tcp_funcs="no"])
AC_CHECK_FUNCS(sysconf, [ ] , [ ] )
if test "$have_tcp_funcs" = "yes" ; then
    AC_DEFINE(HAVE_TCP)
    if test "$proto_tcp" != "no" ; then
        proto_tcp="yes"
        AC_DEFINE(HAVE_TCP_PROTO)
    fi
    if test "$proto_udp" != "no" ; then
        proto_udp="yes"
        AC_DEFINE(HAVE_UDP_PROTO)
    else
        proto_udp="no"
    fi
        shared_proto_objs="$shared_proto_objs pr_tcp.\$(OFILE)"
        shared_proto_objs="$shared_proto_objs pr_udp.\$(OFILE)"
fi
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_TOTEM()
dnl
dnl Determine if this system supports totem
dnl Add pr_totem to the build if it does.
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_TOTEM,
[
AC_CHECK_FUNCS(socket connect listen bind accept select getsockname,
                [],
                [globus_cv_nxproto_totem="no"])
AC_CHECK_FUNCS(sysconf, [ ] , [ ] )
if test "$globus_cv_nxproto_totem" = "yes" ; then
    AC_DEFINE(HAVE_TOTEM_PROTO)
fi
    shared_proto_objs="$shared_proto_objs pr_totem.\$(OFILE)"
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_XTP()
dnl
dnl Determine if this system supports XTP
dnl Add pr_xtp to the build if it does.
dnl ---------------------------------------------------------------------
dnl AC_DEFUN(LAC_SYS_XTP,
dnl [
dnl if test "$globus_cv_nxproto_xtp" = "yes" ; then
dnl     AC_DEFINE(HAVE_XTP_PROTO)
dnl 
dnl fi
dnl     shared_proto_objs="$shared_proto_objs pr_xtp.\$(OFILE)"
dnl ])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_SHM()
dnl
dnl Determine if this system supports System V
dnl shared memory communication.
dnl Add pr_shm to the build if it does.
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_SHM,
[
if test "$proto_shm" = "yes" ; then
    AC_CHECK_HEADERS(sys/ipc.h sys/sem.h sys/shm.h, 
                      [], [proto_shm="no"])
    if test "$proto_shm" != "no"; then
        AC_DEFINE(HAVE_SHM_PROTO)
        AC_TRY_COMPILE(
            #include <sys/ipc.h>
            #include <sys/sem.h> 
            ,
            union semun foo;
            ,
            [AC_DEFINE(HAVE_UNION_SEMUN)] )
    fi
fi
        shared_proto_objs="$shared_proto_objs pr_shm.\$(OFILE)"
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_MPL()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_MPL,
[
dnl LAC_COMPILERS_* must be called before this
if test "$lac_mpl" = "yes" ; then
    AC_DEFINE(HAVE_MPL_PROTO)
    
fi
    shared_proto_objs="$shared_proto_objs pr_mpl.\$(OFILE)"
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_MPI()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_MPI,
[
dnl LAC_COMPILERS_* must be called before this
if test "$lac_mpi" = "yes" ; then
    AC_DEFINE(HAVE_MPI_PROTO)
    
fi
    shared_proto_objs="$shared_proto_objs pr_mpi.\$(OFILE)"
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_INX()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_INX,
[
dnl LAC_COMPILERS_* must be called before this
if test "$lac_inx" = "yes" ; then
    AC_DEFINE(HAVE_INX_PROTO)
fi
    shared_proto_objs="$shared_proto_objs pr_inx.\$(OFILE)"
])

dnl ---------------------------------------------------------------------
dnl LAC_SYS_X_ACC()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_X_ACC,
[AC_MSG_CHECKING(for X_ACC)
    AC_CACHE_VAL(lac_cv_sys_x_acc, [dnl
	AC_EGREP_CPP(zowie,
[#include <unistd.h>
#ifdef X_ACC
    zowie
#endif
], lac_cv_sys_x_acc="yes", lac_cv_sys_x_acc="no") dnl --End AC_EGREP_CPP()
]) dnl --End AC_CACHE_VAL()
    if test "$lac_cv_sys_x_acc" = "yes"; then
	AC_DEFINE(HAVE_X_ACC)
    fi
    AC_MSG_RESULT($lac_cv_sys_x_acc)
]) dnl --End AC_SYS_ACC()

dnl ---------------------------------------------------------------------
dnl LAC_SYS_X_OK()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_X_OK,
[AC_MSG_CHECKING(for X_OK)
AC_CACHE_VAL(lac_cv_sys_x_ok, [dnl
AC_EGREP_CPP(zowie,
[#include <unistd.h>
#ifdef X_OK
  zowie
#endif
], lac_cv_sys_x_ok="yes", lac_cv_sys_x_ok="no")
dnl
dnl --Of course gcc on the NeXT is braindead, so it doesn't include the
dnl --right header files, so we have to check special for it!!!
dnl
lac_cv_sys_x_ok="yes"
])
if test "$lac_cv_sys_x_ok" = "yes"; then
  AC_DEFINE(HAVE_X_OK)
fi
AC_MSG_RESULT($lac_cv_sys_x_ok)
])


dnl ---------------------------------------------------------------------
dnl LAC_CHECK_SELECT_PROTOTYPE()
dnl ---------------------------------------------------------------------
dnl
dnl  --HP seems to think the prototype for select() should be:
dnl  --
dnl  --   int select(int, int *, int *, int *, struct timeval *);
dnl  --
dnl  --by putting the "correct" prototype in the source, it causes an
dnl  --error on any machine with a different prototype.  The strange
dnl  --thing is that the HP man pages show two examples; one using an
dnl  --int * and the other an fd_set *.  Best be safe and use what the
dnl  --compiler is expecting.
dnl  --
dnl  --IBM is even more strange.  They have the prototype for select()
dnl  --in the info pages as:
dnl  --
dnl  --   int select(int,
dnl  --		     struct sellist *,
dnl  --		     struct sellist *,
dnl  --		     struct sellist *,
dnl  --		     struct timeval *);
dnl  --
dnl  --but the header files have it as (and xlc takes):
dnl  --
dnl  --   int select(unsigned long, void *, void *, void *, struct timeval *);
dnl  --
dnl  --This is very strange indeed.
dnl
AC_DEFUN(LAC_CHECK_SELECT_PROTOTYPE,
[AC_MSG_CHECKING(what type to use for select())
    AC_CACHE_VAL(lac_cv_fd_set_cast, [dnl
	AC_TRY_COMPILE(
#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>

#ifdef _CMA_REENTRANT_CLIB_
#include <dce/cma.h>
#endif

int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
,
    fd_set read_values;
    int rc;

    rc = select(0, &read_values, NULL, NULL, NULL);
,
    lac_cv_fd_set_cast="(fd_set *)"
,
    [case "$target" in
	*-ibm-aix* )
	    lac_cv_fd_set_cast="(void *)"
	;;
	*hpux* )
	    lac_cv_fd_set_cast="(int *)"
	;;
	*bsdi* )
	    lac_cv_fd_set_cast="(int *)"
	;;
	* )
	    lac_cv_fd_set_cast="notset"
	    echo "Please notify nexus@mcs.anl.gov that autoconf could"
	    echo "not detect the type for your select() system call."
	    echo "Please include your system type (OS, manufacturer, chip)"
	    echo "as well as a copy of /usr/include/sys/types.h and any"
	    echo "other file that is used for the select() call."
	    AC_MSG_ERROR(cannot compile without the correct information)
	;;
    esac]
	) dnl --End of AC_TRY_COMPILE()
    ]) dnl --End of AC_CACHE_VAL()

    AC_DEFINE_UNQUOTED(NEXUS_FD_SET_CAST,$lac_cv_fd_set_cast)
    AC_SUBST(NEXUS_FD_SET_CAST)
    AC_MSG_RESULT($lac_cv_fd_set_cast)
]) dnl --End of AC_CHECK_SELECT_PROTOTYPE()


dnl ---------------------------------------------------------------------
dnl LAC_SYS_SIGNAL_WAITING()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_SYS_SIGNAL_WAITING,
[ AC_MSG_CHECKING(for SIGWAITING)
  AC_CACHE_VAL(lac_cv_sys_signal_waiting, [dnl
  AC_EGREP_CPP(zowie,
[#include <signal.h>
#ifdef SIGWAITING
 zowie
#endif
], lac_cv_sys_signal_waiting="yes",
lac_cv_sys_signal_waiting="no")
])
  AC_MSG_RESULT($lac_cv_sys_signal_waiting)
  if test "$lac_cv_sys_signal_waiting" = "yes"; then
    AC_DEFINE(HAVE_SYS_SIGWAITING)
  fi
])

dnl ---------------------------------------------------------------------
dnl LAC_STRUCT_TBTABLE()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_STRUCT_TBTABLE,
[ AC_MSG_CHECKING(for struct tbtable tracebacks)
  AC_CACHE_VAL(lac_cv_struct_tbtable, [dnl
    lac_cv_struct_tbtable="no"
    AC_CHECK_HEADER(sys/debug.h,
      AC_EGREP_HEADER(tbtable, sys/debug.h, lac_cv_struct_tbtable="yes"))
  ])
  AC_MSG_RESULT($lac_cv_struct_tbtable)
  if test "$lac_cv_struct_tbtable" = "yes"; then
    AC_DEFINE(HAVE_STRUCT_TBTABLE)
  fi
])

dnl
dnl  --This is code that was adopted from the PAC_CHECK_COMPILER()
dnl  --macro in the mpich distriubtion
dnl  --
dnl  --I would like to use this once I check it works correctly as it
dnl  --would dramically reduce the amount of C code in this file.  And
dnl  --it would make it very easy to add/delete a test.
dnl  --

dnl Not this one is never called at present time
dnl SMF Fri Aug  1, 1997
AC_DEFUN(LAC_CHECK_PROGS,
[   if test "x$check_progs_dir" = "x" ; then
        $check_progs_dir="../config/test/nexus"
    fi
    for file in $check_progs_dir/*.c ; do
	base=`basename $file .c`
	AC_MSG_CHECKING(`cat $check_progs_dir/$base.check`)
	cp $file conftest.c
	rm -f conftest.cout conftest.rout
	if eval $CC $CFLAGS -o conftest conftest.c $LIBS > conftest.cout 2>&1 ; then
	    if test -s conftest ; then
		./conftest 2>&1 1> conftest.rout
		if test -s conftest.result ; then
		    AC_MSG_RESULT(`cat conftest.res`)
		    result_unknown="no"
		else
		    AC_MSG_RESULT(unknown)
		    result_unknown="yes"
		fi
		if test $? = 0 ; then
		    # it worked
		    if test "$result_unknow" = "yes" ; then
			echo "Program appeared to work, however"
		    fi
		else
		    # it didn't
		    cat $base.msg
		    if test -s conftest.cout ; then
			echo "Output from compile step was:"
			cat conftest.cout
		    fi
		    if test -s conftest.rout ; then
			echo "Output from run step was:
			cat conftest.rout
		    fi
		fi
	    fi
	else
	    echo "Program failed to compile."
	    cat $base.msg
	    if test -s conftest.cout ; then
		echo "Output from compile step was:"
		cat conftest.cout
	    fi
	fi
    done
]) dnl --End of AC_CHECK_PROGS()


dnl ---------------------------------------------------------------------
dnl LAC_NEXUS_ALIGN()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_NEXUS_ALIGN,
[
case "$target" in
    *)
        AC_DEFINE(NEXUS_ALIGN,8)
    ;;	
esac
])


dnl ---------------------------------------------------------------------
dnl LAC_DATATYPE_SIZES()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_DATATYPE_SIZES,[
if test "$cross_compiling" = "no"; then
    AC_C_BIGENDIAN
    AC_CHECK_SIZEOF(short)
    AC_CHECK_SIZEOF(long)
else
    case "$target" in
      i860-intel-osf* )
        ac_cv_c_bigendian=no
        ac_cv_sizeof_short=2
        ac_cv_sizeof_long=4
        ;;
      * )
        ac_cv_c_bigendian=yes
        ac_cv_sizeof_short=2
        ac_cv_sizeof_long=4
        ;;
    esac
    echo "guessing whether byte ordering is big endian... $ac_cv_c_bigendian"
    echo "guessing size of short... $ac_cv_sizeof_short"
    echo "guessing size of long... $ac_cv_sizeof_long"
fi
])


dnl ---------------------------------------------------------------------
dnl LAC_DATA_CONVERSION()
dnl ---------------------------------------------------------------------
AC_DEFUN(LAC_DATA_CONVERSION,
[
LAC_DATATYPE_SIZES

GLOBUS_DC_FORMAT_32BIT_LE=0
GLOBUS_DC_FORMAT_32BIT_BE=1
GLOBUS_DC_FORMAT_64BIT_LE=2
GLOBUS_DC_FORMAT_64BIT_BE=3
GLOBUS_DC_FORMAT_CRAYC90=4
GLOBUS_DC_FORMAT_JAVA=5
GLOBUS_DC_FORMAT_CRAYT3E=6

case "$ac_cv_sizeof_long-$ac_cv_c_bigendian" in
    "4-no" )
	GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_32BIT_LE
	GLOBUS_DC_FILE=globus_dc_32le
	;;
    "4-yes" )
	GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_32BIT_BE
	GLOBUS_DC_FILE=globus_dc_32be
	;;
    "8-no" )
	GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_64BIT_LE
	GLOBUS_DC_FILE=globus_dc_64le
	;;
    "8-yes" )
	if test "$ac_cv_sizeof_short" = "2" ; then
	    GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_64BIT_BE
	    GLOBUS_DC_FILE=globus_dc_64be
	elif test "$ac_cv_sizeof_short" = "4" ; then
	    GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_CRAYT3E
	    GLOBUS_DC_FILE=globus_dc_crayt3e
	else
	    GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_CRAYC90
	    GLOBUS_DC_FILE=globus_dc_crayc90
	fi
	;;
esac

AC_DEFINE_UNQUOTED(GLOBUS_DC_FORMAT_LOCAL,$GLOBUS_DC_FORMAT_LOCAL)
AC_SUBST(GLOBUS_DC_FILE)
])

